/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.action;

import java.sql.Connection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.cache.UserCache;
import org.bgerp.cache.UserNewsCache;
import org.bgerp.model.Pageable;
import ru.bgcrm.dao.NewsDAO;
import ru.bgcrm.model.News;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;

@ActionServlet.Action(path="/user/news", pathId=true)
public class NewsAction
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/user/news";
    public static final String UNREAD_NEWS_PERSONAL_KEY = "unreadNews";

    public ActionForward newsUpdate(DynActionForm form, Connection con) throws Exception {
        int requestUserId = form.getParamInt("requestUserId", 0);
        String kindOf = requestUserId > 0 ? "\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435" : "\u043d\u043e\u0432\u043e\u0441\u0442\u044c";
        int type = form.getParamInt("type");
        if (type < 0) {
            throw new BGMessageException("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0442\u0438\u043f \u043d\u043e\u0432\u043e\u0441\u0442\u0438", new Object[0]);
        }
        News news = new News();
        news.setId(form.getId());
        news.setUserId(form.getUserId());
        news.setTitle(form.getParam("title", ""));
        news.setDescription(form.getParam("description", ""));
        news.setPopup(type == 1);
        news.setLifeTime(form.getParamInt("lifeTime", 30));
        news.setReadTime(form.getParamInt("readTime", 24));
        if (Utils.isBlankString(news.getTitle())) {
            throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c " + kindOf + " \u0431\u0435\u0437 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430", new Object[0]);
        }
        if (Utils.isBlankString(news.getDescription())) {
            throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c " + kindOf + " \u0431\u0435\u0437 \u0442\u0435\u043a\u0441\u0442\u0430", new Object[0]);
        }
        Set<Integer> groups = form.getParamValues("group");
        ConfigMap perm = form.getPermission();
        Set<Integer> allowedGroups = Utils.toIntegerSet(perm.get("allowedGroupIds", ""));
        if (requestUserId == 0) {
            if (groups.size() > 0) {
                if (allowedGroups.size() > 0 && !CollectionUtils.containsAny(groups, allowedGroups)) {
                    throw new BGMessageException("\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0442\u044c \u043d\u043e\u0432\u043e\u0441\u0442\u0438 \u0434\u043b\u044f \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445 \u0433\u0440\u0443\u043f\u043f", new Object[0]);
                }
                new NewsDAO(con).updateNewsGroups(news, groups);
            } else {
                if (allowedGroups.size() > 0) {
                    throw new BGMessageException("\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0442\u044c \u043d\u043e\u0432\u043e\u0441\u0442\u0438 \u0434\u043b\u044f \u0432\u0441\u0435\u0445 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439", new Object[0]);
                }
                new NewsDAO(con).updateNewsUsers(news, Utils.getObjectIdsSet(UserCache.getActiveUsers()));
            }
        } else {
            HashSet<Integer> userSet = new HashSet<Integer>();
            userSet.add(requestUserId);
            new NewsDAO(con).updateNewsUsers(news, userSet);
        }
        return this.json(con, form);
    }

    public ActionForward newsEdit(DynActionForm form, Connection con) throws Exception {
        News news = new NewsDAO(con).getNews(form.getId());
        if (news != null) {
            form.setResponseData("news", news);
        }
        return this.html(con, form, "/WEB-INF/jspf/user/news/update.jsp");
    }

    public ActionForward newsList(DynActionForm form, Connection con) throws Exception {
        Boolean read = form.getParamBoolean("read", false);
        Pageable<News> searchResult = new Pageable<News>(form);
        new NewsDAO(con).searchNewsList(searchResult, form.getUserId(), read, form.getParam("text"));
        if (read != null && !read.booleanValue()) {
            this.updatePersonalization(form, con, map -> map.put(UNREAD_NEWS_PERSONAL_KEY, Utils.getObjectIds(searchResult.getList())));
        }
        return this.html(con, form, "/WEB-INF/jspf/user/news/list.jsp");
    }

    public ActionForward newsGet(DynActionForm form, Connection con) throws Exception {
        NewsDAO newsDAO = new NewsDAO(con);
        newsDAO.setNewsRead(form.getParamInt("newsId", -1), form.getUserId(), true);
        News news = newsDAO.getNews(form.getParamInt("newsId", -1));
        form.setResponseData("item", news);
        UserNewsCache.flushCache(con, Collections.singleton(form.getUserId()));
        return this.html(con, form, "/WEB-INF/jspf/user/news/content.jsp");
    }

    public ActionForward newsSetRead(DynActionForm form, Connection con) throws Exception {
        new NewsDAO(con).setNewsRead(form.getParamInt("newsId", -1), form.getUserId(), form.getParamBoolean("value", true));
        UserNewsCache.flushCache(con, Collections.singleton(form.getUserId()));
        return this.json(con, form);
    }

    public ActionForward newsSetAllRead(DynActionForm form, Connection con) throws Exception {
        new NewsDAO(con).setNewsAllRead(form.getUserId());
        UserNewsCache.flushCache(con, Collections.singleton(form.getUserId()));
        return this.json(con, form);
    }

    public ActionForward newsDelete(DynActionForm form, Connection con) throws Exception {
        new NewsDAO(con).deleteNews(form.getId());
        return this.json(con, form);
    }
}

