/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.passport.dataerror;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.passport.dataerror.PassportElementError;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class PassportElementErrorReverseSide
implements PassportElementError {
    private static final String SOURCE_FIELD = "source";
    private static final String TYPE_FIELD = "type";
    private static final String FILEHASH_FIELD = "file_hash";
    private static final String MESSAGE_FIELD = "message";
    @JsonProperty(value="source")
    private final String source = "reverse_side";
    @JsonProperty(value="type")
    @NonNull
    private String type;
    @JsonProperty(value="file_hash")
    @NonNull
    private String fileHash;
    @JsonProperty(value="message")
    @NonNull
    private String message;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.fileHash == null || this.fileHash.isEmpty()) {
            throw new TelegramApiValidationException("File hash parameter can't be empty", this);
        }
        if (this.message == null || this.message.isEmpty()) {
            throw new TelegramApiValidationException("Message parameter can't be empty", this);
        }
        if (this.type == null || this.type.isEmpty()) {
            throw new TelegramApiValidationException("Type parameter can't be empty", this);
        }
    }

    public static PassportElementErrorReverseSideBuilder builder() {
        return new PassportElementErrorReverseSideBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PassportElementErrorReverseSide)) {
            return false;
        }
        PassportElementErrorReverseSide other = (PassportElementErrorReverseSide)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$fileHash = this.getFileHash();
        String other$fileHash = other.getFileHash();
        if (this$fileHash == null ? other$fileHash != null : !this$fileHash.equals(other$fileHash)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PassportElementErrorReverseSide;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $fileHash = this.getFileHash();
        result = result * 59 + ($fileHash == null ? 43 : $fileHash.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String getSource() {
        return this.source;
    }

    @NonNull
    public String getType() {
        return this.type;
    }

    @NonNull
    public String getFileHash() {
        return this.fileHash;
    }

    @NonNull
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="type")
    public void setType(@NonNull String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    @JsonProperty(value="file_hash")
    public void setFileHash(@NonNull String fileHash) {
        if (fileHash == null) {
            throw new NullPointerException("fileHash is marked non-null but is null");
        }
        this.fileHash = fileHash;
    }

    @JsonProperty(value="message")
    public void setMessage(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.message = message;
    }

    public String toString() {
        return "PassportElementErrorReverseSide(source=" + this.getSource() + ", type=" + this.getType() + ", fileHash=" + this.getFileHash() + ", message=" + this.getMessage() + ")";
    }

    public PassportElementErrorReverseSide() {
    }

    public PassportElementErrorReverseSide(@NonNull String type, @NonNull String fileHash, @NonNull String message) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (fileHash == null) {
            throw new NullPointerException("fileHash is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.type = type;
        this.fileHash = fileHash;
        this.message = message;
    }

    public static class PassportElementErrorReverseSideBuilder {
        private String type;
        private String fileHash;
        private String message;

        PassportElementErrorReverseSideBuilder() {
        }

        @JsonProperty(value="type")
        public PassportElementErrorReverseSideBuilder type(@NonNull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        @JsonProperty(value="file_hash")
        public PassportElementErrorReverseSideBuilder fileHash(@NonNull String fileHash) {
            if (fileHash == null) {
                throw new NullPointerException("fileHash is marked non-null but is null");
            }
            this.fileHash = fileHash;
            return this;
        }

        @JsonProperty(value="message")
        public PassportElementErrorReverseSideBuilder message(@NonNull String message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
            return this;
        }

        public PassportElementErrorReverseSide build() {
            return new PassportElementErrorReverseSide(this.type, this.fileHash, this.message);
        }

        public String toString() {
            return "PassportElementErrorReverseSide.PassportElementErrorReverseSideBuilder(type=" + this.type + ", fileHash=" + this.fileHash + ", message=" + this.message + ")";
        }
    }
}

