/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class RangeChecker {
    private List<long[]> rangeList = new ArrayList<long[]>();

    public RangeChecker(String ranges) {
        StringTokenizer st = new StringTokenizer(ranges, ",;");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.equals("*")) {
                this.rangeList.add(new long[]{Long.MIN_VALUE, Long.MAX_VALUE});
                continue;
            }
            long[] range = new long[2];
            try {
                String[] pair = token.split("\\-");
                if (pair.length == 2) {
                    range[0] = Long.parseLong(pair[0].trim());
                    range[1] = Long.parseLong(pair[1].trim());
                } else if (pair.length == 1) {
                    range[0] = range[1] = Long.parseLong(token);
                }
                this.rangeList.add(range);
            }
            catch (Exception exception) {}
        }
    }

    public boolean check(long value) {
        long[] range;
        boolean result = false;
        Iterator<long[]> iterator = this.rangeList.iterator();
        while (iterator.hasNext() && !(result = (range = iterator.next())[0] <= value && value <= range[1])) {
        }
        return result;
    }
}

