/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.struts.action.admin;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javassist.NotFoundException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.cfg.Preferences;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.exception.BGIllegalArgumentException;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.cache.ProcessQueueCache;
import org.bgerp.cache.ProcessTypeCache;
import org.bgerp.dao.param.ParamDAO;
import org.bgerp.model.Pageable;
import org.bgerp.model.base.IdTitle;
import org.bgerp.model.process.ProcessGroups;
import org.bgerp.util.sql.LikePattern;
import ru.bgcrm.dao.ConfigDAO;
import ru.bgcrm.dao.process.ProcessTypeDAO;
import ru.bgcrm.dao.process.QueueDAO;
import ru.bgcrm.dao.process.StatusDAO;
import ru.bgcrm.dao.user.UserPermsetDAO;
import ru.bgcrm.model.LastModify;
import ru.bgcrm.model.process.ProcessType;
import ru.bgcrm.model.process.Status;
import ru.bgcrm.model.process.TypeProperties;
import ru.bgcrm.model.process.queue.Queue;
import ru.bgcrm.model.user.Permset;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;

@ActionServlet.Action(path="/admin/process")
public class ProcessAction
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/admin/process";
    public static final String JSP_USED_IN_TYPES = "/WEB-INF/jspf/admin/process/used_in_types.jsp";

    public ActionForward statusList(DynActionForm form, Connection con) throws Exception {
        new StatusDAO(con).searchStatus(new Pageable<Status>(form));
        return this.html(con, form, "/WEB-INF/jspf/admin/process/status/list.jsp");
    }

    public ActionForward statusUseProcess(DynActionForm form, Connection con) throws Exception {
        Integer statusId = Utils.parseInt(form.getParam("statusId"));
        ArrayList<String> containProcess = new ArrayList<String>();
        Map<Integer, ProcessType> processTypeMap = ProcessTypeCache.getProcessTypeMap();
        for (int i = 0; i < processTypeMap.size(); ++i) {
            List<Integer> parameters;
            ProcessType pType = (ProcessType)processTypeMap.values().toArray()[i];
            if (pType.isUseParentProperties() || !(parameters = pType.getProperties().getStatusIds()).contains(statusId)) continue;
            containProcess.add(pType.getTitle());
        }
        form.setResponseData("containProcess", containProcess);
        return this.html(con, form, JSP_USED_IN_TYPES);
    }

    public ActionForward statusDelete(DynActionForm form, Connection con) throws Exception {
        new StatusDAO(con).deleteStatus(form.getId());
        ProcessTypeCache.flush(con);
        return this.json(con, form);
    }

    public ActionForward statusGet(DynActionForm form, Connection con) throws Exception {
        StatusDAO statusDAO = new StatusDAO(con);
        Status status = statusDAO.getStatus(form.getId());
        if (status != null) {
            form.setResponseData("status", status);
        }
        return this.html(con, form, "/WEB-INF/jspf/admin/process/status/update.jsp");
    }

    public ActionForward statusUpdate(DynActionForm form, Connection con) throws Exception {
        StatusDAO statusDAO = new StatusDAO(con);
        Status status = new Status();
        status.setId(form.getId());
        status.setTitle(form.getParam("title"));
        status.setPos(Utils.parseInt(form.getParam("pos")));
        statusDAO.updateStatus(status);
        ProcessTypeCache.flush(con);
        return this.json(con, form);
    }

    public ActionForward typeList(DynActionForm form, Connection con) throws Exception {
        ProcessType type;
        int id;
        HttpServletRequest request = form.getHttpRequest();
        String filter = form.getParam("filter", "");
        if (Utils.notBlankString(filter)) {
            form.setParam("parentTypeId", "-1");
        }
        int parentId = form.getParamInt("parentTypeId");
        ProcessTypeDAO processTypeDAO = new ProcessTypeDAO(con);
        processTypeDAO.searchProcessType(new Pageable<ProcessType>(form), parentId, LikePattern.SUB.get(filter));
        if (parentId >= 0) {
            request.setAttribute("typePath", ProcessTypeCache.getTypePath(parentId));
        }
        if ((id = form.getParamInt("markType", -1)) != -1 && (type = processTypeDAO.getProcessType(id)) != null) {
            request.setAttribute("markTypeString", (Object)type.getTitle());
        }
        return this.html(con, form, "/WEB-INF/jspf/admin/process/type/list.jsp");
    }

    public ActionForward typeGet(DynActionForm form, Connection con) throws Exception {
        ProcessTypeDAO processTypeDAO = new ProcessTypeDAO(con);
        ProcessType type = processTypeDAO.getProcessType(form.getId());
        if (type != null) {
            form.setResponseData("type", type);
        }
        return this.html(con, form, "/WEB-INF/jspf/admin/process/type/update.jsp");
    }

    public ActionForward typeUpdate(DynActionForm form, Connection con) throws Exception {
        ProcessTypeDAO processTypeDAO = new ProcessTypeDAO(con);
        ProcessType type = new ProcessType();
        type.setId(form.getId());
        type.setTitle(form.getParam("title"));
        type.setParentId(Utils.parseInt(form.getParam("parentTypeId")));
        type.setUseParentProperties(Utils.parseBoolean(form.getParam("useParent")));
        if (Utils.isBlankString(type.getTitle())) {
            throw new BGMessageException("\u041f\u0443\u0441\u0442\u043e\u0435 \u0438\u043c\u044f.", new Object[0]);
        }
        if (!processTypeDAO.checkType((Integer)type.getId(), (Integer)type.getParentId(), type.getTitle())) {
            throw new BGMessageException("\u0422\u0430\u043a\u043e\u0435 \u0438\u043c\u044f \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0434\u0430\u043d\u043d\u043e\u0439 \u0432\u0435\u0442\u043a\u0435.", new Object[0]);
        }
        processTypeDAO.updateProcessType(type, form.getUserId());
        ProcessTypeCache.flush(con);
        return this.json(con, form);
    }

    public ActionForward typeDelete(DynActionForm form, Connection con) throws Exception {
        ProcessTypeDAO typeDAO = new ProcessTypeDAO(con);
        int id = form.getId();
        if (!typeDAO.checkProcessTypeForDelete(id)) {
            throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0442\u0438\u043f, \u043f\u043e\u043a\u0430 \u043e\u043d \u0438\u043c\u0435\u0435\u0442 \u043f\u043e\u0442\u043e\u043c\u043a\u043e\u0432.", new Object[0]);
        }
        typeDAO.deleteProcessType(id);
        ProcessTypeCache.flush(con);
        return this.json(con, form);
    }

    public ActionForward typeInsertMark(DynActionForm form, Connection con) throws Exception {
        int parentId = form.getParamInt("parentTypeId", 0);
        int id = form.getParamInt("markType", -1);
        if (id != -1) {
            ProcessTypeDAO typeDAO = new ProcessTypeDAO(con);
            ProcessType type = typeDAO.getProcessType(id);
            if (!typeDAO.checkType(0, parentId, type.getTitle())) {
                throw new BGMessageException("\u0422\u0430\u043a\u043e\u0435 \u0438\u043c\u044f \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0434\u0430\u043d\u043d\u043e\u0439 \u0432\u0435\u0442\u043a\u0435.", new Object[0]);
            }
            if (parentId == id) {
                throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432 \u0441\u0430\u043c\u043e\u0433\u043e \u0441\u0435\u0431\u044f.", new Object[0]);
            }
            type.setParentId(parentId);
            typeDAO.updateProcessType(type, form.getUserId());
            ProcessTypeCache.flush(con);
            form.setParam("markType", "0");
        }
        return this.json(con, form);
    }

    public ActionForward typeUsed(DynActionForm form, Connection con) throws Exception {
        int typeId = form.getParamInt("typeId", 0);
        if (typeId <= 0) {
            throw new BGIllegalArgumentException();
        }
        List queueList = ProcessQueueCache.getQueueList().stream().filter(q -> q.getProcessTypeIds().contains(typeId)).map(IdTitle::getTitle).collect(Collectors.toList());
        form.setResponseData("queueTitleList", queueList);
        return this.html(con, form, "/WEB-INF/jspf/admin/process/type/type_used.jsp");
    }

    public ActionForward typeCopy(DynActionForm form, Connection con) throws Exception {
        int typeId = form.getId();
        if (typeId <= 0) {
            throw new BGIllegalArgumentException();
        }
        ProcessTypeDAO dao = new ProcessTypeDAO(con);
        int fromTypeId = form.getParamInt("fromId");
        if (fromTypeId > 0) {
            dao.copyTypeProperties(fromTypeId, typeId);
            return this.json(con, form);
        }
        List<ProcessType> types = dao.getTypeChildren(form.getParamInt("parentId", 0), Collections.singleton(typeId));
        form.setResponseData("types", types);
        return this.html(con, form, "/WEB-INF/jspf/admin/process/type/type_copy.jsp");
    }

    public ActionForward queueList(DynActionForm form, Connection con) throws Exception {
        Set<Integer> queueIds = Utils.toIntegerSet(form.getPermission().get("allowedQueueIds"));
        new QueueDAO(con).searchQueue(new Pageable<Queue>(form), queueIds, form.getParam("filter"));
        return this.html(con, form, "/WEB-INF/jspf/admin/process/queue/list.jsp");
    }

    public ActionForward queueGet(DynActionForm form, Connection con) throws Exception {
        HttpServletRequest request = form.getHttpRequest();
        this.checkAllowedQueueIds(form);
        QueueDAO queueDAO = new QueueDAO(con);
        int id = form.getId();
        Queue queue = queueDAO.getQueue(id);
        if (queue != null) {
            queue.setProcessTypeIds(queueDAO.getQueueProcessTypeIds(id));
            form.setResponseData("queue", queue);
        }
        request.setAttribute("typeTreeRoot", (Object)ProcessTypeCache.getTypeTreeRoot());
        return this.html(con, form, "/WEB-INF/jspf/admin/process/queue/update.jsp");
    }

    public ActionForward queueUpdate(DynActionForm form, Connection con) throws Exception {
        this.checkAllowedQueueIds(form);
        QueueDAO queueDAO = new QueueDAO(con);
        Queue queue = new Queue();
        queue.setId(form.getId());
        queue.setTitle(form.getParam("title"));
        queue.setConfig(form.getParam("config"));
        queue.setProcessTypeIds(form.getParamValues("type"));
        queue.setLastModify(new LastModify(form.getUserId(), new Date()));
        Queue oldQueue = queueDAO.getQueue(form.getId());
        this.checkModified(oldQueue == null ? new LastModify() : oldQueue.getLastModify(), form);
        queueDAO.updateQueue(queue, form.getUserId());
        form.setResponseData("queue", queue);
        ProcessQueueCache.flush(con);
        return this.json(con, form);
    }

    public ActionForward queueDuplicate(DynActionForm form, Connection con) throws Exception {
        QueueDAO dao = new QueueDAO(con);
        Queue queue = dao.getQueue(form.getId());
        if (queue == null) {
            throw new NotFoundException("Not found queue with ID: " + form.getId());
        }
        queue.setProcessTypeIds(dao.getQueueProcessTypeIds(queue.getId()));
        queue.setId(-1);
        queue.setTitle(queue.getTitle() + " " + this.l.l("\u041a\u043e\u043f\u0438\u044f", new Object[0]));
        dao.updateQueue(queue, form.getUserId());
        form.setResponseData("queue", queue);
        ProcessQueueCache.flush(con);
        return this.json(con, form);
    }

    public ActionForward queueDelete(DynActionForm form, Connection con) throws Exception {
        this.checkAllowedQueueIds(form);
        new QueueDAO(con).delete(form.getId());
        ProcessQueueCache.flush(con);
        return this.json(con, form);
    }

    public ActionForward properties(DynActionForm form, Connection con) throws Exception {
        HttpServletRequest request = form.getHttpRequest();
        this.checkAllowedQueueIds(form);
        ProcessTypeDAO typeDAO = new ProcessTypeDAO(con);
        ParamDAO paramDAO = new ParamDAO(con);
        UserPermsetDAO groupDAO = new UserPermsetDAO(con);
        ProcessType type = typeDAO.getProcessType(form.getId());
        if (type != null) {
            form.setResponseData("properties", type.getProperties());
            form.setResponseData("config", type.getProperties().getConfig());
            request.setAttribute("statusList", Utils.getObjectList(ProcessTypeCache.getStatusMap(), type.getProperties().getStatusIds()));
            request.setAttribute("processType", (Object)type);
            Pageable<Permset> groupList = new Pageable<Permset>();
            groupDAO.searchPermset(groupList);
            request.setAttribute("groupList", groupList);
            request.setAttribute("parameterList", paramDAO.getParameterList("process", 0));
        }
        return this.html(con, form, "/WEB-INF/jspf/admin/process/type/properties.jsp");
    }

    public ActionForward propertiesUpdate(DynActionForm form, Connection con) throws Exception {
        this.checkAllowedQueueIds(form);
        ProcessTypeDAO typeDAO = new ProcessTypeDAO(con);
        ConfigDAO configDao = new ConfigDAO(con);
        ProcessType type = typeDAO.getProcessType(form.getId());
        if (type != null) {
            TypeProperties properties = type.getProperties();
            String[] beginGroupArr = form.getParam().getArray("beginGroupRole");
            String[] allowedGroupArr = form.getParam().getArray("allowedGroupRole");
            properties.setCreateStatusId(form.getParamInt("createStatusId"));
            properties.setCloseStatusIds(form.getParamValues("closeStatusId"));
            properties.setStatusIds(form.getParamValuesList("status"));
            properties.setParameterIds(form.getParamValuesList("param"));
            properties.setAllowedGroups(ProcessGroups.of(allowedGroupArr));
            properties.setConfig(form.getParam("config"));
            properties.setGroups(ProcessGroups.of(beginGroupArr));
            if (properties.getConfig() == null) {
                throw new BGException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u043f\u0443\u0441\u0442\u043e\u0439 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438.", new Object[0]);
            }
            this.checkModified(properties.getLastModify(), form);
            Preferences.processIncludes(configDao, properties.getConfig(), true);
            this.checkAllowedQueueIds(form);
            this.updateTransactions(form, type);
            typeDAO.updateTypeProperties(type);
            ProcessTypeCache.flush(con);
        }
        return this.json(con, form);
    }

    private void updateTransactions(DynActionForm form, ProcessType type) throws Exception {
        String[] matrixParamArray = form.getParam().getArray("matrix");
        if (matrixParamArray != null) {
            TypeProperties properties = type.getProperties();
            boolean anyEnabled = false;
            for (String transaction : matrixParamArray) {
                String[] paramArray = transaction.split("-");
                int fromStatus = Utils.parseInt(paramArray[0]);
                int toStatus = Utils.parseInt(paramArray[1]);
                boolean enabled = Utils.parseBoolean(paramArray[2]);
                anyEnabled |= enabled;
                properties.setTransactionProperties(fromStatus, toStatus, enabled);
            }
            if (!anyEnabled) {
                properties.clearTransactionProperties();
            }
        }
    }

    private void checkAllowedQueueIds(DynActionForm form) throws BGMessageException {
        Set<Integer> queueIds = Utils.toIntegerSet(form.getPermission().get("allowedQueueIds"));
        if (CollectionUtils.isNotEmpty(queueIds) && !queueIds.contains(form.getId())) {
            throw new BGMessageException("\u0420\u0430\u0431\u043e\u0442\u0430 \u0441 \u0434\u0430\u043d\u043d\u043e\u0439 \u043e\u0447\u0435\u0440\u0435\u0434\u044c\u044e \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u0430.", new Object[0]);
        }
    }
}

