/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.struts.action;

import java.sql.Connection;
import java.util.Date;
import javassist.NotFoundException;
import org.apache.struts.action.ActionForward;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.exception.BGIllegalArgumentException;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.app.exception.BGMessageExceptionWithoutL10n;
import org.bgerp.dao.customer.CustomerDAO;
import org.bgerp.model.Pageable;
import org.bgerp.model.base.IdTitle;
import ru.bgcrm.dao.CustomerLinkDAO;
import ru.bgcrm.event.link.LinkAddingEvent;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.model.customer.Customer;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.ContractTypesConfig;
import ru.bgcrm.plugin.bgbilling.creator.Config;
import ru.bgcrm.plugin.bgbilling.creator.ServerCustomerCreator;
import ru.bgcrm.plugin.bgbilling.dao.ContractCustomerDAO;
import ru.bgcrm.plugin.bgbilling.model.ContractType;
import ru.bgcrm.plugin.bgbilling.proto.dao.ContractDAO;
import ru.bgcrm.plugin.bgbilling.proto.dao.ContractTariffDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.Contract;
import ru.bgcrm.plugin.bgbilling.proto.model.ContractInfo;
import ru.bgcrm.plugin.bgbilling.struts.action.BaseAction;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.action.LinkAction;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;
import ru.bgcrm.util.sql.SingleConnectionSet;

@ActionServlet.Action(path="/user/plugin/bgbilling/contract")
public class ContractAction
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/user/plugin/bgbilling";

    @Override
    public ActionForward unspecified(DynActionForm form, ConnectionSet conSet) throws Exception {
        return this.contract(form, conSet);
    }

    public ActionForward customerContractList(DynActionForm form, Connection con) {
        int customerId = form.getParamInt("customerId", 0);
        form.setResponseData("list", new CustomerLinkDAO(con).getObjectLinksWithType(customerId, "contract%"));
        form.setResponseData("customerId", customerId);
        form.setRequestAttribute("contractTypesConfig", this.setup.getConfig(ContractTypesConfig.class));
        form.setRequestAttribute("customer", new CustomerDAO(con).getCustomerById(customerId));
        return this.html(con, form, "/WEB-INF/jspf/user/plugin/bgbilling/customer_contract_list.jsp");
    }

    public ActionForward contractCreateTariff(DynActionForm form, ConnectionSet conSet) throws Exception {
        ContractTypesConfig config = this.setup.getConfig(ContractTypesConfig.class);
        int typeId = form.getParamInt("typeId");
        ContractType type = config.getTypeMap().get(typeId);
        if (type == null) {
            throw new NotFoundException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0442\u0438\u043f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0441 ID: " + typeId);
        }
        form.setResponseData("type", type);
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/customer_contract_list_create_tariff.jsp");
    }

    public ActionForward contract(DynActionForm form, ConnectionSet conSet) throws Exception {
        String billingId = form.getParam("billingId");
        int id = form.getId();
        if (Utils.notBlankString(billingId) && id > 0) {
            ContractInfo info = new ContractDAO(form.getUser(), billingId).getContractInfo(id);
            form.setResponseData("contract", info);
            Customer customer = new ContractCustomerDAO(conSet.getConnection()).getContractCustomer(info);
            if (customer != null) {
                form.setResponseData("customer", customer);
            }
        }
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract.jsp");
    }

    public ActionForward createCustomerFromContract(DynActionForm form, Connection con) throws BGMessageException {
        Config config = this.setup.getConfig(Config.class);
        String billingId = form.getParam("billingId");
        if (config == null) {
            throw new BGMessageExceptionWithoutL10n("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0430\u044f \u043b\u0438\u0431\u043e \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432.", new Object[0]);
        }
        ServerCustomerCreator serverCustomerCreator = config.getServerCustomerCreator(billingId, con);
        if (serverCustomerCreator == null) {
            throw new BGMessageExceptionWithoutL10n("\u0414\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430 \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d \u0438\u043c\u043f\u043e\u0440\u0442 \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432.", new Object[0]);
        }
        serverCustomerCreator.createCustomer(billingId, con, form.getParamInt("contractId", -1), form.getParamInt("customerId", -1));
        return this.json(con, form);
    }

    public ActionForward copyCustomerParamCascade(DynActionForm form, Connection con) throws Exception {
        int customerId = form.getParamInt("customerId", -1);
        User user = form.getUser();
        ContractDAO.copyParametersToAllContracts(con, user, customerId);
        return this.html(con, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract.jsp");
    }

    public ActionForward copyCustomerParamToContract(DynActionForm form, Connection con) throws Exception {
        int customerId = form.getParamInt("customerId", -1);
        int contractId = form.getParamInt("contractId", -1);
        String contractTitle = form.getParam("contractTitle", "");
        ContractDAO contractDAO = new ContractDAO(form.getUser(), form.getParam("billingId"));
        contractDAO.copyParametersToBilling(con, customerId, contractId, contractTitle);
        return this.json(con, form);
    }

    public ActionForward contractFind(DynActionForm form, Connection con) {
        String billingId = form.getParam("billingId");
        String title = form.getParam("title");
        Pageable<IdTitle> searchResult = new Pageable<IdTitle>();
        new ContractDAO(form.getUser(), billingId).searchContractByTitleComment(searchResult, title, null, null);
        form.setResponseData("contract", Utils.getFirst(searchResult.getList()));
        return this.json(con, form);
    }

    public ActionForward contractCreate(DynActionForm form, Connection con) throws Exception {
        int customerId = Utils.parseInt(form.getParam("customerId"));
        String billingId = form.getParam("billingId");
        int patternId = Utils.parseInt(form.getParam("patternId"));
        Date date = form.getParamDate("date");
        String titlePattern = form.getParam("titlePattern");
        String title = form.getParam("title");
        String comment = form.getParam("comment", "");
        int tariffId = form.getParamInt("tariffId");
        ContractTypesConfig config = this.setup.getConfig(ContractTypesConfig.class);
        ContractType type = config.getTypeMap().get(form.getParamInt("typeId"));
        if (type == null) {
            throw new BGException("\u041d\u0435 \u043f\u0435\u0440\u0435\u0434\u0430\u043d \u0442\u0438\u043f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", new Object[0]);
        }
        ContractDAO contractDao = new ContractDAO(form.getUser(), billingId);
        Contract contract = contractDao.createContract(patternId, date, title, titlePattern, 0);
        if (customerId > 0) {
            CommonObjectLink link = new CommonObjectLink("customer", customerId, "contract:" + billingId, contract.getId(), contract.getTitle());
            LinkAddingEvent event = new LinkAddingEvent(form, link);
            EventProcessor.processEvent(event, new SingleConnectionSet(con));
            new CustomerLinkDAO(con).addLink(link);
            new ContractDAO(form.getUser(), billingId).copyParametersToBilling(con, customerId, contract.getId(), contract.getTitle());
        }
        if (Utils.notBlankString(comment)) {
            contractDao.bgbillingUpdateContractTitleAndComment(contract.getId(), comment, 0);
            contract.setComment(comment);
        }
        if (tariffId > 0) {
            ContractTariffDAO tariffDao = new ContractTariffDAO(form.getUser(), billingId);
            int tariffPosition = type.getTariffPosition();
            if (tariffPosition < 0) {
                tariffDao.setTariffPlan(contract.getId(), tariffId);
            } else {
                tariffDao.addTariffPlan(contract.getId(), tariffId, tariffPosition);
            }
        }
        form.setResponseData("contract", contract);
        return this.json(con, form);
    }

    public ActionForward addProcessContractLink(DynActionForm form, Connection con) throws Exception {
        String billingId = form.getParam("billingId");
        int processId = form.getParamInt("processId");
        String contractTitle = form.getParam("contractTitle");
        if (Utils.isBlankString(billingId) || processId <= 0 || Utils.isBlankString(contractTitle)) {
            throw new BGIllegalArgumentException();
        }
        ContractDAO.SearchOptions searchOptions = new ContractDAO.SearchOptions(true, true, true);
        Pageable<IdTitle> searchResult = new Pageable<IdTitle>();
        new ContractDAO(form.getUser(), billingId).searchContractByTitleComment(searchResult, "^" + contractTitle + "$", null, searchOptions);
        IdTitle result = Utils.getFirst(searchResult.getList());
        if (result == null) {
            throw new BGMessageExceptionWithoutL10n("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", new Object[0]);
        }
        CommonObjectLink link = new CommonObjectLink("process", processId, "contract:" + billingId, result.getId(), contractTitle);
        LinkAction.addLink(form, con, link);
        return this.json(con, form);
    }
}

