/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.proto.dao;

import com.fasterxml.jackson.databind.JavaType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bgerp.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.Request;
import ru.bgcrm.plugin.bgbilling.RequestJsonRpc;
import ru.bgcrm.plugin.bgbilling.proto.dao.BillingModuleDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.npay.NPayService;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public class NPayDAO
extends BillingModuleDAO {
    private static final String MODULES_NPAY = "ru.bitel.bgbilling.modules.npay";

    public NPayDAO(User user, String billingId, int moduleId) {
        super(user, billingId, moduleId);
    }

    public List<NPayService> getServiceList(int contractId) {
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(MODULES_NPAY, this.moduleId, "NPayService", "serviceObjectList");
            req.setParamContractId(contractId);
            req.setParam("objectId", 0);
            req.setParam("entityModuleId", -1);
            req.setParam("entityId", -1);
            req.setParam("actualItemsOnly", true);
            req.setParam("actualItemsDate", new Date());
            return (List)this.readJsonValue(this.transferData.postDataReturn(req, this.user).traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, NPayService.class));
        }
        Request req = new Request();
        req.setModule("npay");
        req.setAction("ServiceObjectTable");
        req.setModuleID(this.moduleId);
        req.setContractId(contractId);
        req.setAttribute("object_id", 0);
        Document document = this.transferData.postData(req, this.user);
        ArrayList<NPayService> serviceList = new ArrayList<NPayService>();
        if (document != null) {
            Element dataElement = document.getDocumentElement();
            NodeList nodeList = dataElement.getElementsByTagName("row");
            for (int index = 0; index < nodeList.getLength(); ++index) {
                NPayService service = new NPayService();
                Element rowElement = (Element)nodeList.item(index);
                service.setComment(rowElement.getAttribute("comment"));
                service.setDateFrom(TimeUtils.parse(rowElement.getAttribute("date1"), "dd.MM.yyyy"));
                service.setDateTo(TimeUtils.parse(rowElement.getAttribute("date2"), "dd.MM.yyyy"));
                service.setId(Utils.parseInt(rowElement.getAttribute("id")));
                service.setObjectId(Utils.parseInt(rowElement.getAttribute("objectId")));
                service.setObjectTitle(rowElement.getAttribute("object"));
                service.setServiceTitle(rowElement.getAttribute("service"));
                service.setServiceId(Utils.parseInt(rowElement.getAttribute("sid")));
                service.setCount(Utils.parseInt(rowElement.getAttribute("col")));
                service.setContractId(contractId);
                serviceList.add(service);
            }
        }
        return serviceList;
    }

    public NPayService getService(int id) {
        if (this.dbInfo.versionCompare("8.0") > 0) {
            RequestJsonRpc req = new RequestJsonRpc(MODULES_NPAY, this.moduleId, "NPayService", "serviceObjectGet");
            req.setParam("id", id);
            return (NPayService)this.jsonMapper.convertValue((Object)this.transferData.postDataReturn(req, this.user), NPayService.class);
        }
        NPayService result = null;
        Request req = new Request();
        req.setModule("npay");
        req.setAction("ServiceObjectGet");
        req.setModuleID(this.moduleId);
        req.setAttribute("id", id);
        Document doc = this.transferData.postData(req, this.user);
        Element serviceEl = XMLUtils.selectElement(doc, "/data/object");
        if (serviceEl != null) {
            result = new NPayService();
            result.setId(id);
            result.setServiceId(Utils.parseInt(serviceEl.getAttribute("sid")));
            result.setObjectId(Utils.parseInt(serviceEl.getAttribute("oid")));
            result.setCount(Utils.parseInt(serviceEl.getAttribute("col")));
            result.setDateFrom(TimeUtils.parse(serviceEl.getAttribute("date1"), "dd.MM.yyyy"));
            result.setDateTo(TimeUtils.parse(serviceEl.getAttribute("date2"), "dd.MM.yyyy"));
            result.setComment(this.linesToString(XMLUtils.selectElement(doc, "/data/comment/")));
        }
        return result;
    }

    public void updateService(NPayService service) {
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(MODULES_NPAY, this.moduleId, "NPayService", "serviceObjectUpdate");
            req.setParam("contractId", service.getContractId());
            req.setParam("serviceObject", service);
            this.transferData.postData(req, this.user);
        } else {
            Request req = new Request();
            req.setModule("npay");
            req.setAction("ServiceObjectUpdate");
            req.setModuleID(String.valueOf(this.moduleId));
            req.setContractId(service.getContractId());
            req.setAttribute("object_id", 0);
            req.setAttribute("id", service.getId() <= 0 ? "new" : Integer.valueOf(service.getId()));
            req.setAttribute("sid", service.getServiceId());
            req.setAttribute("oid", service.getObjectId());
            req.setAttribute("col", service.getCount());
            req.setAttribute("comment", service.getComment());
            if (service.getDateFrom() != null) {
                req.setAttribute("date1", TimeUtils.format(service.getDateFrom(), "dd.MM.yyyy"));
            }
            if (service.getDateTo() != null) {
                req.setAttribute("date2", TimeUtils.format(service.getDateTo(), "dd.MM.yyyy"));
            }
            this.transferData.postData(req, this.user);
        }
    }

    public void deleteService(int contractId, int id) {
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(MODULES_NPAY, this.moduleId, "NPayService", "serviceObjectDelete");
            req.setParam("contractId", contractId);
            req.setParam("serviceId", id);
            this.transferData.postData(req, this.user);
        } else {
            Request req = new Request();
            req.setModule("npay");
            req.setAction("ServiceObjectDelete");
            req.setModuleID(this.moduleId);
            req.setAttribute("id", id);
            this.transferData.postData(req, this.user);
        }
    }
}

