/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.model.user;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Preferences;
import org.bgerp.cache.UserCache;
import org.bgerp.model.base.IdTitleComment;
import org.bgerp.util.Dynamic;
import org.bgerp.util.Log;
import ru.bgcrm.model.user.PermissionNode;
import ru.bgcrm.model.user.UserAccount;
import ru.bgcrm.util.Utils;

public class User
extends IdTitleComment
implements Comparable<User>,
Cloneable,
UserAccount {
    private static final Log log = Log.getLog();
    public static final String OBJECT_TYPE = "user";
    public static final int USER_SYSTEM_ID = 0;
    public static final int USER_CUSTOMER_ID = -1;
    public static final User USER_SYSTEM = new User();
    public static final User USER_CUSTOMER = new User();
    public static final int STATUS_ACTIVE = 0;
    public static final int STATUS_DISABLED = 1;
    public static final int STATUS_EXTERNAL = 2;
    private String login;
    private String password;
    private int status = 0;
    private Set<Integer> groupIds = new HashSet<Integer>();
    private List<Integer> permsetIds = new ArrayList<Integer>();
    private Set<Integer> queueIds = new HashSet<Integer>();
    private String config = "";
    private ConfigMap configMap = new Preferences();
    private String personalization = "";
    private Preferences pers = new Preferences();

    public User() {
    }

    public User(String login, String password) {
        this.login = login;
        this.password = password;
    }

    public boolean isAdmin() {
        return this.id == 1;
    }

    @Override
    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    @Override
    public String getPassword() {
        if (Utils.isBlankString(this.password)) {
            return "*******";
        }
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public Set<Integer> getGroupIds() {
        return this.groupIds;
    }

    public void setGroupIds(Set<Integer> groupIds) {
        if (groupIds != null) {
            this.groupIds = groupIds;
        }
    }

    public List<Integer> getPermsetIds() {
        return this.permsetIds;
    }

    public void setPermsetIds(List<Integer> permsetIds) {
        if (permsetIds != null) {
            this.permsetIds = permsetIds;
        }
    }

    public Set<Integer> getQueueIds() {
        return this.queueIds;
    }

    public void setQueueIds(Set<Integer> queueIds) {
        if (queueIds != null) {
            this.queueIds = queueIds;
        }
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
        this.configMap = new Preferences(config);
    }

    @JsonIgnore
    public ConfigMap getConfigMap() {
        return this.configMap;
    }

    @JsonIgnore
    public String getPersonalization() {
        return this.personalization;
    }

    public void setPersonalization(String personalization) {
        this.personalization = personalization;
        this.pers = new Preferences(personalization);
    }

    @JsonIgnore
    public Preferences getPers() {
        return this.pers;
    }

    @Override
    public int compareTo(User o) {
        return this.title.compareTo(o.getTitle());
    }

    public User clone() {
        User user = new User();
        user.setConfig(this.config);
        user.setComment(this.comment);
        user.setGroupIds(new HashSet<Integer>(this.groupIds));
        user.setId(this.id);
        user.setLogin(this.login);
        user.setPassword(this.password);
        user.setPermsetIds(new ArrayList<Integer>(this.permsetIds));
        user.setPersonalization(this.personalization);
        user.setQueueIds(new HashSet<Integer>(this.queueIds));
        user.setStatus(this.status);
        user.setTitle(this.title);
        return user;
    }

    @JsonIgnore
    public List<User> getUserListWithSameGroups() {
        ArrayList<User> list = new ArrayList<User>(200);
        list.add(this);
        list.addAll(UserCache.getUserList().stream().filter(u -> u.getId() != this.getId() && !CollectionUtils.intersection(this.getGroupIds(), u.getGroupIds()).isEmpty()).collect(Collectors.toList()));
        return list;
    }

    @Dynamic
    public boolean checkPerm(String action) {
        return this.getPerm(action) != null;
    }

    @Dynamic
    public ConfigMap getPerm(String action) {
        PermissionNode node = PermissionNode.getPermissionNode(action);
        if (node != null && !node.getAction().equals(action)) {
            log.warn("Not primary action name '{}' was used for checking of '{}'", action, node.getAction());
        }
        return UserCache.getPerm(this.id, action);
    }

    @Deprecated
    @JsonIgnore
    public Preferences getPersonalizationMap() {
        log.warndMethod("getPersonalizationMap", "getPers");
        return this.pers;
    }

    @Deprecated
    @JsonIgnore
    public String getDescription() {
        log.warndMethod("getDescription");
        return this.comment;
    }

    @Deprecated
    public void setDescription(String value) {
        log.warndMethod("setDescription");
        this.comment = value;
    }

    static {
        USER_SYSTEM.setId(0);
        USER_SYSTEM.setLogin("SYSTEM");
        USER_SYSTEM.setTitle("System");
        USER_CUSTOMER.setId(-1);
        USER_CUSTOMER.setLogin("CUSTOMER");
        USER_CUSTOMER.setTitle("Customer");
    }
}

