/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.event.listener;

import java.util.List;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.cache.ProcessTypeCache;
import ru.bgcrm.dao.process.ProcessLinkDAO;
import ru.bgcrm.event.process.ProcessChangedEvent;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.process.ProcessType;
import ru.bgcrm.util.sql.ConnectionSet;

public class ProcessClosingListener {
    private static final String DIRECTION_DOWN = "down";
    private static final String DIRECTION_UP = "up";

    public ProcessClosingListener() {
        EventProcessor.subscribe((e, conSet) -> this.closingListener((ProcessChangedEvent)e, conSet), ProcessChangedEvent.class);
    }

    private void closingListener(ProcessChangedEvent e, ConnectionSet connectionSet) throws Exception {
        if (!e.isStatus()) {
            return;
        }
        Process process = e.getProcess();
        if (process.getCloseTime() != null) {
            this.checkLinkedProcesses(connectionSet, process, "processDepend", DIRECTION_UP);
            this.checkLinkedProcesses(connectionSet, process, "processMade", DIRECTION_DOWN);
        }
    }

    private void checkLinkedProcesses(ConnectionSet connectionSet, Process process, String linkType, String defaultDirection) throws Exception {
        block3: {
            List<Process> result;
            String checkDirection;
            block2: {
                ProcessType type = ProcessTypeCache.getProcessType(process.getTypeId());
                checkDirection = type.getProperties().getConfigMap().get("process.close.check." + linkType, defaultDirection);
                result = null;
                if (!DIRECTION_DOWN.equals(checkDirection)) break block2;
                result = new ProcessLinkDAO(connectionSet.getConnection()).getLinkProcessList(process.getId(), linkType, false, null);
                for (Process link : result) {
                    if (link.getCloseTime() != null) continue;
                    throw new BGMessageException("\u0415\u0441\u0442\u044c \u043d\u0435\u0437\u0430\u043a\u0440\u044b\u0442\u044b\u0439 \u043f\u0440\u043e\u0446\u0435\u0441\u0441: {}, \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0439 \u043a \u0434\u0430\u043d\u043d\u043e\u043c\u0443 \u0441 \u0442\u0438\u043f\u043e\u043c: {}", link.getId(), linkType);
                }
                break block3;
            }
            if (!DIRECTION_UP.equals(checkDirection)) break block3;
            result = new ProcessLinkDAO(connectionSet.getConnection()).getLinkedProcessList(process.getId(), linkType, false, null);
            for (Process linked : result) {
                if (linked.getCloseTime() != null) continue;
                throw new BGMessageException("\u0415\u0441\u0442\u044c \u043d\u0435\u0437\u0430\u043a\u0440\u044b\u0442\u044b\u0439 \u043f\u0440\u043e\u0446\u0435\u0441\u0441: {}, \u043a \u043a\u043e\u0442\u043e\u0440\u043e\u043c\u0443 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d \u0434\u0430\u043d\u043d\u044b\u0439 \u0441 \u0442\u0438\u043f\u043e\u043c: {}", linked.getId(), linkType);
            }
        }
    }
}

