/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.pln.callboard.model.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.cache.UserCache;
import org.bgerp.model.base.IdTitle;
import org.bgerp.plugin.pln.callboard.model.config.CallboardPlanConfig;
import org.bgerp.plugin.pln.callboard.model.config.CallboardTabelConfig;
import ru.bgcrm.model.user.Group;
import ru.bgcrm.util.Utils;

public class CallboardConfig
extends Config {
    private final Map<Integer, Callboard> itemMap = new LinkedHashMap<Integer, Callboard>();

    public CallboardConfig(ConfigMap config) {
        super(null);
        for (Map.Entry<Integer, ConfigMap> entry : config.subIndexed("callboard.").entrySet()) {
            this.itemMap.put(entry.getKey(), new Callboard((int)entry.getKey(), entry.getValue()));
        }
    }

    public Callboard get(int id) {
        return this.itemMap.get(id);
    }

    public Collection<Callboard> getCallboards(Set<Integer> allowOnlyIds) {
        if (CollectionUtils.isEmpty(allowOnlyIds)) {
            return this.itemMap.values();
        }
        ArrayList<Callboard> result = new ArrayList<Callboard>();
        for (Callboard callboard : this.itemMap.values()) {
            if (!allowOnlyIds.contains(callboard.getId())) continue;
            result.add(callboard);
        }
        return result;
    }

    public static final class Callboard
    extends IdTitle {
        private final ConfigMap configMap;
        private final int groupId;
        private final int calendarId;
        private Boolean hideEmptyGroups = false;
        private Boolean hideEmptyShifts = false;
        private final CallboardTabelConfig tabelConfig;
        private final CallboardPlanConfig planConfig;

        public Callboard(int id, ConfigMap config) {
            super(id, config.get("title"));
            CallboardTabelConfig tabelConfig;
            Group group;
            this.configMap = config;
            this.groupId = config.getInt("groupId", 0);
            this.calendarId = config.getInt("calendarId", 0);
            if (Utils.isBlankString(this.title) && (group = UserCache.getUserGroup(this.groupId)) != null) {
                this.title = group.getTitle();
            }
            this.tabelConfig = Utils.notBlankString((tabelConfig = new CallboardTabelConfig(config.sub("tabel."))).getTemplatePath()) ? tabelConfig : null;
            CallboardPlanConfig planConfig = new CallboardPlanConfig(config.sub("plan."));
            this.planConfig = planConfig.getDayMinuteTo() > 0 ? planConfig : null;
        }

        public int getGroupId() {
            return this.groupId;
        }

        public int getCalendarId() {
            return this.calendarId;
        }

        public ConfigMap getConfigMap() {
            return this.configMap;
        }

        public CallboardTabelConfig getTabelConfig() {
            return this.tabelConfig;
        }

        public CallboardPlanConfig getPlanConfig() {
            return this.planConfig;
        }

        public void setHideEmptyGroups(Boolean hideEmptyGroups) {
            this.hideEmptyGroups = hideEmptyGroups;
        }

        public void setHideEmptyShifts(Boolean hideEmptyShifts) {
            this.hideEmptyShifts = hideEmptyShifts;
        }

        public Boolean getHideEmptyGroups() {
            return this.hideEmptyGroups;
        }

        public Boolean getHideEmptyShifts() {
            return this.hideEmptyShifts;
        }
    }
}

