/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.bil.invoice;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javassist.NotFoundException;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.model.base.IdStringTitle;
import org.bgerp.plugin.bil.invoice.model.InvoiceType;

public class Config
extends org.bgerp.app.cfg.Config {
    private final Map<Integer, InvoiceType> types;
    private final Map<String, IdStringTitle> positions;

    protected Config(ConfigMap config) throws Exception {
        super(null);
        config = config.sub("invoice:");
        this.types = this.loadTypes(config);
        this.positions = this.loadPositions(config);
    }

    private Map<Integer, InvoiceType> loadTypes(ConfigMap config) throws Exception {
        TreeMap<Integer, InvoiceType> result = new TreeMap<Integer, InvoiceType>();
        for (Map.Entry<Integer, ConfigMap> me : config.subIndexed("type.").entrySet()) {
            result.put(me.getKey(), new InvoiceType((int)me.getKey(), me.getValue()));
        }
        return Collections.unmodifiableMap(result);
    }

    private Map<String, IdStringTitle> loadPositions(ConfigMap config) throws Exception {
        LinkedHashMap<String, IdStringTitle> result = new LinkedHashMap<String, IdStringTitle>();
        for (Map.Entry<Integer, ConfigMap> me : config.subIndexed("position.").entrySet()) {
            IdStringTitle pos = new IdStringTitle(me.getValue().get("id"), me.getValue().get("title"));
            result.put(pos.getId(), pos);
        }
        return Collections.unmodifiableMap(result);
    }

    public Collection<InvoiceType> getTypes() {
        return this.types.values();
    }

    public InvoiceType getType(int id) throws NotFoundException {
        InvoiceType result = this.types.get(id);
        if (result == null) {
            throw new NotFoundException("Not found type: " + id);
        }
        return result;
    }

    public Collection<IdStringTitle> getPositions() {
        return this.positions.values();
    }
}

