/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.model.process.config;

import java.util.Set;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.exception.BGMessageException;
import ru.bgcrm.util.Utils;

public class IsolationConfig
extends Config {
    private final IsolationProcess isolationProcess;

    protected IsolationConfig(ConfigMap config) throws BGMessageException {
        super(null);
        this.isolationProcess = this.loadProcessIsolation(config);
    }

    public IsolationProcess getIsolationProcess() {
        return this.isolationProcess;
    }

    private IsolationProcess loadProcessIsolation(ConfigMap config) throws BGMessageException {
        String isolation = config.get("isolation.process");
        if ("executor".equals(isolation)) {
            return new IsolationProcess(IsolationProcess.Type.EXECUTOR);
        }
        if ("group".equals(isolation)) {
            IsolationProcess result = new IsolationProcess(IsolationProcess.Type.GROUP);
            Set<Integer> executorFilteredTypes = Utils.toIntegerSet(config.get("isolation.process.group.executor.typeIds"));
            if (!executorFilteredTypes.isEmpty()) {
                result.executorTypeIds = Utils.toString(executorFilteredTypes);
            }
            return result;
        }
        if (Utils.notBlankString(isolation)) {
            throw new BGException("Unsupported isolation: " + isolation, new Object[0]);
        }
        return IsolationProcess.EMPTY;
    }

    public static class IsolationProcess {
        public static final IsolationProcess EMPTY = new IsolationProcess(null);
        private final Type type;
        private String executorTypeIds;

        private IsolationProcess(Type type) {
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }

        public String getExecutorTypeIds() {
            return this.executorTypeIds;
        }

        public String toString() {
            return "IsolationProcess [type=" + String.valueOf((Object)this.type) + ", executorTypeIds=" + this.executorTypeIds + "]";
        }

        public static enum Type {
            EXECUTOR,
            GROUP;

        }
    }
}

