/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.dao.process;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.bgerp.dao.process.Order;
import org.bgerp.dao.process.ProcessSearchDAO;
import org.bgerp.model.Pageable;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.Pair;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;

public class ProcessLinkProcessSearchDAO
extends ProcessSearchDAO {
    private Set<String> linkType;

    public ProcessLinkProcessSearchDAO(Connection con) {
        super(con);
    }

    public ProcessLinkProcessSearchDAO(Connection con, DynActionForm form) {
        super(con, form);
    }

    @Override
    public ProcessLinkProcessSearchDAO withOpen(Boolean value) {
        return (ProcessLinkProcessSearchDAO)super.withOpen(value);
    }

    @Override
    public ProcessLinkProcessSearchDAO withType(Set<Integer> value) {
        return (ProcessLinkProcessSearchDAO)super.withType((Set)value);
    }

    public ProcessLinkProcessSearchDAO withLinkType(Set<String> value) {
        this.linkType = value;
        return this;
    }

    @Override
    public ProcessLinkProcessSearchDAO order(Order value) {
        return (ProcessLinkProcessSearchDAO)super.order(value);
    }

    public void search(Pageable<Pair<String, Process>> result, boolean link, int processId) throws SQLException {
        try (PreparedQuery pq = new PreparedQuery(this.con);){
            Page page = result.getPage();
            List<Pair<String, Process>> list = result.getList();
            pq.addQuery("SELECT SQL_CALC_FOUND_ROWS DISTINCT l.object_type, p.* FROM  process AS p");
            pq.addQuery(" INNER JOIN  process_link AS l ON ");
            Object linkTypeCompare = " LIKE 'process%'";
            if (this.linkType != null) {
                linkTypeCompare = " IN ('" + Utils.toString(this.linkType, "", "','") + "')";
            }
            if (link) {
                pq.addQuery("p.id=l.object_id AND l.process_id=? AND l.object_type" + (String)linkTypeCompare);
            } else {
                pq.addQuery("p.id=l.process_id AND l.object_id=? AND l.object_type" + (String)linkTypeCompare);
            }
            pq.addInt(processId);
            pq.addQuery(ProcessDAO.getIsolationJoin(this.form, "p"));
            pq.addQuery(" WHERE 1>0 ");
            this.filterOpen(pq);
            this.filterType(pq);
            this.order(pq);
            pq.addQuery(page.getLimitSql());
            ResultSet rs = pq.executeQuery();
            while (rs.next()) {
                list.add(new Pair<String, Process>(rs.getString(1), ProcessDAO.getProcessFromRs(rs, "p.")));
            }
            page.setRecordCount(pq.getPrepared());
        }
    }
}

