/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.exec.scheduler;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javassist.NotFoundException;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.exec.scheduler.TaskConfig;

public class TasksConfig
extends Config {
    private final List<TaskConfig> taskConfigs;

    protected TasksConfig(ConfigMap config) {
        super(null);
        this.taskConfigs = this.loadTaskConfigs(config);
    }

    private List<TaskConfig> loadTaskConfigs(ConfigMap config) {
        ArrayList<TaskConfig> result = new ArrayList<TaskConfig>();
        log.info("Loading task configs", new Object[0]);
        for (Map.Entry<String, ConfigMap> me : config.subKeyed("scheduler.task.").entrySet()) {
            String taskId = me.getKey();
            try {
                result.add(new TaskConfig(taskId, me.getValue()));
            }
            catch (Throwable e) {
                log.error("Load task config: {}, error: {}", taskId, e.getMessage(), e);
            }
        }
        return Collections.unmodifiableList(result);
    }

    List<TaskConfig> taskConfigsToRun(ZonedDateTime time) {
        return this.taskConfigs.stream().filter(tc -> tc.isEnabled() && tc.checkTime(time)).collect(Collectors.toList());
    }

    public List<TaskConfig> getTaskConfigs() {
        return this.taskConfigs;
    }

    public TaskConfig getTaskConfigOrThrow(String id) throws NotFoundException {
        return this.taskConfigs.stream().filter(tc -> id.equals(tc.getId())).findFirst().orElseThrow(() -> new NotFoundException("Task configuration not found with ID: " + id));
    }
}

