/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.action.admin;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.cache.ParameterCache;
import org.bgerp.cache.ProcessTypeCache;
import org.bgerp.dao.param.ParamDAO;
import org.bgerp.dao.param.ParamGroupDAO;
import org.bgerp.model.Pageable;
import org.bgerp.model.base.IdStringTitle;
import org.bgerp.model.param.Parameter;
import org.bgerp.util.Dynamic;
import org.bgerp.util.sql.LikePattern;
import ru.bgcrm.dao.PatternDAO;
import ru.bgcrm.model.param.ParameterGroup;
import ru.bgcrm.model.param.Pattern;
import ru.bgcrm.model.process.ProcessType;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;

@ActionServlet.Action(path="/admin/directory", pathId=true)
public class DirectoryAction
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/admin/directory";
    private static final List<Directory> DIRECTORY_LIST = List.of(new Directory("processParameter", "Process parameters", "parameterList", "process"), new Directory("userParameter", "User parameters", "parameterList", "user"), new Directory("customerParameter", "Customer parameters", "parameterList", "customer"), new Directory("customerParameterGroup", "Customer parameters groups", "parameterGroupList", null), new Directory("customerPatternTitle", "Customer title patterns", "patternTitleList", null), new Directory("addressCityParameter", "City parameters", "parameterList", "address_city"), new Directory("addressStreetParameter", "Street parameters", "parameterList", "address_street"), new Directory("addressHouseParameter", "House parameters", "parameterList", "address_house"));
    private static final Map<String, Directory> DIRECTORY_MAP = Collections.unmodifiableMap(DIRECTORY_LIST.stream().collect(Collectors.toMap(d -> d.getId(), d -> d)));

    @Override
    public ActionForward unspecified(DynActionForm form, Connection con) throws Exception {
        form.setParam("directoryId", "processParameter");
        form.setParam("method", "parameterList");
        return this.parameterList(form, con);
    }

    public ActionForward parameterList(DynActionForm form, Connection con) throws Exception {
        HttpServletRequest request = form.getHttpRequest();
        this.setDirectoryList(request);
        Pageable<Parameter> searchResult = new Pageable<Parameter>(form);
        new ParamDAO(con).searchParameter(searchResult, this.getObjectType(form.getParam("directoryId")), LikePattern.SUB.get(form.getParam("filter")), 0, null);
        return this.html(con, form, "/WEB-INF/jspf/admin/directory/parameter/list.jsp");
    }

    public ActionForward parameterUseProcess(DynActionForm form, Connection con) throws Exception {
        Integer paramId = Utils.parseInt(form.getParam("parameterId"));
        ArrayList<String> containProcess = new ArrayList<String>();
        Map<Integer, ProcessType> processTypeMap = ProcessTypeCache.getProcessTypeMap();
        for (int i = 0; i < processTypeMap.size(); ++i) {
            List<Integer> parameters;
            ProcessType pType = (ProcessType)processTypeMap.values().toArray()[i];
            if (pType.isUseParentProperties() || !(parameters = pType.getProperties().getParameterIds()).contains(paramId)) continue;
            containProcess.add(pType.getTitle());
        }
        form.setResponseData("containProcess", containProcess);
        return this.html(con, form, "/WEB-INF/jspf/admin/process/used_in_types.jsp");
    }

    public ActionForward parameterGet(DynActionForm form, Connection con) throws Exception {
        ParamDAO paramDAO = new ParamDAO(con);
        Parameter parameter = paramDAO.getParameter(form.getId());
        if (parameter != null) {
            form.setResponseData("parameter", parameter);
        }
        HttpServletRequest request = form.getHttpRequest();
        this.setDirectoryList(request);
        request.setAttribute("directoryTitle", (Object)DIRECTORY_MAP.get(form.getParam("directoryId")));
        request.setAttribute("types", Parameter.TYPES);
        return this.html(con, form, "/WEB-INF/jspf/admin/directory/parameter/update.jsp");
    }

    public ActionForward parameterUpdate(DynActionForm form, Connection con) throws Exception {
        ParamDAO paramDAO = new ParamDAO(con);
        Parameter parameter = new Parameter();
        parameter.setId(form.getId());
        parameter.setObjectType(this.getObjectType(form.getParam("directoryId")));
        parameter.setType(form.getParam("type"));
        if (form.getId() > 0) {
            parameter = paramDAO.getParameter(form.getId());
        }
        parameter.setTitle(form.getParam("title"));
        parameter.setOrder(Utils.parseInt(form.getParam("order")));
        parameter.setConfig(form.getParam("config"));
        parameter.setComment(form.getParam("comment"));
        if (Set.of("list", "listcount", "tree", "treecount").contains(parameter.getType())) {
            parameter.setValuesConfig(form.getParam("listValues"));
        }
        paramDAO.updateParameter(parameter);
        ParameterCache.flush(con);
        return this.json(con, form);
    }

    public ActionForward parameterDelete(DynActionForm form, Connection con) throws Exception {
        new ParamDAO(con).deleteParameter(form.getId());
        ParameterCache.flush(con);
        return this.json(con, form);
    }

    public ActionForward patternTitleList(DynActionForm form, Connection con) throws Exception {
        PatternDAO patternDAO = new PatternDAO(con);
        HttpServletRequest request = form.getHttpRequest();
        String objectType = this.getObjectType(form.getParam("directoryId"));
        this.setDirectoryList(request);
        request.setAttribute("patternList", patternDAO.getPatternList(objectType));
        return this.html(con, form, "/WEB-INF/jspf/admin/directory/pattern/list.jsp");
    }

    public ActionForward patternTitleGet(DynActionForm form, Connection con) throws Exception {
        Pattern pattern = new PatternDAO(con).getPattern(form.getId());
        if (pattern != null) {
            form.setResponseData("pattern", pattern);
        }
        HttpServletRequest request = form.getHttpRequest();
        this.setDirectoryList(request);
        request.setAttribute("directoryTitle", (Object)DIRECTORY_MAP.get(form.getParam("directoryId")));
        return this.html(con, form, "/WEB-INF/jspf/admin/directory/pattern/update.jsp");
    }

    public ActionForward patternTitleUpdate(DynActionForm form, Connection con) throws Exception {
        PatternDAO paramDAO = new PatternDAO(con);
        Pattern pattern = new Pattern();
        pattern.setId(form.getId());
        pattern.setObject(this.getObjectType(form.getParam("directoryId")));
        pattern.setTitle(form.getParam("title"));
        pattern.setPattern(form.getParam("pattern"));
        paramDAO.updatePattern(pattern);
        return this.json(con, form);
    }

    public ActionForward patternTitleDelete(DynActionForm form, Connection con) throws Exception {
        new PatternDAO(con).deletePattern(form.getId());
        return this.json(con, form);
    }

    public ActionForward parameterGroupList(DynActionForm form, Connection con) throws Exception {
        ParamGroupDAO paramGroupDAO = new ParamGroupDAO(con);
        HttpServletRequest request = form.getHttpRequest();
        this.setDirectoryList(request);
        request.setAttribute("parameterList", paramGroupDAO.getParameterGroupList(this.getObjectType(form.getParam("directoryId"))));
        return this.html(con, form, "/WEB-INF/jspf/admin/directory/parameter/group/list.jsp");
    }

    public ActionForward parameterGroupGet(DynActionForm form, Connection con) throws Exception {
        int id = form.getId();
        ParamDAO paramDAO = new ParamDAO(con);
        ParamGroupDAO paramGroupDAO = new ParamGroupDAO(con);
        ParameterGroup parameterGroup = paramGroupDAO.getParameterGroup(id);
        if (parameterGroup != null) {
            parameterGroup.setParameterIds(paramGroupDAO.getParameterIdsForGroup(id));
            form.setResponseData("group", parameterGroup);
        }
        HttpServletRequest request = form.getHttpRequest();
        this.setDirectoryList(request);
        request.setAttribute("parameterList", paramDAO.getParameterList(this.getObjectType(form.getParam("directoryId")), 0));
        request.setAttribute("directoryTitle", (Object)DIRECTORY_MAP.get(form.getParam("directoryId")));
        return this.html(con, form, "/WEB-INF/jspf/admin/directory/parameter/group/update.jsp");
    }

    public ActionForward parameterGroupUpdate(DynActionForm form, Connection con) throws Exception {
        ParamGroupDAO paramGroupDAO = new ParamGroupDAO(con);
        ParameterGroup parameterGroup = new ParameterGroup();
        parameterGroup.setId(form.getId());
        parameterGroup.setObject(this.getObjectType(form.getParam("directoryId")));
        parameterGroup.setTitle(form.getParam("title"));
        parameterGroup.setParameterIds(form.getParamValues("param"));
        paramGroupDAO.updateParameterGroup(parameterGroup);
        ParameterCache.flush(con);
        return this.json(con, form);
    }

    public ActionForward parameterGroupDelete(DynActionForm form, Connection con) throws Exception {
        new ParamGroupDAO(con).deleteParameterGroup(form.getId());
        ParameterCache.flush(con);
        return this.json(con, form);
    }

    private void setDirectoryList(HttpServletRequest request) {
        request.setAttribute("directoryList", DIRECTORY_LIST);
    }

    private String getObjectType(String directoryId) {
        Directory directory = DIRECTORY_MAP.get(directoryId);
        if (directory != null) {
            return directory.objectType;
        }
        return null;
    }

    public static final class Directory
    extends IdStringTitle {
        private final String action;
        private final String objectType;

        public Directory(String id, String title, String action, String objectType) {
            super(id, title);
            this.action = action;
            this.objectType = objectType;
        }

        @Dynamic
        public String getAction() {
            return this.action;
        }
    }
}

