/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.action;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.struts.action.ActionForward;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.exception.BGIllegalArgumentException;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.app.exception.BGMessageExceptionWithoutL10n;
import org.bgerp.cache.ParameterCache;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.dao.process.Order;
import org.bgerp.dao.process.ProcessLinkProcessSearchDAO;
import org.bgerp.dao.process.ProcessSearchDAO;
import org.bgerp.model.Pageable;
import org.bgerp.model.param.Parameter;
import org.bgerp.model.param.ParameterValue;
import org.bgerp.model.process.link.ProcessLinkProcess;
import org.bgerp.model.process.link.config.ProcessCreateLinkConfig;
import org.bgerp.model.process.link.config.ProcessCreateLinkItem;
import org.bgerp.model.process.link.config.ProcessLinkCategory;
import org.bgerp.model.process.link.config.ProcessLinkCategoryConfig;
import org.bgerp.util.Log;
import org.bgerp.util.sql.LikePattern;
import ru.bgcrm.dao.IfaceStateDAO;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.dao.process.ProcessLinkDAO;
import ru.bgcrm.event.ParamChangedEvent;
import ru.bgcrm.event.link.LinkRemovedEvent;
import ru.bgcrm.event.link.LinkRemovingEvent;
import ru.bgcrm.event.process.ProcessCreatedAsLinkEvent;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.model.IfaceState;
import ru.bgcrm.model.Pair;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.process.ProcessType;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.action.LinkAction;
import ru.bgcrm.struts.action.ProcessLinkAction;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;
import ru.bgcrm.util.sql.SingleConnectionSet;

@ActionServlet.Action(path="/user/process/link/process", pathId=true)
public class ProcessLinkProcessAction
extends ProcessLinkAction {
    private static final Log log = Log.getLog();
    private static final String PATH_JSP = "/WEB-INF/jspf/user/process/process/link/process";

    @Override
    public ActionForward unspecified(DynActionForm form, ConnectionSet conSet) throws Exception {
        this.restoreRequestParams(conSet.getConnection(), form, true, true, "open");
        IfaceState currentState = new IfaceState(form, new String[0]);
        if (Utils.notBlankString(currentState.getIfaceId())) {
            Pair<Integer, Integer> counts = new ProcessLinkDAO(conSet.getSlaveConnection()).getLinkedProcessesCounts(form.getId());
            IfaceState newState = new IfaceState("process", form.getId(), form, String.valueOf(counts.getFirst()), String.valueOf(counts.getSecond()));
            new IfaceStateDAO(conSet.getConnection()).compareAndUpdateState(currentState, newState, form);
        }
        Process process = this.getProcess(new ProcessDAO(conSet.getSlaveConnection()), form.getId());
        ProcessType processType = ProcessLinkProcessAction.getProcessType(process.getTypeId());
        form.setRequestAttribute("config", processType.getProperties().getConfigMap().getConfig(ProcessLinkCategoryConfig.class));
        List<Pair<ProcessCreateLinkItem, Boolean>> createTypeList = processType.getProperties().getConfigMap().getConfig(ProcessCreateLinkConfig.class).getItemList(form, conSet.getSlaveConnection(), process);
        form.setRequestAttribute("createTypeList", createTypeList);
        return this.html(conSet, form, "/WEB-INF/jspf/user/process/process/link/process/default.jsp");
    }

    public ActionForward showCategory(DynActionForm form, ConnectionSet conSet) throws Exception {
        ProcessType processType = ProcessLinkProcessAction.getProcessType(this.getProcess(new ProcessDAO(conSet.getSlaveConnection()), form.getId()).getTypeId());
        int categoryId = form.getParamInt("categoryId", Utils::isPositive);
        ProcessLinkCategory category = (ProcessLinkCategory)processType.getProperties().getConfigMap().getConfig(ProcessLinkCategoryConfig.class).getCategories().get(categoryId);
        Pageable<Pair<String, Process>> pageable = new Pageable<Pair<String, Process>>(form);
        ProcessLinkProcessSearchDAO dao = ((ProcessLinkProcessSearchDAO)new ProcessLinkProcessSearchDAO(conSet.getConnection(), form).withType((Set)category.getProcessTypeIds())).withOpen(form.getParamBoolean("open", null)).withLinkType(Set.of(category.getLinkType()));
        dao.search(pageable, category.isLink(), form.getId());
        form.setRequestAttribute("category", category);
        return this.html(conSet, form, "/WEB-INF/jspf/user/process/process/link/process/show_category.jsp");
    }

    public ActionForward addCreated(DynActionForm form, ConnectionSet conSet) throws Exception {
        Process process = this.getProcess(new ProcessDAO(conSet.getSlaveConnection()), form.getId());
        ProcessType processType = ProcessLinkProcessAction.getProcessType(process.getTypeId());
        List<Pair<ProcessCreateLinkItem, Boolean>> createTypeList = processType.getProperties().getConfigMap().getConfig(ProcessCreateLinkConfig.class).getItemList(form, conSet.getSlaveConnection(), process);
        form.setRequestAttribute("createTypeList", createTypeList);
        return this.html(conSet, form, "/WEB-INF/jspf/user/process/process/link/process/add_created.jsp");
    }

    public ActionForward linkProcessCreate(DynActionForm form, Connection con) throws Exception {
        int id = form.getId();
        int typeId = form.getParamInt("typeId", -1);
        String objectType = form.getParam("objectType", "");
        int createTypeId = form.getParamInt("createTypeId", -1);
        String description = Utils.maskNull(form.getParam("description"));
        Process linkedProcess = this.getProcess(new ProcessDAO(con), id);
        ProcessLinkProcessAction.linkProcessCreate(con, form, linkedProcess, typeId, objectType, createTypeId, description, form.getParamInt("groupId", -1));
        return this.json(con, form);
    }

    public static Process linkProcessCreate(Connection con, DynActionForm form, Process linkedProcess, int typeId, String linkObjectType, int createTypeId, String description, int groupId) throws Exception {
        ProcessLinkDAO linkDao = new ProcessLinkDAO(con);
        int linkedId = linkedProcess.getId();
        ProcessType linkedType = null;
        String copyParams = null;
        Process process = new Process();
        if (createTypeId > 0) {
            linkedType = ProcessLinkProcessAction.getProcessType(linkedProcess.getTypeId());
            Pair<ProcessCreateLinkItem, Boolean> itemPair = linkedType.getProperties().getConfigMap().getConfig(ProcessCreateLinkConfig.class).getItem(form, con, linkedProcess, createTypeId);
            if (itemPair == null) {
                throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043f\u0440\u0430\u0432\u0438\u043b\u043e \u0441 ID: {}", createTypeId);
            }
            ProcessCreateLinkItem item = itemPair.getFirst();
            if (!itemPair.getSecond().booleanValue()) {
                throw new BGMessageExceptionWithoutL10n(item.getCheckErrorMessage(), new Object[0]);
            }
            linkObjectType = item.getLinkType();
            process.setTypeId(item.getProcessTypeId());
            process.setDescription(description);
            ProcessLinkProcessAction.processCreate(form, con, process, groupId);
            copyParams = item.getCopyParams();
            String copyLinks = item.getCopyLinks();
            if (Utils.notBlankString(copyLinks)) {
                if (copyLinks.equals("1")) {
                    linkDao.copyLinks(linkedId, process.getId(), null, "process%");
                } else {
                    linkDao.copyLinks(linkedId, process.getId(), copyLinks, "process%");
                }
            }
        } else {
            process.setTypeId(typeId);
            process.setDescription(description);
            ProcessLinkProcessAction.processCreate(form, con, process, -1);
        }
        linkDao.addLink(new ProcessLinkProcess(linkedId, linkObjectType, process.getId()));
        EventProcessor.processEvent(new ProcessCreatedAsLinkEvent(form, linkedProcess, process), new SingleConnectionSet(con));
        if (Utils.notBlankString(copyParams)) {
            if ("*".equals(copyParams) || "all".equals(copyParams)) {
                ArrayList<Integer> paramIdsBothHave = new ArrayList<Integer>(linkedType.getProperties().getParameterIds());
                paramIdsBothHave.retainAll(process.getType().getProperties().getParameterIds());
                copyParams = Utils.toString(paramIdsBothHave);
            }
            ParamValueDAO paramDao = new ParamValueDAO(con);
            paramDao.copyParams(linkedId, (int)process.getId(), copyParams);
            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
            for (String token : Utils.toList(copyParams, ";,")) {
                int pos = token.indexOf(58);
                int paramId = Utils.parseInt(pos > 0 ? token.substring(pos + 1) : token);
                if (paramId > 0) {
                    parameters.add(ParameterCache.getParameter(paramId));
                    continue;
                }
                log.error("Incorrect copy param mapping: {}", token);
            }
            List<ParameterValue> pairs = paramDao.loadParameters(parameters, process.getId(), true);
            SingleConnectionSet conSet = new SingleConnectionSet(con);
            for (ParameterValue pair : pairs) {
                Object value = pair.getValue();
                if (value != null) {
                    EventProcessor.processEvent(new ParamChangedEvent(form, pair.getParameter(), process.getId(), value), conSet);
                    continue;
                }
                log.error("Null value for param: {}, process: {}", pair.getParameter().getId(), process.getId());
            }
        }
        return process;
    }

    public ActionForward addExisting(DynActionForm form, ConnectionSet conSet) throws Exception {
        ProcessType processType = ProcessLinkProcessAction.getProcessType(this.getProcess(new ProcessDAO(conSet.getSlaveConnection()), form.getId()).getTypeId());
        int categoryId = form.getParamInt("categoryId", Utils::isPositive);
        ProcessLinkCategory category = (ProcessLinkCategory)processType.getProperties().getConfigMap().getConfig(ProcessLinkCategoryConfig.class).getCategories().get(categoryId);
        Set<Integer> bufferProcessIds = form.getParamValues("bufferProcessId");
        Pageable<Process> processes = new Pageable<Process>(form);
        processes.getPage().setPageSize(100);
        Set<Integer> excludeIds = this.alreadyLinked(form.getId(), conSet.getSlaveConnection(), category.isLink(), category.getLinkType());
        ((ProcessSearchDAO)((ProcessSearchDAO)((ProcessSearchDAO)new ProcessSearchDAO(conSet.getSlaveConnection(), form).withType((Set)category.getProcessTypeIds())).withOpen(form.getParamBoolean("open", null)).withStatus(new HashSet<Integer>(category.getAddProcessStatusIds()))).withoutId((Set)excludeIds)).withIdOrDescriptionLike(LikePattern.SUB.get(form.getParam("filter"))).order(category.getAddProcessStatusIds().isEmpty() ? Order.DESCRIPTION : new Order.StatusesDescription(category.getAddProcessStatusIds())).search(processes);
        ArrayList<Process> listBuffer = new ArrayList<Process>(bufferProcessIds.size());
        form.setResponseData("listBuffer", listBuffer);
        Iterator<Process> listIt = processes.getList().iterator();
        while (listIt.hasNext()) {
            Process p = listIt.next();
            if (!bufferProcessIds.contains(p.getId())) continue;
            listBuffer.add(p);
            listIt.remove();
        }
        return this.html(conSet, form, "/WEB-INF/jspf/user/process/process/link/process/add_existing.jsp");
    }

    public ActionForward linkProcessExisting(DynActionForm form, ConnectionSet conSet) throws Exception {
        ProcessType processType = ProcessLinkProcessAction.getProcessType(this.getProcess(new ProcessDAO(conSet.getSlaveConnection()), form.getId()).getTypeId());
        int categoryId = form.getParamInt("categoryId", Utils::isPositive);
        ProcessLinkCategory category = (ProcessLinkCategory)processType.getProperties().getConfigMap().getConfig(ProcessLinkCategoryConfig.class).getCategories().get(categoryId);
        ProcessLinkDAO dao = new ProcessLinkDAO(conSet.getConnection());
        for (int processId : form.getParamValuesList("processId")) {
            ProcessLinkProcess l = category.isLink() ? new ProcessLinkProcess(form.getId(), category.getLinkType(), processId) : new ProcessLinkProcess(processId, category.getLinkType(), form.getId());
            LinkAction.addLink(form, conSet.getConnection(), l);
            if (!dao.checkCycles(l.getObjectId())) continue;
            throw new BGMessageException(form.l.l("\u0426\u0438\u043a\u043b\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u044c", new Object[0]), new Object[0]);
        }
        return this.json(conSet, form);
    }

    private Set<Integer> alreadyLinked(int processId, Connection con, boolean link, String linkObjectType) throws SQLException {
        Pageable<Pair<String, Process>> excluded = new Pageable().withoutPagination();
        new ProcessLinkProcessSearchDAO(con).search(excluded, link, processId);
        return excluded.getList().stream().filter(pair -> ((String)pair.getFirst()).equals(linkObjectType)).map(pair -> ((Process)pair.getSecond()).getId()).collect(Collectors.toSet());
    }

    public ActionForward linkProcessDelete(DynActionForm form, ConnectionSet conSet) throws Exception {
        CommonObjectLink link = new CommonObjectLink("process", form.getId(), form.getParam("linkObjectType", form.getParam("linkedObjectType")), form.getParamInt("linkObjectId", form.getParamInt("linkedObjectId")), "");
        if (Utils.isBlankString(link.getObjectType()) || link.getObjectId() == 0 || Utils.isBlankString(link.getLinkObjectType()) || link.getLinkObjectId() <= 0) {
            throw new BGIllegalArgumentException();
        }
        Connection con = conSet.getConnection();
        EventProcessor.processEvent(new LinkRemovingEvent(form, link), new SingleConnectionSet(con));
        new ProcessLinkDAO(con).deleteLink(link);
        EventProcessor.processEvent(new LinkRemovedEvent(form, link), new SingleConnectionSet(con));
        return this.json(conSet, form);
    }
}

