/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.reactions.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.telegram.telegrambots.meta.api.objects.reactions.ReactionType;
import org.telegram.telegrambots.meta.api.objects.reactions.ReactionTypeCustomEmoji;
import org.telegram.telegrambots.meta.api.objects.reactions.ReactionTypeEmoji;

public class ReactionDeserializer
extends StdDeserializer<ReactionType> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public ReactionDeserializer() {
        this(null);
    }

    private ReactionDeserializer(Class<?> vc) {
        super(vc);
    }

    public ReactionType deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        if (node.has("type")) {
            String type = node.get("type").asText();
            if ("emoji".equals(type)) {
                return (ReactionType)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<ReactionTypeEmoji>(){});
            }
            if ("custom_emoji".equals(type)) {
                return (ReactionType)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<ReactionTypeCustomEmoji>(){});
            }
        }
        return null;
    }
}

