/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.objects.Audio;
import org.telegram.telegrambots.meta.api.objects.Chat;
import org.telegram.telegrambots.meta.api.objects.Contact;
import org.telegram.telegrambots.meta.api.objects.Dice;
import org.telegram.telegrambots.meta.api.objects.Document;
import org.telegram.telegrambots.meta.api.objects.LinkPreviewOptions;
import org.telegram.telegrambots.meta.api.objects.Location;
import org.telegram.telegrambots.meta.api.objects.PhotoSize;
import org.telegram.telegrambots.meta.api.objects.Venue;
import org.telegram.telegrambots.meta.api.objects.Video;
import org.telegram.telegrambots.meta.api.objects.VideoNote;
import org.telegram.telegrambots.meta.api.objects.Voice;
import org.telegram.telegrambots.meta.api.objects.games.Animation;
import org.telegram.telegrambots.meta.api.objects.games.Game;
import org.telegram.telegrambots.meta.api.objects.giveaway.Giveaway;
import org.telegram.telegrambots.meta.api.objects.giveaway.GiveawayWinners;
import org.telegram.telegrambots.meta.api.objects.messageorigin.MessageOrigin;
import org.telegram.telegrambots.meta.api.objects.payments.Invoice;
import org.telegram.telegrambots.meta.api.objects.polls.Poll;
import org.telegram.telegrambots.meta.api.objects.stickers.Sticker;
import org.telegram.telegrambots.meta.api.objects.stories.Story;

public class ExternalReplyInfo
implements BotApiObject {
    private static final String ORIGIN_FIELD = "origin";
    private static final String CHAT_FIELD = "chat";
    private static final String MESSAGE_ID_FIELD = "message_id";
    private static final String LINK_PREVIEW_OPTIONS_FIELD = "link_preview_options";
    private static final String ANIMATION_FIELD = "animation";
    private static final String AUDIO_FIELD = "audio";
    private static final String DOCUMENT_FIELD = "document";
    private static final String PHOTO_FIELD = "photo";
    private static final String STICKER_FIELD = "sticker";
    private static final String STORY_FIELD = "story";
    private static final String VIDEO_FIELD = "video";
    private static final String VIDEO_NOTE_FIELD = "video_note";
    private static final String VOICE_FIELD = "voice";
    private static final String HAS_MEDIA_SPOILER_FIELD = "has_media_spoiler";
    private static final String CONTACT_FIELD = "contact";
    private static final String DICE_FIELD = "dice";
    private static final String GAME_FIELD = "game";
    private static final String GIVEAWAY_FIELD = "giveaway";
    private static final String GIVEAWAY_WINNERS_FIELD = "giveaway_winners";
    private static final String INVOICE_FIELD = "invoice";
    private static final String LOCATION_FIELD = "location";
    private static final String POLL_FIELD = "poll";
    private static final String VENUE_FIELD = "venue";
    @JsonProperty(value="origin")
    private MessageOrigin origin;
    @JsonProperty(value="chat")
    private Chat chat;
    @JsonProperty(value="message_id")
    private Integer messageId;
    @JsonProperty(value="link_preview_options")
    private LinkPreviewOptions linkPreviewOptions;
    @JsonProperty(value="animation")
    private Animation animation;
    @JsonProperty(value="audio")
    private Audio audio;
    @JsonProperty(value="document")
    private Document document;
    @JsonProperty(value="photo")
    private List<PhotoSize> photo;
    @JsonProperty(value="sticker")
    private Sticker sticker;
    @JsonProperty(value="story")
    private Story story;
    @JsonProperty(value="video")
    private Video video;
    @JsonProperty(value="video_note")
    private VideoNote videoNote;
    @JsonProperty(value="voice")
    private Voice voice;
    @JsonProperty(value="has_media_spoiler")
    private Boolean hasMediaSpoiler;
    @JsonProperty(value="contact")
    private Contact contact;
    @JsonProperty(value="dice")
    private Dice dice;
    @JsonProperty(value="game")
    private Game game;
    @JsonProperty(value="giveaway")
    private Giveaway giveaway;
    @JsonProperty(value="giveaway_winners")
    private GiveawayWinners giveawayWinners;
    @JsonProperty(value="invoice")
    private Invoice invoice;
    @JsonProperty(value="location")
    private Location location;
    @JsonProperty(value="poll")
    private Poll poll;
    @JsonProperty(value="venue")
    private Venue venue;

    @JsonIgnore
    public boolean hasSticker() {
        return this.sticker != null;
    }

    @JsonIgnore
    public boolean isGroupMessage() {
        return this.chat.isGroupChat();
    }

    @JsonIgnore
    public boolean isUserMessage() {
        return this.chat.isUserChat();
    }

    @JsonIgnore
    public boolean isChannelMessage() {
        return this.chat.isChannelChat();
    }

    @JsonIgnore
    public boolean isSuperGroupMessage() {
        return this.chat.isSuperGroupChat();
    }

    @JsonIgnore
    public Long getChatId() {
        return this.chat.getId();
    }

    @JsonIgnore
    public boolean hasDocument() {
        return this.document != null;
    }

    @JsonIgnore
    public boolean hasVideo() {
        return this.video != null;
    }

    @JsonIgnore
    public boolean hasAudio() {
        return this.audio != null;
    }

    @JsonIgnore
    public boolean hasVoice() {
        return this.voice != null;
    }

    @JsonIgnore
    public boolean hasLocation() {
        return this.location != null;
    }

    @JsonIgnore
    private boolean hasGame() {
        return this.game != null;
    }

    @JsonIgnore
    public boolean hasPhoto() {
        return this.photo != null && !this.photo.isEmpty();
    }

    @JsonIgnore
    public boolean hasInvoice() {
        return this.invoice != null;
    }

    @JsonIgnore
    public boolean hasContact() {
        return this.contact != null;
    }

    @JsonIgnore
    public boolean hasVideoNote() {
        return this.videoNote != null;
    }

    @JsonIgnore
    public boolean hasAnimation() {
        return this.animation != null;
    }

    @JsonIgnore
    public boolean hasPoll() {
        return this.poll != null;
    }

    @JsonIgnore
    public boolean hasDice() {
        return this.dice != null;
    }

    @JsonIgnore
    private boolean hasStory() {
        return this.story != null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExternalReplyInfo)) {
            return false;
        }
        ExternalReplyInfo other = (ExternalReplyInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageId = this.getMessageId();
        Integer other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !((Object)this$messageId).equals(other$messageId)) {
            return false;
        }
        Boolean this$hasMediaSpoiler = this.getHasMediaSpoiler();
        Boolean other$hasMediaSpoiler = other.getHasMediaSpoiler();
        if (this$hasMediaSpoiler == null ? other$hasMediaSpoiler != null : !((Object)this$hasMediaSpoiler).equals(other$hasMediaSpoiler)) {
            return false;
        }
        MessageOrigin this$origin = this.getOrigin();
        MessageOrigin other$origin = other.getOrigin();
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        Chat this$chat = this.getChat();
        Chat other$chat = other.getChat();
        if (this$chat == null ? other$chat != null : !((Object)this$chat).equals(other$chat)) {
            return false;
        }
        LinkPreviewOptions this$linkPreviewOptions = this.getLinkPreviewOptions();
        LinkPreviewOptions other$linkPreviewOptions = other.getLinkPreviewOptions();
        if (this$linkPreviewOptions == null ? other$linkPreviewOptions != null : !((Object)this$linkPreviewOptions).equals(other$linkPreviewOptions)) {
            return false;
        }
        Animation this$animation = this.getAnimation();
        Animation other$animation = other.getAnimation();
        if (this$animation == null ? other$animation != null : !((Object)this$animation).equals(other$animation)) {
            return false;
        }
        Audio this$audio = this.getAudio();
        Audio other$audio = other.getAudio();
        if (this$audio == null ? other$audio != null : !((Object)this$audio).equals(other$audio)) {
            return false;
        }
        Document this$document = this.getDocument();
        Document other$document = other.getDocument();
        if (this$document == null ? other$document != null : !((Object)this$document).equals(other$document)) {
            return false;
        }
        List<PhotoSize> this$photo = this.getPhoto();
        List<PhotoSize> other$photo = other.getPhoto();
        if (this$photo == null ? other$photo != null : !((Object)this$photo).equals(other$photo)) {
            return false;
        }
        Sticker this$sticker = this.getSticker();
        Sticker other$sticker = other.getSticker();
        if (this$sticker == null ? other$sticker != null : !((Object)this$sticker).equals(other$sticker)) {
            return false;
        }
        Story this$story = this.getStory();
        Story other$story = other.getStory();
        if (this$story == null ? other$story != null : !((Object)this$story).equals(other$story)) {
            return false;
        }
        Video this$video = this.getVideo();
        Video other$video = other.getVideo();
        if (this$video == null ? other$video != null : !((Object)this$video).equals(other$video)) {
            return false;
        }
        VideoNote this$videoNote = this.getVideoNote();
        VideoNote other$videoNote = other.getVideoNote();
        if (this$videoNote == null ? other$videoNote != null : !((Object)this$videoNote).equals(other$videoNote)) {
            return false;
        }
        Voice this$voice = this.getVoice();
        Voice other$voice = other.getVoice();
        if (this$voice == null ? other$voice != null : !((Object)this$voice).equals(other$voice)) {
            return false;
        }
        Contact this$contact = this.getContact();
        Contact other$contact = other.getContact();
        if (this$contact == null ? other$contact != null : !((Object)this$contact).equals(other$contact)) {
            return false;
        }
        Dice this$dice = this.getDice();
        Dice other$dice = other.getDice();
        if (this$dice == null ? other$dice != null : !((Object)this$dice).equals(other$dice)) {
            return false;
        }
        Game this$game = this.getGame();
        Game other$game = other.getGame();
        if (this$game == null ? other$game != null : !((Object)this$game).equals(other$game)) {
            return false;
        }
        Giveaway this$giveaway = this.getGiveaway();
        Giveaway other$giveaway = other.getGiveaway();
        if (this$giveaway == null ? other$giveaway != null : !((Object)this$giveaway).equals(other$giveaway)) {
            return false;
        }
        GiveawayWinners this$giveawayWinners = this.getGiveawayWinners();
        GiveawayWinners other$giveawayWinners = other.getGiveawayWinners();
        if (this$giveawayWinners == null ? other$giveawayWinners != null : !((Object)this$giveawayWinners).equals(other$giveawayWinners)) {
            return false;
        }
        Invoice this$invoice = this.getInvoice();
        Invoice other$invoice = other.getInvoice();
        if (this$invoice == null ? other$invoice != null : !((Object)this$invoice).equals(other$invoice)) {
            return false;
        }
        Location this$location = this.getLocation();
        Location other$location = other.getLocation();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        Poll this$poll = this.getPoll();
        Poll other$poll = other.getPoll();
        if (this$poll == null ? other$poll != null : !((Object)this$poll).equals(other$poll)) {
            return false;
        }
        Venue this$venue = this.getVenue();
        Venue other$venue = other.getVenue();
        return !(this$venue == null ? other$venue != null : !((Object)this$venue).equals(other$venue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExternalReplyInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : ((Object)$messageId).hashCode());
        Boolean $hasMediaSpoiler = this.getHasMediaSpoiler();
        result = result * 59 + ($hasMediaSpoiler == null ? 43 : ((Object)$hasMediaSpoiler).hashCode());
        MessageOrigin $origin = this.getOrigin();
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        Chat $chat = this.getChat();
        result = result * 59 + ($chat == null ? 43 : ((Object)$chat).hashCode());
        LinkPreviewOptions $linkPreviewOptions = this.getLinkPreviewOptions();
        result = result * 59 + ($linkPreviewOptions == null ? 43 : ((Object)$linkPreviewOptions).hashCode());
        Animation $animation = this.getAnimation();
        result = result * 59 + ($animation == null ? 43 : ((Object)$animation).hashCode());
        Audio $audio = this.getAudio();
        result = result * 59 + ($audio == null ? 43 : ((Object)$audio).hashCode());
        Document $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : ((Object)$document).hashCode());
        List<PhotoSize> $photo = this.getPhoto();
        result = result * 59 + ($photo == null ? 43 : ((Object)$photo).hashCode());
        Sticker $sticker = this.getSticker();
        result = result * 59 + ($sticker == null ? 43 : ((Object)$sticker).hashCode());
        Story $story = this.getStory();
        result = result * 59 + ($story == null ? 43 : ((Object)$story).hashCode());
        Video $video = this.getVideo();
        result = result * 59 + ($video == null ? 43 : ((Object)$video).hashCode());
        VideoNote $videoNote = this.getVideoNote();
        result = result * 59 + ($videoNote == null ? 43 : ((Object)$videoNote).hashCode());
        Voice $voice = this.getVoice();
        result = result * 59 + ($voice == null ? 43 : ((Object)$voice).hashCode());
        Contact $contact = this.getContact();
        result = result * 59 + ($contact == null ? 43 : ((Object)$contact).hashCode());
        Dice $dice = this.getDice();
        result = result * 59 + ($dice == null ? 43 : ((Object)$dice).hashCode());
        Game $game = this.getGame();
        result = result * 59 + ($game == null ? 43 : ((Object)$game).hashCode());
        Giveaway $giveaway = this.getGiveaway();
        result = result * 59 + ($giveaway == null ? 43 : ((Object)$giveaway).hashCode());
        GiveawayWinners $giveawayWinners = this.getGiveawayWinners();
        result = result * 59 + ($giveawayWinners == null ? 43 : ((Object)$giveawayWinners).hashCode());
        Invoice $invoice = this.getInvoice();
        result = result * 59 + ($invoice == null ? 43 : ((Object)$invoice).hashCode());
        Location $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        Poll $poll = this.getPoll();
        result = result * 59 + ($poll == null ? 43 : ((Object)$poll).hashCode());
        Venue $venue = this.getVenue();
        result = result * 59 + ($venue == null ? 43 : ((Object)$venue).hashCode());
        return result;
    }

    public MessageOrigin getOrigin() {
        return this.origin;
    }

    public Chat getChat() {
        return this.chat;
    }

    public Integer getMessageId() {
        return this.messageId;
    }

    public LinkPreviewOptions getLinkPreviewOptions() {
        return this.linkPreviewOptions;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public Audio getAudio() {
        return this.audio;
    }

    public Document getDocument() {
        return this.document;
    }

    public List<PhotoSize> getPhoto() {
        return this.photo;
    }

    public Sticker getSticker() {
        return this.sticker;
    }

    public Story getStory() {
        return this.story;
    }

    public Video getVideo() {
        return this.video;
    }

    public VideoNote getVideoNote() {
        return this.videoNote;
    }

    public Voice getVoice() {
        return this.voice;
    }

    public Boolean getHasMediaSpoiler() {
        return this.hasMediaSpoiler;
    }

    public Contact getContact() {
        return this.contact;
    }

    public Dice getDice() {
        return this.dice;
    }

    public Game getGame() {
        return this.game;
    }

    public Giveaway getGiveaway() {
        return this.giveaway;
    }

    public GiveawayWinners getGiveawayWinners() {
        return this.giveawayWinners;
    }

    public Invoice getInvoice() {
        return this.invoice;
    }

    public Location getLocation() {
        return this.location;
    }

    public Poll getPoll() {
        return this.poll;
    }

    public Venue getVenue() {
        return this.venue;
    }

    @JsonProperty(value="origin")
    public void setOrigin(MessageOrigin origin) {
        this.origin = origin;
    }

    @JsonProperty(value="chat")
    public void setChat(Chat chat) {
        this.chat = chat;
    }

    @JsonProperty(value="message_id")
    public void setMessageId(Integer messageId) {
        this.messageId = messageId;
    }

    @JsonProperty(value="link_preview_options")
    public void setLinkPreviewOptions(LinkPreviewOptions linkPreviewOptions) {
        this.linkPreviewOptions = linkPreviewOptions;
    }

    @JsonProperty(value="animation")
    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    @JsonProperty(value="audio")
    public void setAudio(Audio audio) {
        this.audio = audio;
    }

    @JsonProperty(value="document")
    public void setDocument(Document document) {
        this.document = document;
    }

    @JsonProperty(value="photo")
    public void setPhoto(List<PhotoSize> photo) {
        this.photo = photo;
    }

    @JsonProperty(value="sticker")
    public void setSticker(Sticker sticker) {
        this.sticker = sticker;
    }

    @JsonProperty(value="story")
    public void setStory(Story story) {
        this.story = story;
    }

    @JsonProperty(value="video")
    public void setVideo(Video video) {
        this.video = video;
    }

    @JsonProperty(value="video_note")
    public void setVideoNote(VideoNote videoNote) {
        this.videoNote = videoNote;
    }

    @JsonProperty(value="voice")
    public void setVoice(Voice voice) {
        this.voice = voice;
    }

    @JsonProperty(value="has_media_spoiler")
    public void setHasMediaSpoiler(Boolean hasMediaSpoiler) {
        this.hasMediaSpoiler = hasMediaSpoiler;
    }

    @JsonProperty(value="contact")
    public void setContact(Contact contact) {
        this.contact = contact;
    }

    @JsonProperty(value="dice")
    public void setDice(Dice dice) {
        this.dice = dice;
    }

    @JsonProperty(value="game")
    public void setGame(Game game) {
        this.game = game;
    }

    @JsonProperty(value="giveaway")
    public void setGiveaway(Giveaway giveaway) {
        this.giveaway = giveaway;
    }

    @JsonProperty(value="giveaway_winners")
    public void setGiveawayWinners(GiveawayWinners giveawayWinners) {
        this.giveawayWinners = giveawayWinners;
    }

    @JsonProperty(value="invoice")
    public void setInvoice(Invoice invoice) {
        this.invoice = invoice;
    }

    @JsonProperty(value="location")
    public void setLocation(Location location) {
        this.location = location;
    }

    @JsonProperty(value="poll")
    public void setPoll(Poll poll) {
        this.poll = poll;
    }

    @JsonProperty(value="venue")
    public void setVenue(Venue venue) {
        this.venue = venue;
    }

    public String toString() {
        return "ExternalReplyInfo(origin=" + this.getOrigin() + ", chat=" + this.getChat() + ", messageId=" + this.getMessageId() + ", linkPreviewOptions=" + this.getLinkPreviewOptions() + ", animation=" + this.getAnimation() + ", audio=" + this.getAudio() + ", document=" + this.getDocument() + ", photo=" + this.getPhoto() + ", sticker=" + this.getSticker() + ", story=" + this.getStory() + ", video=" + this.getVideo() + ", videoNote=" + this.getVideoNote() + ", voice=" + this.getVoice() + ", hasMediaSpoiler=" + this.getHasMediaSpoiler() + ", contact=" + this.getContact() + ", dice=" + this.getDice() + ", game=" + this.getGame() + ", giveaway=" + this.getGiveaway() + ", giveawayWinners=" + this.getGiveawayWinners() + ", invoice=" + this.getInvoice() + ", location=" + this.getLocation() + ", poll=" + this.getPoll() + ", venue=" + this.getVenue() + ")";
    }

    public ExternalReplyInfo() {
    }

    public ExternalReplyInfo(MessageOrigin origin, Chat chat, Integer messageId, LinkPreviewOptions linkPreviewOptions, Animation animation, Audio audio, Document document, List<PhotoSize> photo, Sticker sticker, Story story, Video video, VideoNote videoNote, Voice voice, Boolean hasMediaSpoiler, Contact contact, Dice dice, Game game, Giveaway giveaway, GiveawayWinners giveawayWinners, Invoice invoice, Location location, Poll poll, Venue venue) {
        this.origin = origin;
        this.chat = chat;
        this.messageId = messageId;
        this.linkPreviewOptions = linkPreviewOptions;
        this.animation = animation;
        this.audio = audio;
        this.document = document;
        this.photo = photo;
        this.sticker = sticker;
        this.story = story;
        this.video = video;
        this.videoNote = videoNote;
        this.voice = voice;
        this.hasMediaSpoiler = hasMediaSpoiler;
        this.contact = contact;
        this.dice = dice;
        this.game = game;
        this.giveaway = giveaway;
        this.giveawayWinners = giveawayWinners;
        this.invoice = invoice;
        this.location = location;
        this.poll = poll;
        this.venue = venue;
    }
}

