/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.updatingmessages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class DeleteMessages
extends BotApiMethodBoolean {
    private static final String PATH = "deleteMessages";
    private static final String CHAT_ID_FIELD = "chat_id";
    private static final String MESSAGE_IDS_FIELD = "message_ids";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="message_ids")
    @NonNull
    private List<Integer> messageIds;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.messageIds.isEmpty() || this.messageIds.size() > 100) {
            throw new TelegramApiValidationException("MessageIds parameter items count must be between 1 and 100", this);
        }
    }

    public static DeleteMessagesBuilder builder() {
        return new DeleteMessagesBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteMessages)) {
            return false;
        }
        DeleteMessages other = (DeleteMessages)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        List<Integer> this$messageIds = this.getMessageIds();
        List<Integer> other$messageIds = other.getMessageIds();
        return !(this$messageIds == null ? other$messageIds != null : !((Object)this$messageIds).equals(other$messageIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeleteMessages;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        List<Integer> $messageIds = this.getMessageIds();
        result = result * 59 + ($messageIds == null ? 43 : ((Object)$messageIds).hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    public List<Integer> getMessageIds() {
        return this.messageIds;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="message_ids")
    public void setMessageIds(@NonNull List<Integer> messageIds) {
        if (messageIds == null) {
            throw new NullPointerException("messageIds is marked non-null but is null");
        }
        this.messageIds = messageIds;
    }

    public String toString() {
        return "DeleteMessages(chatId=" + this.getChatId() + ", messageIds=" + this.getMessageIds() + ")";
    }

    public DeleteMessages() {
    }

    public DeleteMessages(@NonNull String chatId, @NonNull List<Integer> messageIds) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (messageIds == null) {
            throw new NullPointerException("messageIds is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageIds = messageIds;
    }

    public static class DeleteMessagesBuilder {
        private String chatId;
        private ArrayList<Integer> messageIds;

        public DeleteMessagesBuilder chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        DeleteMessagesBuilder() {
        }

        @JsonProperty(value="chat_id")
        public DeleteMessagesBuilder chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this;
        }

        public DeleteMessagesBuilder messageId(Integer messageId) {
            if (this.messageIds == null) {
                this.messageIds = new ArrayList();
            }
            this.messageIds.add(messageId);
            return this;
        }

        @JsonProperty(value="message_ids")
        public DeleteMessagesBuilder messageIds(Collection<? extends Integer> messageIds) {
            if (messageIds == null) {
                throw new NullPointerException("messageIds cannot be null");
            }
            if (this.messageIds == null) {
                this.messageIds = new ArrayList();
            }
            this.messageIds.addAll(messageIds);
            return this;
        }

        public DeleteMessagesBuilder clearMessageIds() {
            if (this.messageIds != null) {
                this.messageIds.clear();
            }
            return this;
        }

        public DeleteMessages build() {
            List<Integer> messageIds;
            switch (this.messageIds == null ? 0 : this.messageIds.size()) {
                case 0: {
                    messageIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    messageIds = Collections.singletonList(this.messageIds.get(0));
                    break;
                }
                default: {
                    messageIds = Collections.unmodifiableList(new ArrayList<Integer>(this.messageIds));
                }
            }
            return new DeleteMessages(this.chatId, messageIds);
        }

        public String toString() {
            return "DeleteMessages.DeleteMessagesBuilder(chatId=" + this.chatId + ", messageIds=" + this.messageIds + ")";
        }
    }
}

