/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.SimpleJasperReportsContext;
import net.sf.jasperreports.engine.util.FileResolver;
import net.sf.jasperreports.repo.DefaultRepositoryService;
import net.sf.jasperreports.repo.RepositoryService;

public class LocalJasperReportsContext
extends SimpleJasperReportsContext {
    private AtomicReference<List<RepositoryService>> localRepositoryServicesRef = new AtomicReference();
    protected volatile DefaultRepositoryService localRepositoryService;

    public LocalJasperReportsContext(JasperReportsContext parent) {
        super(parent);
    }

    public static JasperReportsContext getLocalContext(JasperReportsContext jasperReportsContext, Map<String, Object> parameterValues) {
        if (parameterValues.containsKey("REPORT_CLASS_LOADER")) {
            LocalJasperReportsContext localJasperReportsContext = new LocalJasperReportsContext(jasperReportsContext);
            if (parameterValues.containsKey("REPORT_CLASS_LOADER")) {
                localJasperReportsContext.setClassLoader((ClassLoader)parameterValues.get("REPORT_CLASS_LOADER"));
            }
            return localJasperReportsContext;
        }
        return jasperReportsContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DefaultRepositoryService getLocalRepositoryService() {
        DefaultRepositoryService service = this.localRepositoryService;
        if (service == null) {
            LocalJasperReportsContext localJasperReportsContext = this;
            synchronized (localJasperReportsContext) {
                service = this.localRepositoryService;
                if (service == null) {
                    service = this.localRepositoryService = new DefaultRepositoryService(this);
                }
            }
        }
        return service;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.getLocalRepositoryService().setClassLoader(classLoader);
    }

    public void setURLStreamHandlerFactory(URLStreamHandlerFactory urlHandlerFactory) {
        this.getLocalRepositoryService().setURLStreamHandlerFactory(urlHandlerFactory);
    }

    public void setFileResolver(FileResolver fileResolver) {
        this.getLocalRepositoryService().setFileResolver(fileResolver);
    }

    @Override
    public <T> List<T> getExtensions(Class<T> extensionType) {
        DefaultRepositoryService localRepository = this.localRepositoryService;
        if (localRepository != null && RepositoryService.class.equals(extensionType)) {
            List<RepositoryService> localRepositoryServices = this.localRepositoryServicesRef.get();
            if (localRepositoryServices == null && !this.localRepositoryServicesRef.compareAndSet(null, localRepositoryServices = this.getRepositoryServices(localRepository))) {
                localRepositoryServices = this.localRepositoryServicesRef.get();
            }
            return localRepositoryServices;
        }
        return super.getExtensions(extensionType);
    }

    protected List<RepositoryService> getRepositoryServices(DefaultRepositoryService localRepository) {
        ArrayList<RepositoryService> localServices = new ArrayList<RepositoryService>();
        List<RepositoryService> repoServices = super.getExtensions(RepositoryService.class);
        if (repoServices != null && repoServices.size() > 0) {
            for (RepositoryService repoService : repoServices) {
                if (repoService instanceof DefaultRepositoryService) {
                    localServices.add(localRepository);
                    continue;
                }
                localServices.add(repoService);
            }
        }
        return localServices;
    }
}

