/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.awt.Color;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBoxPen;
import net.sf.jasperreports.engine.export.HyperlinkUtil;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.oasis.DocumentBuilder;
import net.sf.jasperreports.engine.export.oasis.StyleCache;
import net.sf.jasperreports.engine.export.oasis.Utility;
import net.sf.jasperreports.engine.export.oasis.WriterHelper;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextUtil;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.engine.util.StyledTextWriteContext;

public class TableBuilder {
    private final DocumentBuilder documentBuilder;
    protected String tableName;
    private final JasperPrint jasperPrint;
    private int pageFormatIndex;
    private final WriterHelper bodyWriter;
    private final WriterHelper styleWriter;
    private final StyleCache styleCache;
    private boolean isFrame;
    private boolean isPageBreak;
    private String tableStyleName;
    private Map<Integer, String> rowStyles;
    private Map<Integer, String> columnStyles;
    private Color tabColor;
    private boolean rowTagOpen;

    protected TableBuilder(DocumentBuilder documentBuilder, JasperPrint jasperPrint, String name, WriterHelper bodyWriter, WriterHelper styleWriter, StyleCache styleCache, Map<Integer, String> rowStyles, Map<Integer, String> columnStyles, Color tabColor) {
        this.documentBuilder = documentBuilder;
        this.jasperPrint = jasperPrint;
        this.isFrame = true;
        this.isPageBreak = false;
        this.bodyWriter = bodyWriter;
        this.styleWriter = styleWriter;
        this.styleCache = styleCache;
        this.tableName = "TBL_" + name;
        this.rowStyles = rowStyles == null ? new HashMap() : rowStyles;
        this.columnStyles = columnStyles == null ? new HashMap() : columnStyles;
        this.tabColor = tabColor;
    }

    protected TableBuilder(DocumentBuilder documentBuilder, JasperPrint jasperPrint, String name, WriterHelper bodyWriter, WriterHelper styleWriter, StyleCache styleCache, Map<Integer, String> rowStyles, Map<Integer, String> columnStyles) {
        this(documentBuilder, jasperPrint, name, bodyWriter, styleWriter, styleCache, rowStyles, columnStyles, null);
    }

    protected TableBuilder(DocumentBuilder documentBuilder, JasperPrint jasperPrint, int pageFormatIndex, int pageIndex, WriterHelper bodyWriter, WriterHelper styleWriter, StyleCache styleCache, Map<Integer, String> rowStyles, Map<Integer, String> columnStyles, Color tabColor) {
        this.documentBuilder = documentBuilder;
        this.jasperPrint = jasperPrint;
        this.isFrame = false;
        this.isPageBreak = pageFormatIndex != 0 || pageIndex != 0;
        this.pageFormatIndex = pageFormatIndex;
        this.bodyWriter = bodyWriter;
        this.styleWriter = styleWriter;
        this.styleCache = styleCache;
        this.tableName = "TBL_" + pageFormatIndex + "_" + pageIndex;
        this.rowStyles = rowStyles == null ? new HashMap() : rowStyles;
        this.columnStyles = columnStyles == null ? new HashMap() : columnStyles;
        this.tabColor = tabColor;
    }

    protected TableBuilder(DocumentBuilder documentBuilder, JasperPrint jasperPrint, int pageFormatIndex, int pageIndex, WriterHelper bodyWriter, WriterHelper styleWriter, StyleCache styleCache, Map<Integer, String> rowStyles, Map<Integer, String> columnStyles) {
        this(documentBuilder, jasperPrint, pageFormatIndex, pageIndex, bodyWriter, styleWriter, styleCache, rowStyles, columnStyles, null);
    }

    public void buildTableStyle(int width) {
        try {
            this.tableStyleName = this.styleCache.getTableStyle(width, this.pageFormatIndex, this.isFrame, this.isPageBreak, this.tabColor);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    public void buildTableHeader() {
        this.bodyWriter.write("<table:table");
        if (this.isFrame) {
            this.bodyWriter.write(" is-subtable=\"true\"");
        }
        this.bodyWriter.write(" table:name=\"");
        this.bodyWriter.write(this.tableName);
        this.bodyWriter.write("\"");
        this.bodyWriter.write(" table:style-name=\"");
        this.bodyWriter.write(this.tableStyleName);
        this.bodyWriter.write("\"");
        this.bodyWriter.write(">\n");
    }

    public void buildTableFooter() {
        this.bodyWriter.write("</table:table>\n");
    }

    public void buildRowStyle(int rowIndex, int rowHeight) {
        try {
            this.rowStyles.put(rowHeight, this.styleCache.getRowStyle(rowHeight));
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    public void buildRowHeader(int rowHeight) {
        this.bodyWriter.write("<table:table-row");
        this.bodyWriter.write(" table:style-name=\"" + this.rowStyles.get(rowHeight) + "\"");
        this.bodyWriter.write(">\n");
        this.rowTagOpen = true;
    }

    public void buildRowFooter() {
        if (this.rowTagOpen) {
            this.bodyWriter.write("</table:table-row>\n");
            this.rowTagOpen = false;
        }
    }

    public void buildRow(int rowIndex, int rowHeight) {
        if (rowIndex > 0) {
            this.buildRowFooter();
        }
        this.buildRowHeader(rowHeight);
    }

    public void buildColumnStyle(int colIndex, int colWidth) {
        try {
            this.columnStyles.put(colWidth, this.styleCache.getColumnStyle(colWidth));
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    public void buildColumnHeader(int colWidth) {
        this.bodyWriter.write("<table:table-column");
        this.bodyWriter.write(" table:style-name=\"" + this.columnStyles.get(colWidth) + "\"");
        this.bodyWriter.write(">\n");
    }

    public void buildColumnFooter() {
        this.bodyWriter.write("</table:table-column>\n");
    }

    public void buildCellHeader(String cellStyleName, int colSpan, int rowSpan) {
        this.bodyWriter.write("<table:table-cell");
        if (cellStyleName != null) {
            this.bodyWriter.write(" table:style-name=\"" + cellStyleName + "\"");
        }
        if (colSpan > 1) {
            this.bodyWriter.write(" table:number-columns-spanned=\"" + colSpan + "\"");
        }
        if (rowSpan > 1) {
            this.bodyWriter.write(" table:number-rows-spanned=\"" + rowSpan + "\"");
        }
        this.bodyWriter.write(">\n");
    }

    public void buildCellFooter() {
        this.bodyWriter.write("</table:table-cell>\n");
    }

    public void exportRectangle(JRPrintGraphicElement rectangle, JRExporterGridCell gridCell) {
        JRBaseLineBox box = new JRBaseLineBox(null);
        JRBoxPen pen = box.getPen();
        pen.setLineColor(rectangle.getLinePen().getLineColor());
        pen.setLineStyle(rectangle.getLinePen().getLineStyleValue());
        pen.setLineWidth(rectangle.getLinePen().getLineWidth());
        gridCell.setBox(box);
        this.buildCellHeader(this.styleCache.getCellStyle(gridCell), gridCell.getColSpan(), gridCell.getRowSpan());
        this.buildCellFooter();
    }

    public void exportLine(JRPrintLine line, JRExporterGridCell gridCell) {
        double y2;
        double x2;
        double y1;
        double x1;
        this.buildCellHeader(null, gridCell.getColSpan(), gridCell.getRowSpan());
        if (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN) {
            x1 = 0.0;
            y1 = 0.0;
            x2 = line.getWidth() - 1;
            y2 = line.getHeight() - 1;
        } else {
            x1 = 0.0;
            y1 = line.getHeight() - 1;
            x2 = line.getWidth() - 1;
            y2 = 0.0;
        }
        this.bodyWriter.write("<text:p>");
        this.documentBuilder.insertPageAnchor(this);
        this.bodyWriter.write("<draw:line text:anchor-type=\"paragraph\" draw:style-name=\"" + this.styleCache.getGraphicStyle(line) + "\" svg:x1=\"" + LengthUtil.inchFloor4Dec(x1) + "in\" svg:y1=\"" + LengthUtil.inchFloor4Dec(y1) + "in\" svg:x2=\"" + LengthUtil.inchFloor4Dec(x2) + "in\" svg:y2=\"" + LengthUtil.inchFloor4Dec(y2) + "in\"><text:p/></draw:line></text:p>");
        this.buildCellFooter();
    }

    public void exportEllipse(JRPrintEllipse ellipse, JRExporterGridCell gridCell) {
        this.buildCellHeader(null, gridCell.getColSpan(), gridCell.getRowSpan());
        this.bodyWriter.write("<text:p>");
        this.documentBuilder.insertPageAnchor(this);
        this.bodyWriter.write("<draw:ellipse text:anchor-type=\"paragraph\" draw:style-name=\"" + this.styleCache.getGraphicStyle(ellipse) + "\" svg:width=\"" + LengthUtil.inchFloor4Dec(ellipse.getWidth()) + "in\" svg:height=\"" + LengthUtil.inchFloor4Dec(ellipse.getHeight()) + "in\" svg:x=\"0in\" svg:y=\"0in\"><text:p/></draw:ellipse></text:p>");
        this.buildCellFooter();
    }

    public void exportText(JRPrintText text, JRExporterGridCell gridCell, boolean shrinkToFit, boolean wrapText, boolean isIgnoreTextFormatting) {
        this.buildCellHeader(isIgnoreTextFormatting ? null : this.styleCache.getCellStyle(gridCell, shrinkToFit, wrapText), gridCell.getColSpan(), gridCell.getRowSpan());
        this.bodyWriter.write("<text:p text:style-name=\"");
        this.bodyWriter.write(this.styleCache.getParagraphStyle(text, isIgnoreTextFormatting));
        this.bodyWriter.write("\">");
        this.documentBuilder.insertPageAnchor(this);
        if (text.getAnchorName() != null) {
            this.exportAnchor(JRStringUtil.xmlEncode(text.getAnchorName()));
        }
        this.exportTextContents(text);
        this.bodyWriter.write("</text:p>\n");
        this.buildCellFooter();
    }

    protected void exportTextContents(JRPrintText text) {
        boolean startedHyperlink = this.startHyperlink(text, true);
        this.exportStyledText(text, startedHyperlink, false);
        if (startedHyperlink) {
            this.endHyperlink(true);
        }
    }

    protected void exportStyledText(JRPrintText text, boolean startedHyperlink, boolean isIgnoreTextFormatting) {
        JRStyledText styledText = this.documentBuilder.getStyledText(text);
        if (styledText != null && styledText.length() > 0) {
            this.exportStyledText(styledText, this.documentBuilder.getTextLocale(text), startedHyperlink, isIgnoreTextFormatting);
        }
    }

    protected void exportStyledText(JRStyledText styledText, Locale locale, boolean startedHyperlink, boolean isIgnoreTextFormatting) {
        StyledTextWriteContext context = new StyledTextWriteContext();
        String text = styledText.getText();
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            Map<AttributedCharacterIterator.Attribute, Object> attributes = iterator.getAttributes();
            String runText = text.substring(iterator.getIndex(), runLimit);
            context.next(attributes, runText);
            if (runText.length() > 0) {
                String bulletText = JRStyledTextUtil.getIndentedBulletText(context);
                this.exportStyledTextRun(attributes, (bulletText == null ? "" : bulletText) + runText, locale, startedHyperlink, isIgnoreTextFormatting);
            }
            iterator.setIndex(runLimit);
        }
    }

    protected void exportStyledTextRun(Map<AttributedCharacterIterator.Attribute, Object> attributes, String text, Locale locale, boolean startedHyperlink, boolean isIgnoreTextFormatting) {
        JRPrintHyperlink hyperlink;
        this.startTextSpan(attributes, text, locale, isIgnoreTextFormatting);
        boolean localHyperlink = false;
        if (!startedHyperlink && (hyperlink = (JRPrintHyperlink)attributes.get(JRTextAttribute.HYPERLINK)) != null) {
            localHyperlink = this.startHyperlink(hyperlink, true);
        }
        this.writeText(text);
        if (localHyperlink) {
            this.endHyperlink(true);
        }
        this.endTextSpan();
    }

    protected void startTextSpan(Map<AttributedCharacterIterator.Attribute, Object> attributes, String text, Locale locale, boolean isIgnoreTextFormatting) {
        this.bodyWriter.write("<text:span");
        if (attributes != null) {
            String textSpanStyleName = this.styleCache.getTextSpanStyle(attributes, text, locale, isIgnoreTextFormatting);
            this.bodyWriter.write(" text:style-name=\"" + textSpanStyleName + "\"");
        }
        this.bodyWriter.write(">");
    }

    protected void endTextSpan() {
        this.bodyWriter.write("</text:span>");
    }

    protected void writeText(String text) {
        if (text != null) {
            this.bodyWriter.write(Utility.replaceNewLineWithLineBreak(JRStringUtil.xmlEncode(text, this.documentBuilder.getInvalidCharReplacement())));
        }
    }

    protected void exportAnchor(String anchorName) {
        this.bodyWriter.write("<text:bookmark text:name=\"");
        this.bodyWriter.write(anchorName);
        this.bodyWriter.write("\"/>");
    }

    protected String getIgnoreHyperlinkProperty() {
        return "net.sf.jasperreports.export.odt.ignore.hyperlink";
    }

    protected boolean startHyperlink(JRPrintHyperlink link, boolean isText) {
        return this.startHyperlink(link, isText, true);
    }

    protected boolean startHyperlink(JRPrintHyperlink link, boolean isText, boolean isOnePagePerSheet) {
        String href = null;
        String ignLnkPropName = this.getIgnoreHyperlinkProperty();
        Boolean ignoreHyperlink = HyperlinkUtil.getIgnoreHyperlink(ignLnkPropName, link);
        if (ignoreHyperlink == null) {
            ignoreHyperlink = JRPropertiesUtil.getInstance(this.getJasperReportsContext()).getBooleanProperty(this.jasperPrint, ignLnkPropName, false);
        }
        if (!ignoreHyperlink.booleanValue()) {
            href = this.documentBuilder.getHyperlinkURL(link, isOnePagePerSheet);
        }
        if (href != null) {
            this.writeHyperlink(link, href, isText);
        }
        return href != null;
    }

    protected void writeHyperlink(JRPrintHyperlink link, String href, boolean isText) {
        if (isText) {
            this.bodyWriter.write("<text:a xlink:href=\"");
        } else {
            this.bodyWriter.write("<draw:a xlink:type=\"simple\" xlink:href=\"");
        }
        this.bodyWriter.write(JRStringUtil.xmlEncode(href));
        this.bodyWriter.write("\"");
        String target = this.getHyperlinkTarget(link);
        if (target != null) {
            this.bodyWriter.write(" office:target-frame-name=\"");
            this.bodyWriter.write(target);
            this.bodyWriter.write("\"");
            if (target.equals("_blank")) {
                this.bodyWriter.write(" xlink:show=\"new\"");
            }
        }
        this.bodyWriter.write(">");
    }

    protected void endHyperlink(boolean isText) {
        if (isText) {
            this.bodyWriter.write("</text:a>");
        } else {
            this.bodyWriter.write("</draw:a>");
        }
    }

    protected String getHyperlinkTarget(JRPrintHyperlink link) {
        String target = null;
        switch (link.getHyperlinkTargetValue()) {
            case SELF: {
                target = "_self";
                break;
            }
            default: {
                target = "_blank";
            }
        }
        return target;
    }

    protected JasperReportsContext getJasperReportsContext() {
        return this.documentBuilder.getJasperReportsContext();
    }

    public String getTableName() {
        return this.tableName;
    }
}

