/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.AbstractPdfTextRenderer;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterTagHelper;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.export.pdf.PdfPhrase;
import net.sf.jasperreports.export.pdf.PdfProducer;
import net.sf.jasperreports.export.pdf.PdfTextAlignment;
import net.sf.jasperreports.export.pdf.PdfTextRendererContext;
import net.sf.jasperreports.export.pdf.TextDirection;

public abstract class SimpleAbstractPdfTextRenderer
extends AbstractPdfTextRenderer {
    private float yLine = 0.0f;
    protected boolean legacyTextMeasuringFix;

    public SimpleAbstractPdfTextRenderer(JasperReportsContext jasperReportsContext, PdfTextRendererContext context) {
        super(jasperReportsContext, context.getAwtIgnoreMissingFont(), context.getIndentFirstLine(), context.getJustifyLastLine());
        this.legacyTextMeasuringFix = context.getLegacyTextMeasuringFix();
    }

    public SimpleAbstractPdfTextRenderer(JasperReportsContext jasperReportsContext, boolean ignoreMissingFont, boolean defaultIndentFirstLine, boolean defaultJustifyLastLine) {
        super(jasperReportsContext, ignoreMissingFont, defaultIndentFirstLine, defaultJustifyLastLine);
    }

    @Override
    public void initialize(JRPdfExporter pdfExporter, PdfProducer pdfProducer, JRPdfExporterTagHelper tagHelper, JRPrintText text, JRStyledText styledText, int offsetX, int offsetY) {
        super.initialize(pdfExporter, pdfProducer, tagHelper, text, styledText, offsetX, offsetY);
        this.yLine = (float)(pdfExporter.getCurrentPageFormat().getPageHeight() - this.y - this.topPadding) - this.verticalAlignOffset - text.getLeadingOffset();
    }

    @Override
    public void render() {
        super.render();
    }

    @Override
    protected void renderParagraph(AttributedCharacterIterator allParagraphs, int paragraphStart, String paragraphText) {
        this.tagHelper.startText(this.text.getLinkType() != null);
        if (this.bulletChunk != null) {
            PdfPhrase phrase = this.pdfProducer.createPhrase();
            this.pdfExporter.getPhrase(this.bulletChunk, this.bulletText, this.text, phrase);
            phrase.go(this.x + this.leftPadding, this.yLine, this.htmlListIndent + this.x + this.leftPadding - 10, this.pdfExporter.getCurrentPageFormat().getPageHeight() - this.y - this.height + this.bottomPadding, 0.0f, this.text.getLineSpacingFactor(), PdfTextAlignment.RIGHT, TextDirection.LTR);
        }
        this.bulletText = null;
        this.bulletChunk = null;
        if (paragraphText == null) {
            String emptyText = " ";
            AttributedString paragraph = new AttributedString(emptyText, new AttributedString(allParagraphs, paragraphStart, paragraphStart + emptyText.length()).getIterator().getAttributes());
            this.createPhrase(paragraph, 0, emptyText.length(), emptyText, false);
        } else {
            AttributedString paragraph = new AttributedString(allParagraphs, paragraphStart, paragraphStart + paragraphText.length());
            this.createParagraphPhrase(paragraph, paragraphText);
        }
        this.tagHelper.endText();
    }

    protected abstract void createParagraphPhrase(AttributedString var1, String var2);

    protected void createPhrase(AttributedString paragraph, int startIndex, int endIndex, String paragraphText, boolean justifyAll) {
        PdfPhrase phrase = this.pdfProducer.createPhrase();
        this.pdfExporter.getPhrase(paragraph, startIndex, endIndex, paragraphText, this.text, phrase);
        this.yLine = phrase.go(this.htmlListIndent + this.x + this.leftPadding, this.yLine, this.x + this.width - this.rightPadding, this.pdfExporter.getCurrentPageFormat().getPageHeight() - this.y - this.height + this.bottomPadding - (this.legacyTextMeasuringFix ? 1 : 0), 0.0f, this.text.getLineSpacingFactor(), this.horizontalAlignment == PdfTextAlignment.JUSTIFIED && justifyAll ? PdfTextAlignment.JUSTIFIED_ALL : this.horizontalAlignment, this.text.getRunDirectionValue() == RunDirectionEnum.LTR ? TextDirection.LTR : TextDirection.RTL);
    }

    @Override
    protected AttributedString getAttributedString() {
        return this.styledText.getAttributedString();
    }

    @Override
    public void draw() {
    }

    @Override
    public boolean addActualText() {
        return false;
    }
}

