/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.io.JsonStringEncoder;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JsonExporterContext;
import net.sf.jasperreports.engine.export.data.BooleanTextValue;
import net.sf.jasperreports.engine.export.data.DateTextValue;
import net.sf.jasperreports.engine.export.data.NumberTextValue;
import net.sf.jasperreports.engine.export.data.StringTextValue;
import net.sf.jasperreports.engine.export.data.TextValue;
import net.sf.jasperreports.engine.export.data.TextValueHandler;
import net.sf.jasperreports.engine.type.EnumUtil;
import net.sf.jasperreports.engine.type.NamedEnum;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextUtil;
import net.sf.jasperreports.export.ExportInterruptedException;
import net.sf.jasperreports.export.ExporterInputItem;
import net.sf.jasperreports.export.JsonExporterConfiguration;
import net.sf.jasperreports.export.JsonMetadataReportConfiguration;
import net.sf.jasperreports.export.WriterExporterOutput;
import net.sf.jasperreports.export.parameters.ParametersWriterExporterOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonMetadataExporter
extends JRAbstractExporter<JsonMetadataReportConfiguration, JsonExporterConfiguration, WriterExporterOutput, JsonExporterContext> {
    private static final Log log = LogFactory.getLog(JsonMetadataExporter.class);
    public static final String JSON_EXPORTER_KEY = "net.sf.jasperreports.json";
    protected static final String JSON_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.json.";
    protected static final String EXCEPTION_MESSAGE_KEY_INVALID_JSON_OBJECT = "export.json.invalid.json.object";
    protected static final String EXCEPTION_MESSAGE_KEY_INVALID_JSON_OBJECT_SEMANTIC = "export.json.invalid.json.object.semantic";
    protected static final String EXCEPTION_MESSAGE_KEY_INVALID_JSON_OBJECT_ARRAY_FOUND = "export.json.invalid.json.object.array.found";
    public static final String JSON_EXPORTER_PATH_PROPERTY = "net.sf.jasperreports.export.json.path";
    public static final String JSON_EXPORTER_REPEAT_VALUE_PROPERTY = "net.sf.jasperreports.export.json.repeat.value";
    public static final String JSON_EXPORTER_DATA_PROPERTY = "net.sf.jasperreports.export.json.data";
    public static final String JSON_EXPORTER_REPEAT_PROPERTIES_PREFIX = "net.sf.jasperreports.export.json.repeat.";
    public static final String JSON_EXPORTER_NUMBER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.json.number.";
    public static final String JSON_EXPORTER_DATE_PROPERTIES_PREFIX = "net.sf.jasperreports.export.json.date.";
    public static final String JSON_EXPORTER_BOOLEAN_PROPERTIES_PREFIX = "net.sf.jasperreports.export.json.boolean.";
    public static final String JSON_EXPORTER_STRING_PROPERTIES_PREFIX = "net.sf.jasperreports.export.json.string.";
    private static final String JSON_SCHEMA_ROOT_NAME = "___root";
    protected final DateFormat isoDateFormat = JRDataUtils.getIsoDateFormat();
    protected Writer writer;
    protected int reportIndex;
    protected int pageIndex;
    private Map<String, SchemaNode> pathToValueNode = new HashMap<String, SchemaNode>();
    private Map<String, SchemaNode> pathToObjectNode = new HashMap<String, SchemaNode>();
    private Map<SchemaNode, ArrayList<String>> visitedMembers = new HashMap<SchemaNode, ArrayList<String>>();
    private ArrayList<SchemaNode> openedSchemaNodes = new ArrayList();
    private String jsonSchema;
    private String previousPath;
    private boolean escapeMembers;
    private boolean gotSchema;

    public void validateSchema(String jsonSchema) throws JRException {
        block4: {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            try {
                JsonNode root = mapper.readTree(jsonSchema);
                if (root.isObject()) {
                    this.pathToValueNode = new HashMap<String, SchemaNode>();
                    this.pathToObjectNode = new HashMap<String, SchemaNode>();
                    this.previousPath = null;
                    if (!this.isValid((ObjectNode)root, JSON_SCHEMA_ROOT_NAME, "", null)) {
                        throw new JRException(EXCEPTION_MESSAGE_KEY_INVALID_JSON_OBJECT_SEMANTIC, (Object[])null);
                    }
                    break block4;
                }
                throw new JRException(EXCEPTION_MESSAGE_KEY_INVALID_JSON_OBJECT_ARRAY_FOUND, (Object[])null);
            }
            catch (IOException e) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_INVALID_JSON_OBJECT, (Object[])null);
            }
        }
    }

    private boolean isValid(ObjectNode objectNode, String objectName, String currentPath, SchemaNode parent) {
        SchemaNode schemaNode;
        NodeTypeEnum nodeType;
        String nodeTypeValue = null;
        JsonNode typeNode = objectNode.path("_type");
        if (typeNode.isMissingNode()) {
            nodeTypeValue = "object";
        } else if (!typeNode.isTextual()) {
            return false;
        }
        if (nodeTypeValue == null) {
            nodeTypeValue = typeNode.asText();
        }
        if (!(NodeTypeEnum.OBJECT.equals(nodeType = NodeTypeEnum.getByName(nodeTypeValue)) || NodeTypeEnum.ARRAY.equals(nodeType) && objectNode.has("_children"))) {
            return false;
        }
        if (NodeTypeEnum.ARRAY.equals(nodeType) && !objectNode.path("_children").isObject()) {
            return false;
        }
        boolean result = true;
        String availablePath = currentPath;
        String string = availablePath.length() > 0 ? (availablePath.endsWith(".") ? availablePath : availablePath + ".") + objectName : (availablePath = objectName);
        if (parent != null) {
            schemaNode = parent;
        } else {
            int level = JSON_SCHEMA_ROOT_NAME.equals(objectName) ? 0 : (availablePath.length() > 0 && availablePath.indexOf(".") > 0 ? availablePath.split("\\.").length - 1 : 1);
            schemaNode = new SchemaNode(level, objectName, nodeType, currentPath.endsWith(".") ? currentPath.substring(0, currentPath.length() - 2) : currentPath);
            this.pathToObjectNode.put(availablePath, schemaNode);
        }
        Iterator it = objectNode.fieldNames();
        while (it.hasNext()) {
            String field = (String)it.next();
            JsonNode node = objectNode.path(field);
            String localPath = availablePath;
            if (!field.startsWith("_")) {
                schemaNode.addMember(field);
                if (node.isTextual() && node.asText().equals("value")) {
                    localPath = localPath.length() > 0 ? (localPath.endsWith(".") ? localPath : localPath + ".") + field : field;
                    this.pathToValueNode.put(localPath, schemaNode);
                    continue;
                }
                if ((!node.isObject() || this.isValid((ObjectNode)node, field, availablePath, null)) && node.isObject()) continue;
                result = false;
                break;
            }
            if (!field.equals("_children") || this.isValid((ObjectNode)node, "", availablePath, schemaNode)) continue;
            result = false;
            break;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("object is valid: " + objectNode));
            log.debug((Object)("objectName: " + objectName));
            log.debug((Object)("currentPath: " + currentPath));
        }
        return result;
    }

    public JsonMetadataExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JsonMetadataExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.exporterContext = new ExporterContext();
    }

    @Override
    protected Class<JsonExporterConfiguration> getConfigurationInterface() {
        return JsonExporterConfiguration.class;
    }

    @Override
    protected Class<JsonMetadataReportConfiguration> getItemConfigurationInterface() {
        return JsonMetadataReportConfiguration.class;
    }

    @Override
    protected void ensureOutput() {
        if (this.exporterOutput == null) {
            this.exporterOutput = new ParametersWriterExporterOutput(this.getJasperReportsContext(), this.getParameters(), this.getCurrentJasperPrint());
        }
    }

    @Override
    public String getExporterKey() {
        return JSON_EXPORTER_KEY;
    }

    @Override
    public String getExporterPropertiesPrefix() {
        return JSON_EXPORTER_PROPERTIES_PREFIX;
    }

    @Override
    public void exportReport() throws JRException {
        this.ensureJasperReportsContext();
        this.ensureInput();
        this.initExport();
        this.ensureOutput();
        this.writer = ((WriterExporterOutput)this.getExporterOutput()).getWriter();
        try {
            this.exportReportToWriter();
        }
        catch (IOException e) {
            throw new JRException("export.common.output.writer.error", new Object[]{this.jasperPrint.getName()}, e);
        }
        finally {
            ((WriterExporterOutput)this.getExporterOutput()).close();
            this.resetExportContext();
        }
    }

    @Override
    protected void initExport() {
        super.initExport();
    }

    @Override
    protected void initReport() {
        super.initReport();
    }

    protected void exportReportToWriter() throws JRException, IOException {
        List<ExporterInputItem> items = this.exporterInput.getItems();
        this.reportIndex = 0;
        while (this.reportIndex < items.size()) {
            ExporterInputItem item = items.get(this.reportIndex);
            this.setCurrentExporterInputItem(item);
            JsonMetadataReportConfiguration currentItemConfiguration = (JsonMetadataReportConfiguration)this.getCurrentItemConfiguration();
            this.escapeMembers = currentItemConfiguration.isEscapeMembers();
            String jsonSchemaResource = currentItemConfiguration.getJsonSchemaResource();
            if (jsonSchemaResource != null) {
                try (Scanner scanner = new Scanner(this.getRepository().getInputStreamFromLocation(jsonSchemaResource), StandardCharsets.UTF_8.name());){
                    this.jsonSchema = scanner.useDelimiter("\\A").next();
                }
                this.validateSchema(this.jsonSchema);
                this.gotSchema = true;
            } else if (log.isWarnEnabled()) {
                log.warn((Object)"No JSON Schema provided!");
            }
            List<JRPrintPage> pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                JRAbstractExporter.PageRange pageRange = this.getPageRange();
                int startPageIndex = pageRange == null || pageRange.getStartPageIndex() == null ? 0 : pageRange.getStartPageIndex();
                int endPageIndex = pageRange == null || pageRange.getEndPageIndex() == null ? pages.size() - 1 : pageRange.getEndPageIndex();
                JRPrintPage page = null;
                this.pageIndex = startPageIndex;
                while (this.pageIndex <= endPageIndex) {
                    this.checkInterrupted();
                    page = pages.get(this.pageIndex);
                    this.exportPage(page);
                    ++this.pageIndex;
                }
                this.closeOpenNodes();
            }
            if (log.isDebugEnabled()) {
                for (Map.Entry<String, SchemaNode> entry : this.pathToValueNode.entrySet()) {
                    log.debug((Object)("pathToValueNode: path: " + entry.getKey() + "; node: " + entry.getValue()));
                }
                for (Map.Entry<String, SchemaNode> entry : this.pathToObjectNode.entrySet()) {
                    log.debug((Object)("pathToObjectNode: path: " + entry.getKey() + "; node: " + entry.getValue()));
                }
            }
            ++this.reportIndex;
        }
        boolean flushOutput = ((JsonExporterConfiguration)this.getCurrentConfiguration()).isFlushOutput();
        if (flushOutput) {
            this.writer.flush();
        }
    }

    protected void exportPage(JRPrintPage page) throws IOException, ExportInterruptedException {
        List<JRPrintElement> elements = page.getElements();
        this.exportElements(elements);
        JRExportProgressMonitor progressMonitor = ((JsonMetadataReportConfiguration)this.getCurrentItemConfiguration()).getProgressMonitor();
        if (progressMonitor != null) {
            progressMonitor.afterPageExport();
        }
    }

    protected void exportElements(Collection<JRPrintElement> elements) throws IOException, ExportInterruptedException {
        if (elements != null && elements.size() > 0) {
            Iterator<JRPrintElement> it = elements.iterator();
            while (it.hasNext()) {
                this.checkInterrupted();
                JRPrintElement element = it.next();
                if (this.filter != null && !this.filter.isToExport(element)) continue;
                this.exportElement(element);
                if (element instanceof JRGenericPrintElement || !(element instanceof JRPrintFrame)) continue;
                this.exportElements(((JRPrintFrame)element).getElements());
            }
        }
    }

    protected void exportElement(JRPrintElement element) throws IOException {
        JRPropertiesMap propMap = element.getPropertiesMap();
        List<JRPropertiesUtil.PropertySuffix> properties = JRPropertiesUtil.getProperties(element, JSON_EXPORTER_PROPERTIES_PREFIX);
        for (JRPropertiesUtil.PropertySuffix property : properties) {
            String propertyPath = null;
            boolean repeatValue = false;
            Object value = null;
            boolean legacyPathProperty = false;
            String propertyName = property.getKey();
            if (propertyName.equals(JSON_EXPORTER_PATH_PROPERTY)) {
                legacyPathProperty = true;
                propertyPath = property.getValue();
                repeatValue = this.getPropertiesUtil().getBooleanProperty(propMap, JSON_EXPORTER_REPEAT_VALUE_PROPERTY, false);
            } else if (propertyName.startsWith(JSON_EXPORTER_STRING_PROPERTIES_PREFIX)) {
                propertyPath = propertyName.substring(JSON_EXPORTER_STRING_PROPERTIES_PREFIX.length());
                repeatValue = this.getPropertiesUtil().getBooleanProperty(propMap, JSON_EXPORTER_REPEAT_PROPERTIES_PREFIX + propertyPath, false);
                value = property.getValue();
            } else if (propertyName.startsWith(JSON_EXPORTER_NUMBER_PROPERTIES_PREFIX)) {
                propertyPath = propertyName.substring(JSON_EXPORTER_NUMBER_PROPERTIES_PREFIX.length());
                repeatValue = this.getPropertiesUtil().getBooleanProperty(propMap, JSON_EXPORTER_REPEAT_PROPERTIES_PREFIX + propertyPath, false);
                value = Double.parseDouble(property.getValue());
            } else if (propertyName.startsWith(JSON_EXPORTER_DATE_PROPERTIES_PREFIX)) {
                propertyPath = propertyName.substring(JSON_EXPORTER_DATE_PROPERTIES_PREFIX.length());
                repeatValue = this.getPropertiesUtil().getBooleanProperty(propMap, JSON_EXPORTER_REPEAT_PROPERTIES_PREFIX + propertyPath, false);
                try {
                    value = this.isoDateFormat.parse(property.getValue());
                }
                catch (ParseException e) {
                    throw new JRRuntimeException(e);
                }
            } else if (propertyName.startsWith(JSON_EXPORTER_BOOLEAN_PROPERTIES_PREFIX)) {
                propertyPath = propertyName.substring(JSON_EXPORTER_BOOLEAN_PROPERTIES_PREFIX.length());
                repeatValue = this.getPropertiesUtil().getBooleanProperty(propMap, JSON_EXPORTER_REPEAT_PROPERTIES_PREFIX + propertyPath, false);
                value = Boolean.parseBoolean(property.getValue());
            }
            if (propertyPath == null || propertyPath.length() <= 0) continue;
            String absolutePath = "___root." + propertyPath;
            if (this.gotSchema) {
                if (!this.pathToValueNode.containsKey(absolutePath)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("found element with path: " + propertyPath));
                }
                if (legacyPathProperty) {
                    value = this.getValue(element);
                }
                this.processElement(value, absolutePath, repeatValue);
                continue;
            }
            this.prepareSchema(absolutePath);
            if (log.isDebugEnabled()) {
                log.debug((Object)("found element with path: " + propertyPath));
            }
            if (legacyPathProperty) {
                value = this.getValue(element);
            }
            this.processElement(value, absolutePath, repeatValue);
        }
    }

    private void prepareSchema(String absolutePath) {
        if (!this.pathToValueNode.containsKey(absolutePath)) {
            String valueProperty = absolutePath.substring(absolutePath.lastIndexOf(".") + 1);
            String[] objectPathSegments = absolutePath.substring(0, absolutePath.lastIndexOf(".")).split("\\.");
            SchemaNode node = null;
            for (int i = 0; i < objectPathSegments.length; ++i) {
                StringBuilder objectPath = new StringBuilder(objectPathSegments[0]);
                for (int j = 1; j <= i; ++j) {
                    objectPath.append(".").append(objectPathSegments[j]);
                }
                if (!this.pathToObjectNode.containsKey(objectPath.toString())) {
                    String schemaNodePath = "";
                    for (int k = 0; k < i; ++k) {
                        schemaNodePath = schemaNodePath + (schemaNodePath.length() > 0 ? "." + objectPathSegments[k] : objectPathSegments[k]);
                    }
                    node = new SchemaNode(i, objectPathSegments[i], NodeTypeEnum.ARRAY, schemaNodePath);
                    this.pathToObjectNode.put(objectPath.toString(), node);
                } else {
                    node = this.pathToObjectNode.get(objectPath.toString());
                }
                if (i >= objectPathSegments.length - 1 || node.getMember(objectPathSegments[i + 1]) != null) continue;
                node.addMember(objectPathSegments[i + 1]);
            }
            node.addMember(valueProperty);
            this.pathToValueNode.put(absolutePath, node);
        }
    }

    private Object getValue(JRPrintElement element) throws IOException {
        Object value;
        JRPrintText printText;
        String textStr;
        boolean hasDataProp;
        if (element.getPropertiesMap().containsProperty(JSON_EXPORTER_DATA_PROPERTY)) {
            hasDataProp = true;
            textStr = element.getPropertiesMap().getProperty(JSON_EXPORTER_DATA_PROPERTY);
        } else {
            JRStyledText styledText;
            hasDataProp = false;
            textStr = element instanceof JRPrintText ? ((styledText = this.getStyledText(printText = (JRPrintText)element)) != null ? styledText.getText() : null) : null;
        }
        if (element instanceof JRPrintText) {
            printText = (JRPrintText)element;
            TextValue textValue = this.getTextValue(printText, textStr);
            LocalTextValueHandler handler = new LocalTextValueHandler(hasDataProp, textStr);
            try {
                textValue.handle(handler);
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
            value = handler.getValue();
        } else {
            value = textStr;
        }
        return value;
    }

    private void processElement(Object value, String absolutePath, boolean repeatValue) throws IOException {
        if (this.openedSchemaNodes.size() == 0) {
            this.initJson(absolutePath, value, repeatValue);
        } else {
            String valueProperty = absolutePath.substring(absolutePath.lastIndexOf(".") + 1);
            String[] curSegments = absolutePath.substring(0, absolutePath.lastIndexOf(".")).split("\\.");
            String[] prevSegments = this.previousPath.substring(0, this.previousPath.lastIndexOf(".")).split("\\.");
            int ln = Math.min(curSegments.length, prevSegments.length);
            int lastCommonIndex = -1;
            int i = 0;
            while (i < ln && curSegments[i].equals(prevSegments[i])) {
                lastCommonIndex = i++;
            }
            int commonSegmentsNo = lastCommonIndex + 1;
            if (commonSegmentsNo < prevSegments.length) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\tgot different path with common segments");
                }
                this.closeExtraPathSegments(prevSegments, lastCommonIndex);
                this.openPathSegments(curSegments, lastCommonIndex + 1);
            } else if (commonSegmentsNo == prevSegments.length && curSegments.length > prevSegments.length) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\tgot longer path than previous one");
                }
                this.openPathSegments(curSegments, lastCommonIndex + 1);
            }
            SchemaNode currentNode = this.pathToValueNode.get(absolutePath);
            if (log.isDebugEnabled()) {
                log.debug((Object)("\tcurrent node is: " + currentNode.getType().getName()));
            }
            if (currentNode.isArray()) {
                this.writePathProperty(currentNode, valueProperty, value, repeatValue);
            } else {
                this.writePathProperty(currentNode, valueProperty, value, false);
            }
        }
        this.previousPath = absolutePath;
    }

    private void writePathProperty(SchemaNode node, String valueProperty, Object value, boolean repeatValue) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("\twriting property: " + valueProperty));
        }
        ArrayList<String> vizMembers = this.visitedMembers.get(node);
        String lastProp = null;
        int lastPropIdx = -1;
        int valPropIdx = node.indexOfMember(valueProperty);
        if (vizMembers != null && vizMembers.size() > 0) {
            lastProp = vizMembers.get(vizMembers.size() - 1);
            lastPropIdx = node.indexOfMember(lastProp);
        } else {
            vizMembers = new ArrayList();
            this.visitedMembers.put(node, vizMembers);
        }
        boolean foundPreviousRepeated = false;
        if (lastProp == null || valPropIdx > lastPropIdx) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\tgot property of the same object");
            }
            if ((foundPreviousRepeated = lastProp != null ? this.writeReapeatedValues(node, lastPropIdx + 1, valPropIdx) : this.writeReapeatedValues(node, 0, valPropIdx)) || vizMembers.size() > 0) {
                this.writer.write(",\n");
            }
            this.writeEscaped(node, valueProperty, value, repeatValue);
            this.visitedMembers.get(node).add(valueProperty);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\tgot property of a new object");
            }
            this.writeReapeatedValues(node, lastPropIdx + 1, node.getMembers().size());
            this.writer.write("},\n{");
            foundPreviousRepeated = this.writeReapeatedValues(node, 0, valPropIdx);
            if (foundPreviousRepeated) {
                this.writer.write(",");
            }
            this.writeEscaped(node, valueProperty, value, repeatValue);
            this.visitedMembers.get(node).clear();
            this.visitedMembers.get(node).add(valueProperty);
        }
    }

    private boolean writeReapeatedValues(SchemaNode node, int from, int to) throws IOException {
        return this.writeReapeatedValues(node, from, to, true);
    }

    private boolean writeReapeatedValues(SchemaNode node, int from, int to, boolean startWithComma) throws IOException {
        boolean found = false;
        for (int i = from; i < to; ++i) {
            SchemaNodeMember member = node.getMember(i);
            if (!member.isRepeatValue() || member.getPreviousValue() == null) continue;
            found = true;
            if (i != 0 && startWithComma) {
                this.writer.write(",");
            }
            if (this.escapeMembers) {
                this.writer.write("\"" + member.getName() + "\":");
            } else {
                this.writer.write(member.getName() + ":");
            }
            this.writeValue(member.getPreviousValue());
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("\t\twriting repeated value for member: " + member.getName()));
        }
        return found;
    }

    private void writeEscaped(SchemaNode node, String valueProperty, Object value, boolean repeatValue) throws IOException {
        if (this.escapeMembers) {
            this.writer.write("\"" + valueProperty + "\":");
        } else {
            this.writer.write(valueProperty + ":");
        }
        this.writeValue(value);
        if (repeatValue) {
            SchemaNodeMember nodeMember = node.getMember(valueProperty);
            nodeMember.setRepeatValue(true);
            nodeMember.setPreviousValue(value);
        }
    }

    private void closeExtraPathSegments(String[] prevSegments, int lastCommonIndex) throws IOException {
        for (int i = prevSegments.length - 1; i > lastCommonIndex; --i) {
            StringBuilder sb = new StringBuilder(prevSegments[0]);
            for (int j = 1; j <= i; ++j) {
                sb.append(".").append(prevSegments[j]);
            }
            SchemaNode toClose = this.pathToObjectNode.get(sb.toString());
            if (this.openedSchemaNodes.get(this.openedSchemaNodes.size() - 1).equals(toClose)) {
                this.openedSchemaNodes.remove(this.openedSchemaNodes.size() - 1);
            } else if (log.isWarnEnabled()) {
                log.warn((Object)"unexpected");
            }
            if (toClose.isArray()) {
                List vizMembers = this.visitedMembers.get(toClose);
                String lastProp = (String)vizMembers.get(vizMembers.size() - 1);
                int lastPropIdx = toClose.indexOfMember(lastProp);
                this.writeReapeatedValues(toClose, lastPropIdx + 1, toClose.getMembers().size());
                vizMembers.clear();
            }
            if (toClose.isObject()) {
                this.writer.write("}\n");
            } else {
                this.writer.write("}]\n");
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("\t\tclosing " + toClose.getType().getName() + " path: " + sb.toString()));
        }
    }

    private void openPathSegments(String[] pathSegments, int from) throws IOException {
        for (int i = from; i < pathSegments.length; ++i) {
            StringBuilder sb = new StringBuilder(pathSegments[0]);
            StringBuilder parentPath = new StringBuilder(pathSegments[0]);
            for (int j = 1; j <= i; ++j) {
                sb.append(".").append(pathSegments[j]);
                if (j >= i) continue;
                parentPath.append(".").append(pathSegments[j]);
            }
            SchemaNode parent = this.pathToObjectNode.get(parentPath.toString());
            String currentProperty = pathSegments[i];
            boolean foundPreviousRepeated = false;
            ArrayList<String> vizMembers = this.visitedMembers.get(parent);
            String lastVisitedProp = null;
            int lastVisitedPropIdx = -1;
            int currentPropIdx = parent.indexOfMember(currentProperty);
            if (vizMembers != null && vizMembers.size() > 0) {
                lastVisitedProp = vizMembers.get(vizMembers.size() - 1);
                lastVisitedPropIdx = parent.indexOfMember(lastVisitedProp);
            }
            if (parent.isArray()) {
                if (lastVisitedProp != null) {
                    foundPreviousRepeated = this.writeReapeatedValues(parent, lastVisitedPropIdx + 1, currentPropIdx, false);
                } else {
                    vizMembers = new ArrayList();
                    this.visitedMembers.put(parent, vizMembers);
                }
                vizMembers.add(currentProperty);
            }
            if (foundPreviousRepeated || lastVisitedPropIdx != -1 && currentPropIdx > lastVisitedPropIdx) {
                this.writer.write(",");
            }
            if (this.escapeMembers) {
                this.writer.write("\"" + currentProperty + "\":");
            } else {
                this.writer.write(currentProperty + ":");
            }
            SchemaNode toOpen = this.pathToObjectNode.get(sb.toString());
            this.openedSchemaNodes.add(toOpen);
            if (toOpen.isObject()) {
                this.writer.write("{");
            } else {
                this.writer.write("[{");
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("\t\topening " + toOpen.getType().getName() + " path: " + sb.toString()));
        }
    }

    private void closeOpenNodes() throws IOException {
        if (this.openedSchemaNodes.size() == 0) {
            return;
        }
        for (int i = this.openedSchemaNodes.size() - 1; i >= 0; --i) {
            SchemaNode toClose = this.openedSchemaNodes.get(i);
            if (toClose.isArray()) {
                List vizMembers = this.visitedMembers.get(toClose);
                String lastProp = (String)vizMembers.get(vizMembers.size() - 1);
                int lastPropIdx = toClose.indexOfMember(lastProp);
                this.writeReapeatedValues(toClose, lastPropIdx + 1, toClose.getMembers().size());
                vizMembers.clear();
                this.writer.write("}]");
            } else {
                this.writer.write("}");
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("closing " + toClose.getType().getName() + " path: " + (toClose.path.length() > 0 ? toClose.path + "." : "") + toClose.name));
        }
    }

    private void initJson(String firstPath, Object firstValue, boolean repeatValue) throws IOException {
        int i;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initializing JSON with first absolute path: " + firstPath));
        }
        String[] segments = firstPath.split("\\.");
        String currentPath = "";
        SchemaNode schemaNode = null;
        for (i = 0; i < segments.length - 1; ++i) {
            currentPath = currentPath.length() > 0 ? currentPath + "." + segments[i] : segments[i];
            schemaNode = this.pathToObjectNode.get(currentPath);
            this.openedSchemaNodes.add(schemaNode);
            if (i == 0) {
                if (schemaNode.isObject()) {
                    this.writer.write("{");
                    continue;
                }
                this.writer.write("[{");
                continue;
            }
            String parentPath = currentPath.substring(0, currentPath.lastIndexOf("."));
            SchemaNode parent = this.pathToObjectNode.get(parentPath);
            String currentProperty = segments[i];
            ArrayList<String> vizMembers = new ArrayList<String>();
            vizMembers.add(currentProperty);
            this.visitedMembers.put(parent, vizMembers);
            if (schemaNode.isObject()) {
                if (this.escapeMembers) {
                    this.writer.write("\"" + currentProperty + "\": {");
                    continue;
                }
                this.writer.write(currentProperty + ": {");
                continue;
            }
            if (this.escapeMembers) {
                this.writer.write("\"" + currentProperty + "\": [{");
                continue;
            }
            this.writer.write(currentProperty + ": [{");
        }
        if (this.escapeMembers) {
            this.writer.write("\"" + segments[i] + "\": ");
        } else {
            this.writer.write(segments[i] + ": ");
        }
        this.writeValue(firstValue);
        if (schemaNode != null && repeatValue) {
            SchemaNodeMember nodeMember = schemaNode.getMember(segments[i]);
            nodeMember.setRepeatValue(true);
            nodeMember.setPreviousValue(firstValue);
        }
        ArrayList<String> members = new ArrayList<String>();
        members.add(segments[i]);
        this.visitedMembers.put(schemaNode, members);
    }

    private void writeValue(Object value) throws IOException {
        if (value != null) {
            if (value instanceof Number || value instanceof Boolean) {
                this.writer.write(value.toString());
            } else if (value instanceof Date) {
                this.writer.write("\"");
                this.writer.write(this.isoDateFormat.format((Date)value));
                this.writer.write("\"");
            } else {
                this.writer.write("\"");
                this.writer.write(JsonStringEncoder.getInstance().quoteAsString(value.toString()));
                this.writer.write("\"");
            }
        } else {
            this.writer.write("null");
        }
    }

    @Override
    protected JRStyledText getStyledText(JRPrintText textElement) {
        JRStyledText styledText = textElement.getFullStyledText(this.noneSelector);
        if (styledText != null && !"none".equals(textElement.getMarkup())) {
            styledText = JRStyledTextUtil.getBulletedText(styledText);
        }
        return styledText;
    }

    private class SchemaNode {
        private int level;
        private String name;
        private NodeTypeEnum type;
        private String path;
        private List<SchemaNodeMember> members;
        private List<String> memberNames;

        public SchemaNode(int _level, String _name, NodeTypeEnum _type, String _path) {
            this.level = _level;
            this.name = _name;
            this.type = _type;
            this.path = _path;
            this.members = new ArrayList<SchemaNodeMember>();
            this.memberNames = new ArrayList<String>();
        }

        public NodeTypeEnum getType() {
            return this.type;
        }

        public void addMember(String memberName) {
            this.members.add(new SchemaNodeMember(memberName));
            this.memberNames.add(memberName);
        }

        public boolean isObject() {
            return NodeTypeEnum.OBJECT.equals(this.type);
        }

        public boolean isArray() {
            return NodeTypeEnum.ARRAY.equals(this.type);
        }

        public int indexOfMember(String memberName) {
            return this.memberNames.indexOf(memberName);
        }

        public SchemaNodeMember getMember(int i) {
            return this.members.get(i);
        }

        public SchemaNodeMember getMember(String memberName) {
            if (this.indexOfMember(memberName) != -1) {
                return this.members.get(this.indexOfMember(memberName));
            }
            return null;
        }

        public List<SchemaNodeMember> getMembers() {
            return this.members;
        }

        public String toString() {
            StringBuilder out = new StringBuilder("{");
            boolean isArray = NodeTypeEnum.ARRAY.equals(this.type);
            out.append("level: ").append(this.level).append(", ");
            out.append("name: \"").append(this.name).append("\", ");
            out.append("type: \"").append(this.type.getName()).append("\", ");
            out.append("path: \"").append(this.path).append("\", ");
            out.append("members: [");
            if (isArray) {
                out.append("{");
            }
            int ln = this.members.size();
            for (int i = 0; i < ln; ++i) {
                out.append("\"").append(this.members.get(i).getName()).append("\"");
                if (i >= ln - 1) continue;
                out.append(", ");
            }
            if (isArray) {
                out.append("}");
            }
            out.append("]}");
            return out.toString();
        }

        public boolean equals(Object obj) {
            return this.level == ((SchemaNode)obj).level && this.name.equals(((SchemaNode)obj).name) && this.type.equals(((SchemaNode)obj).type) && this.path.equals(((SchemaNode)obj).path);
        }

        public int hashCode() {
            int hash = this.level != 0 ? this.level : 41;
            hash = hash * 41 + this.name.hashCode();
            hash = hash * 41 + this.type.hashCode();
            hash = hash * 41 + this.path.hashCode();
            return hash;
        }
    }

    private static enum NodeTypeEnum implements NamedEnum
    {
        OBJECT("object"),
        ARRAY("array");

        private final String name;

        private NodeTypeEnum(String _name) {
            this.name = _name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public static NodeTypeEnum getByName(String name) {
            return (NodeTypeEnum)EnumUtil.getEnumByName((NamedEnum[])NodeTypeEnum.values(), (String)name);
        }
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JsonExporterContext {
        protected ExporterContext() {
            super(JsonMetadataExporter.this);
        }

        @Override
        public String getHyperlinkURL(JRPrintHyperlink link) {
            return "";
        }
    }

    private class SchemaNodeMember {
        private boolean repeatValue;
        private Object previousValue;
        private String name;

        public SchemaNodeMember(String _name) {
            this.name = _name;
        }

        public String getName() {
            return this.name;
        }

        public boolean isRepeatValue() {
            return this.repeatValue;
        }

        public void setRepeatValue(boolean _repeatValue) {
            this.repeatValue = _repeatValue;
        }

        public Object getPreviousValue() {
            return this.previousValue;
        }

        public void setPreviousValue(Object _previousValue) {
            this.previousValue = _previousValue;
        }
    }

    private class LocalTextValueHandler
    implements TextValueHandler {
        Object value;
        boolean hasDataProp;
        String textStr;

        public LocalTextValueHandler(boolean hasDataProp, String textStr) {
            this.hasDataProp = hasDataProp;
            this.textStr = textStr;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public void handle(StringTextValue textValue) {
            this.value = textValue.getText();
        }

        @Override
        public void handle(NumberTextValue textValue) {
            if (this.hasDataProp) {
                if (this.textStr != null) {
                    try {
                        this.value = Double.parseDouble(this.textStr);
                    }
                    catch (NumberFormatException nfe) {
                        throw new JRRuntimeException(nfe);
                    }
                }
            } else {
                this.value = textValue.getValue();
            }
        }

        @Override
        public void handle(DateTextValue textValue) {
            if (this.hasDataProp) {
                if (this.textStr != null) {
                    try {
                        this.value = new Date(Long.parseLong(this.textStr));
                    }
                    catch (NumberFormatException nfe) {
                        try {
                            this.value = JsonMetadataExporter.this.isoDateFormat.parse(this.textStr);
                        }
                        catch (ParseException pe) {
                            throw new JRRuntimeException(pe);
                        }
                    }
                }
            } else {
                this.value = textValue.getValue();
            }
        }

        @Override
        public void handle(BooleanTextValue textValue) {
            this.value = this.hasDataProp ? Boolean.valueOf(this.textStr) : textValue.getValue();
        }
    }
}

