/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.spiderchart;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.components.spiderchart.SpiderChartCompiler;
import net.sf.jasperreports.components.spiderchart.SpiderDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.JRDesignElementDataset;

public class StandardSpiderDataset
extends JRDesignElementDataset
implements SpiderDataset {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_CATEGORY_SERIES = "categorySeries";
    private List<JRCategorySeries> categorySeriesList = new ArrayList<JRCategorySeries>();

    public StandardSpiderDataset() {
    }

    public StandardSpiderDataset(SpiderDataset dataset, JRBaseObjectFactory factory) {
        super(dataset, factory);
        JRCategorySeries[] srcCategorySeries = dataset.getSeries();
        if (srcCategorySeries != null && srcCategorySeries.length > 0) {
            for (int i = 0; i < srcCategorySeries.length; ++i) {
                this.addCategorySeries(factory.getCategorySeries(srcCategorySeries[i]));
            }
        }
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        SpiderChartCompiler.collectExpressions(this, collector);
    }

    @Override
    public JRCategorySeries[] getSeries() {
        JRCategorySeries[] categorySeriesArray = new JRCategorySeries[this.categorySeriesList.size()];
        this.categorySeriesList.toArray(categorySeriesArray);
        return categorySeriesArray;
    }

    public List<JRCategorySeries> getSeriesList() {
        return this.categorySeriesList;
    }

    public void addCategorySeries(JRCategorySeries categorySeries) {
        this.categorySeriesList.add(categorySeries);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_CATEGORY_SERIES, categorySeries, this.categorySeriesList.size() - 1);
    }

    public void addCategorySeries(int index, JRCategorySeries categorySeries) {
        if (index >= 0 && index < this.categorySeriesList.size()) {
            this.categorySeriesList.add(index, categorySeries);
        } else {
            this.categorySeriesList.add(categorySeries);
            index = this.categorySeriesList.size() - 1;
        }
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_CATEGORY_SERIES, categorySeries, index);
    }

    public JRCategorySeries removeCategorySeries(JRCategorySeries categorySeries) {
        int idx;
        if (categorySeries != null && (idx = this.categorySeriesList.indexOf(categorySeries)) >= 0) {
            this.categorySeriesList.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_CATEGORY_SERIES, categorySeries, idx);
        }
        return categorySeries;
    }
}

