/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.fulltext.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.bgerp.app.exception.BGException;
import org.bgerp.dao.customer.CustomerDAO;
import org.bgerp.model.Pageable;
import org.bgerp.model.msg.Message;
import org.bgerp.util.Log;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.dao.message.MessageDAO;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.model.Pair;
import ru.bgcrm.model.customer.Customer;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.plugin.fulltext.model.SearchItem;

public class SearchDAO
extends CommonDAO {
    private static final Log log = Log.getLog();
    public static final String TABLE = " fulltext_data ";

    public SearchDAO(Connection con) {
        super(con);
    }

    public void searchCustomer(Pageable<Customer> result, String filter) throws SQLException {
        this.searchObjects(result, filter, " customer ", "customer", rs -> {
            try {
                return CustomerDAO.getCustomerFromRs(rs, "o.");
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void searchProcess(Pageable<Process> result, String filter) throws SQLException {
        this.searchObjects(result, filter, " process ", "process", rs -> {
            try {
                return ProcessDAO.getProcessFromRs(rs, "o.");
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private <T> void searchObjects(Pageable<T> result, String filter, String tableName, String objectType, Function<ResultSet, T> extractor) throws SQLException {
        String query = "SELECT SQL_CALC_FOUND_ROWS o.* FROM  fulltext_data  AS ft  INNER JOIN " + tableName + " AS o ON ft.object_id=o.id WHERE ft.object_type=? AND MATCH(ft.data) AGAINST (? IN BOOLEAN MODE) " + result.getPage().getLimitSql();
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setString(1, objectType);
        ps.setString(2, filter);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.getList().add(extractor.apply(rs));
        }
        result.getPage().setRecordCount(ps);
        ps.close();
    }

    public void searchMessages(Pageable<Pair<Message, Process>> result, String filter) throws SQLException {
        String query = "SELECT SQL_CALC_FOUND_ROWS m.*, p.* FROM  fulltext_data  AS ft  INNER JOIN  message  AS m ON ft.object_id=m.id  LEFT JOIN  process  AS p ON m.process_id=p.id  WHERE ft.object_type=? AND MATCH(ft.data) AGAINST (? IN BOOLEAN MODE) " + result.getPage().getLimitSql();
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setString(1, "message");
        ps.setString(2, filter);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Message m = MessageDAO.getMessageFromRs(rs, "m.");
            Process p = ProcessDAO.getProcessFromRs(rs, "p.");
            result.getList().add(new Pair<Message, Process>(m, p));
        }
        result.getPage().setRecordCount(ps);
        ps.close();
    }

    public void scheduleUpdate(String objectType, int objectId) throws SQLException {
        log.debug("Updated record, objectType: {}; objectId: {}", objectType, objectId);
        this.updateOrInsert("UPDATE  fulltext_data  SET scheduled_dt=NOW() WHERE object_type=? AND object_id=?", "INSERT INTO  fulltext_data (scheduled_dt, object_type, object_id) VALUES (NOW(),?,?)", objectType, objectId);
    }

    public void delete(String objectType, int objectId) {
        log.debug("Deleted record, objectType: {}; objectId: {}", objectType, objectId);
        try {
            String query = "DELETE FROM  fulltext_data  WHERE object_type=? AND object_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, objectType);
            ps.setInt(2, objectId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public void delete(SearchItem item) {
        this.delete(item.getObjectType(), item.getObjectId());
    }

    public List<SearchItem> getScheduledUpdates(int secondsOld, int maxCount) {
        ArrayList<SearchItem> result = new ArrayList<SearchItem>();
        try {
            String query = "SELECT SQL_CALC_FOUND_ROWS object_type, object_id FROM  fulltext_data  WHERE scheduled_dt<=DATE_SUB(NOW(), INTERVAL ? SECOND) ORDER BY scheduled_dt LIMIT ?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, secondsOld);
            ps.setInt(2, maxCount);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                SearchItem item = new SearchItem();
                item.setObjectType(rs.getString(1));
                item.setObjectId(rs.getInt(2));
                result.add(item);
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    public void update(SearchItem item) {
        try {
            String query = "UPDATE  fulltext_data  SET data=?, scheduled_dt=NULL WHERE object_type=? AND object_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, item.getText());
            ps.setString(2, item.getObjectType());
            ps.setInt(3, item.getObjectId());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public void init(String objectType, String objectTable) throws SQLException {
        String query = "INSERT INTO  fulltext_data  (object_type, object_id, scheduled_dt) SELECT ?, t.id, NOW() FROM " + objectTable + " AS t LEFT JOIN  fulltext_data  AS fd ON fd.object_type=? AND t.id=fd.object_id WHERE fd.object_id IS NULL";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setString(1, objectType);
        ps.setString(2, objectType);
        ps.executeUpdate();
        ps.close();
    }
}

