/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.creator;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.exception.BGException;
import org.bgerp.cache.ParameterCache;
import org.bgerp.model.param.Parameter;
import ru.bgcrm.plugin.bgbilling.creator.ServerCustomerCreator;
import ru.bgcrm.util.Utils;

public class Config
extends org.bgerp.app.cfg.Config {
    private static final Set<String> ALLOWED_CONFIRM_PARAM_TYPES = new HashSet<String>(Arrays.asList("address", "text", "phone", "date"));
    private static final Set<String> ALLOWED_SEARCH_PARAM_TYPES = new HashSet<String>(Arrays.asList("address", "text", "phone"));
    private static final Set<String> ALLOWED_IMPORT_PARAM_TYPES = new HashSet<String>(Arrays.asList("address", "text", "phone", "date", "list", "email"));
    public final List<ServerCustomerCreator> serverCreatorList = new ArrayList<ServerCustomerCreator>();
    public final Set<String> importBillingIds;
    public final List<Parameter> confirmParameterList;
    public final List<Parameter> searchParameterList;
    private final int titleDistance;
    private final Map<Integer, Integer> titleDistanceForParam = new HashMap<Integer, Integer>();
    public final List<Parameter> importParameterList;
    private final List<ParameterGroupTitlePatternRule> paramGroupRuleList = new ArrayList<ParameterGroupTitlePatternRule>();

    public Config(ConfigMap setup) {
        super(setup);
        String prefix = "bgbilling:creator.";
        this.importBillingIds = Utils.toSet(setup.get("bgbilling:creator.importBillingIds", ""));
        this.confirmParameterList = this.loadFields(setup, "bgbilling:creator.confirmParameters", ALLOWED_CONFIRM_PARAM_TYPES);
        this.searchParameterList = this.loadFields(setup, "bgbilling:creator.searchParameters", ALLOWED_SEARCH_PARAM_TYPES);
        this.importParameterList = this.loadFields(setup, "bgbilling:creator.importParameters", ALLOWED_IMPORT_PARAM_TYPES);
        this.titleDistance = setup.getInt("bgbilling:creator.titleDistance", 2);
        for (Map.Entry<String, String> me : setup.sub("bgbilling:creator.titleDistance.").entrySet()) {
            this.titleDistanceForParam.put(Utils.parseInt(me.getKey()), Utils.parseInt(me.getValue()));
        }
        String paramGroupPrefix = "bgbilling:creator.parameterGroupRule.";
        for (Map.Entry<Integer, ConfigMap> me : setup.subIndexed("bgbilling:creator.parameterGroupRule.").entrySet()) {
            int paramGroupId = me.getValue().getInt("paramGroupId", 0);
            int titlePatternId = me.getValue().getInt("titlePatternId", -1);
            String contractTitlePattern = me.getValue().get("contractTitlePattern");
            if (paramGroupId <= 0) continue;
            ParameterGroupTitlePatternRule rule = new ParameterGroupTitlePatternRule();
            rule.parameterGroupId = paramGroupId;
            rule.titlePatternId = titlePatternId;
            if (Utils.notBlankString(contractTitlePattern)) {
                rule.pattern = Pattern.compile(contractTitlePattern);
            }
            this.paramGroupRuleList.add(rule);
        }
        log.info("Loaded " + this.paramGroupRuleList.size() + " param group rules.", new Object[0]);
        for (Map.Entry<Integer, ConfigMap> me : setup.subIndexed("bgbilling:creator.server.").entrySet()) {
            int id = me.getKey();
            ConfigMap params = me.getValue();
            try {
                this.serverCreatorList.add(new ServerCustomerCreator(this, params));
            }
            catch (Exception e) {
                throw new BGException("Error load customer creator " + id + ": " + e.getMessage(), new Object[0]);
            }
        }
    }

    public ParameterGroupTitlePatternRule getCustomerParameterGroup(String contractTitle) {
        for (ParameterGroupTitlePatternRule rule : this.paramGroupRuleList) {
            if (!rule.check(contractTitle)) continue;
            return rule;
        }
        return null;
    }

    private List<Parameter> loadFields(ConfigMap setup, String prefix, Set<String> allowedTypes) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (int paramId : Utils.toIntegerList(setup.get(prefix))) {
            if (paramId <= 0) continue;
            Parameter param = ParameterCache.getParameter(paramId);
            if (param == null) {
                throw new BGException("Can't find parameter: " + paramId, new Object[0]);
            }
            if (!allowedTypes.contains(param.getType())) {
                throw new BGException("Unsupported key param type:" + param.getType(), new Object[0]);
            }
            parameters.add(param);
        }
        return parameters;
    }

    public ServerCustomerCreator getServerCustomerCreator(String billingId, Connection con) {
        for (ServerCustomerCreator scc : this.serverCreatorList) {
            if (!billingId.equals(scc.getBillingId())) continue;
            return scc;
        }
        return null;
    }

    public int getMaxTitleDistance(int paramId) {
        if (this.titleDistanceForParam.containsKey(paramId)) {
            return this.titleDistanceForParam.get(paramId);
        }
        return this.titleDistance;
    }

    public static final class ParameterGroupTitlePatternRule {
        public int parameterGroupId;
        public int titlePatternId;
        public Pattern pattern;

        public boolean check(String contractTitle) {
            return this.pattern == null || this.pattern.matcher(contractTitle).find();
        }
    }
}

