/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.asterisk;

import java.util.ArrayList;
import java.util.List;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.cfg.bean.Bean;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.model.msg.config.MessageTypeConfig;
import org.bgerp.util.Log;
import ru.bgcrm.dao.message.MessageType;
import ru.bgcrm.dao.message.MessageTypeCall;
import ru.bgcrm.event.SetupChangedEvent;
import ru.bgcrm.plugin.asterisk.AmiEventListener;

public class AMIManager {
    private static final Log log = Log.getLog();
    private static AMIManager instance;
    static final int CONNECT_TIMEOUT = 300000;
    static final int RECONNECT_TIMEOUT = 60000;
    private List<AmiEventListener> threadList = new ArrayList<AmiEventListener>();

    public AMIManager() {
        if (instance != null) {
            log.warn("Attempt of creation a second singleton instance", new Object[0]);
            return;
        }
        instance = this;
        this.init();
        EventProcessor.subscribe((e, conSet) -> this.init(), SetupChangedEvent.class);
    }

    private void init() {
        log.info("Reinit..", new Object[0]);
        try {
            for (AmiEventListener listener : this.threadList) {
                listener.logoff();
            }
            this.threadList = new ArrayList<AmiEventListener>();
            Setup setup = Setup.getSetup();
            MessageTypeConfig mtConfig = setup.getConfig(MessageTypeConfig.class);
            for (ConfigMap config : setup.subIndexed("asterisk:amiManager.").values()) {
                int messageTypeId = config.getInt("messageTypeId", 0);
                MessageType messageType = (MessageType)mtConfig.getTypeMap().get(messageTypeId);
                if (messageType == null || !(messageType instanceof MessageTypeCall)) {
                    log.error("Incorrect messageTypeId: " + messageTypeId, new Object[0]);
                    continue;
                }
                Class<?> listenerClass = Bean.getClass(config.get("listenerClass", AmiEventListener.class.getName()));
                try {
                    AmiEventListener listener = (AmiEventListener)listenerClass.getConstructor(MessageTypeCall.class, ConfigMap.class).newInstance((MessageTypeCall)messageType, config);
                    this.threadList.add(listener);
                }
                catch (Exception e) {
                    log.error(e);
                }
            }
        }
        catch (Exception e) {
            log.error(e);
        }
    }
}

