/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.model.process.wizard;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.bean.annotation.Bean;
import org.bgerp.cache.ParameterCache;
import org.bgerp.cache.ProcessTypeCache;
import org.bgerp.dao.expression.Expression;
import org.bgerp.dao.expression.ProcessExpressionObject;
import org.bgerp.dao.expression.ProcessParamExpressionObject;
import org.bgerp.dao.expression.UserExpressionObject;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.model.param.Parameter;
import org.bgerp.model.param.ParameterValue;
import org.bgerp.util.Log;
import ru.bgcrm.dao.process.ProcessLinkDAO;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.process.ProcessType;
import ru.bgcrm.model.process.wizard.base.Step;
import ru.bgcrm.model.process.wizard.base.StepData;
import ru.bgcrm.model.process.wizard.base.WizardData;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;

@Bean
public class FillParamsStep
extends Step {
    private static final Log log = Log.getLog();
    private final String type;
    private final Set<Integer> checkParamIds;

    public FillParamsStep(ConfigMap config) {
        super(config);
        this.type = config.get("object");
        this.checkParamIds = Utils.toIntegerSet(config.get("checkParamIds", ""));
    }

    public String getType() {
        return this.type;
    }

    public Set<Integer> getCheckParamIds() {
        return this.checkParamIds;
    }

    public List<Parameter> getParamList() {
        ArrayList<Parameter> paramList = new ArrayList<Parameter>();
        for (int paramId : Utils.toIntegerList(this.config.get("parameterIds"))) {
            Parameter param = ParameterCache.getParameter(paramId);
            if (param == null) {
                log.error("Not found param: " + paramId, new Object[0]);
                continue;
            }
            paramList.add(param);
        }
        return paramList;
    }

    @Override
    public String getJsp() {
        return "/WEB-INF/jspf/user/process/wizard/step_fill_params.jsp";
    }

    public Data data(WizardData data) {
        return new Data(this, data);
    }

    public static class Data
    extends StepData<FillParamsStep> {
        private List<ParameterValue> values;
        private int objectId = -1;

        public Data(FillParamsStep step, WizardData data) {
            super(step, data);
        }

        @Override
        public boolean isFilled(DynActionForm form, Connection connection) throws Exception {
            boolean filled = true;
            this.objectId = this.getObjectId(connection);
            ParamValueDAO paramValueDao = new ParamValueDAO(connection);
            this.values = paramValueDao.loadParameters(((FillParamsStep)this.step).getParamList(), this.objectId, false);
            if (((FillParamsStep)this.step).getCheckParamIds().isEmpty()) {
                ParameterValue pair;
                Iterator<ParameterValue> iterator = this.values.iterator();
                while (iterator.hasNext() && !(filled = (pair = iterator.next()).getValue() != null)) {
                }
            } else {
                for (ParameterValue pair : this.values) {
                    if (!((FillParamsStep)this.step).getCheckParamIds().contains(pair.getParameter().getId()) || pair.getValue() != null) continue;
                    filled = false;
                    break;
                }
            }
            if (!"linkedCustomer".equals(((FillParamsStep)this.step).getType())) {
                Process process = this.data.getProcess();
                ProcessType processType = ProcessTypeCache.getProcessType(process.getTypeId());
                Set<Map.Entry<Integer, ConfigMap>> showParamSet = processType.getProperties().getConfigMap().subIndexed("showParam.").entrySet();
                HashSet<Integer> hideParamIds = new HashSet<Integer>();
                for (Map.Entry<Integer, ConfigMap> entry : showParamSet) {
                    String expression = entry.getValue().get("checkExpression");
                    HashMap<String, Object> context = new HashMap<String, Object>();
                    new UserExpressionObject(this.data.getUser()).toContext(context);
                    new ProcessExpressionObject(process).toContext(context);
                    new ProcessParamExpressionObject(connection, process.getId()).toContext(context);
                    if (!Utils.notBlankString(expression) || new Expression(context).executeCheck(expression)) continue;
                    hideParamIds.add(entry.getKey());
                }
                Iterator<ParameterValue> iterator = this.values.iterator();
                while (iterator.hasNext()) {
                    ParameterValue parameterValuePair = iterator.next();
                    if (!hideParamIds.contains(parameterValuePair.getParameter().getId())) continue;
                    iterator.remove();
                }
            }
            return filled;
        }

        public List<ParameterValue> getValues() {
            return this.values;
        }

        public int getObjectId() {
            return this.objectId;
        }

        private int getObjectId(Connection connection) {
            int objectId = 0;
            objectId = "linkedCustomer".equals(((FillParamsStep)this.step).getType()) ? (this.data.getLinkedCustomer() != null ? this.data.getLinkedCustomer().getId().intValue() : this.getLinkedCustomerId(connection)) : this.data.getProcess().getId();
            return objectId;
        }

        private int getLinkedCustomerId(Connection connection) {
            int customerId = 0;
            ProcessLinkDAO processLinkDAO = new ProcessLinkDAO(connection);
            List<CommonObjectLink> processCustomerlinkList = processLinkDAO.getObjectLinksWithType(this.data.getProcess().getId(), "customer");
            if (processCustomerlinkList.size() > 0) {
                customerId = processCustomerlinkList.get(0).getLinkObjectId();
            }
            return customerId;
        }
    }
}

