/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.pln.grpl.model;

import java.time.Duration;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;

public class ShiftConfig
extends Config {
    private final LocalTime from;
    private final LocalTime to;
    private final Duration duration;

    ShiftConfig(ConfigMap config) {
        super(null);
        config = config.sub("shift.");
        this.from = LocalTime.parse(config.get("from", "09:00"), DateTimeFormatter.ISO_LOCAL_TIME);
        this.to = LocalTime.parse(config.get("to", "18:00"), DateTimeFormatter.ISO_LOCAL_TIME);
        this.duration = Duration.between(this.from, this.to);
    }

    public LocalTime getFrom() {
        return this.from;
    }

    public LocalTime getTo() {
        return this.to;
    }

    public Duration getDuration() {
        return this.duration;
    }
}

