/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.pln.grpl.model;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.NotFoundException;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Setup;
import org.bgerp.dao.expression.Expression;
import org.bgerp.dao.expression.ProcessExpressionObject;
import org.bgerp.dao.expression.ProcessParamExpressionObject;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.model.base.iface.IdTitle;
import org.bgerp.model.param.Parameter;
import org.bgerp.plugin.pln.grpl.model.ColumnsConfig;
import org.bgerp.plugin.pln.grpl.model.ShiftConfig;
import org.bgerp.plugin.pln.grpl.model.Slot;
import org.bgerp.util.Log;
import ru.bgcrm.dao.AddressDAO;
import ru.bgcrm.model.param.ParameterAddressValue;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

public class BoardConfig
extends Config
implements IdTitle<Integer> {
    private static final Log log = Log.getLog();
    private final int id;
    private final String title;
    private final int paramId;
    private final Set<Integer> processTypeIds;
    private final ColumnsConfig columnsConfig;
    private final Map<Integer, org.bgerp.model.base.IdTitle> columns;
    final int columnMapSize;
    private final List<Integer> groupIds;
    private final ShiftConfig shift;
    private final String processDurationExpression;
    private final ConfigMap backgroundColors;

    public BoardConfig(int id, ConfigMap config) {
        super(null);
        this.id = id;
        this.title = config.get("title", "???");
        this.paramId = config.getInt("on.changed.param");
        this.processTypeIds = Collections.unmodifiableSet(Utils.toIntegerSet(config.get("process.types")));
        this.columnsConfig = new ColumnsConfig(config);
        this.columns = this.loadColumns(config);
        this.columnMapSize = this.columns.size() + 2;
        this.groupIds = Utils.toIntegerList(config.get("groups"));
        this.shift = new ShiftConfig(config);
        this.processDurationExpression = config.get("process.duration.expression", "30M");
        this.backgroundColors = config.sub("process.background.color.");
    }

    private Map<Integer, org.bgerp.model.base.IdTitle> loadColumns(ConfigMap config) {
        LinkedHashMap<Integer, org.bgerp.model.base.IdTitle> result = new LinkedHashMap<Integer, org.bgerp.model.base.IdTitle>();
        if (this.columnsConfig.type == ColumnsConfig.Type.CITY) {
            try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
                List<org.bgerp.model.base.IdTitle> cities = new AddressDAO(con).getAddressCities(this.columnsConfig.cityIds);
                for (org.bgerp.model.base.IdTitle city2 : cities) {
                    result.put(city2.getId(), city2);
                }
            }
            catch (SQLException e) {
                log.error(e);
            }
        }
        result.values().stream().forEach(city -> city.setTitle(config.get("column." + city.getId() + ".title", city.getTitle())));
        return Collections.unmodifiableMap(result);
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public int getParamId() {
        return this.paramId;
    }

    public boolean hasProcessType(int id) {
        return this.processTypeIds.isEmpty() || this.processTypeIds.contains(id);
    }

    public Map<Integer, org.bgerp.model.base.IdTitle> getColumns() {
        return this.columns;
    }

    public int getColumnWidth() {
        return 100 / this.columnMapSize;
    }

    public org.bgerp.model.base.IdTitle getColumn(ConnectionSet conSet, Process process) throws SQLException {
        int columnId = 0;
        if (this.columnsConfig.type == ColumnsConfig.Type.CITY) {
            Parameter param = this.columnsConfig.param;
            if (param == null || !"address".equals(param.getType())) {
                log.error("Missing parameter or type not 'address'", new Object[0]);
            } else {
                ParamValueDAO dao = new ParamValueDAO(conSet.getConnection());
                ParameterAddressValue value = Utils.getFirst(dao.getParamAddress((int)process.getId(), (int)param.getId(), true).values());
                if (value != null) {
                    columnId = value.getHouse().getAddressStreet().getCityId();
                }
            }
        }
        return this.columns.get(columnId);
    }

    public org.bgerp.model.base.IdTitle getColumnOrThrow(int id) throws NotFoundException {
        org.bgerp.model.base.IdTitle result = this.columns.get(id);
        if (result == null) {
            throw new NotFoundException("Not found column with ID: " + id);
        }
        return result;
    }

    public List<Integer> getGroupIds() {
        return this.groupIds;
    }

    public ShiftConfig getShift() {
        return this.shift;
    }

    public Duration getProcessDuration(ConnectionSet conSet, Process process) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        new ProcessExpressionObject(process).toContext(context);
        new ProcessParamExpressionObject(conSet.getSlaveConnection(), process.getId()).toContext(context);
        return Duration.parse("PT" + new Expression(context).executeGetString(this.processDurationExpression));
    }

    public List<LocalTime> getTimes(List<Slot> usedSlots, Duration processDuration) {
        ArrayList<LocalTime> times = new ArrayList<LocalTime>();
        LocalTime time = this.shift.getFrom();
        for (Slot slot : usedSlots) {
            while (time.plus(processDuration).compareTo(slot.getTime()) <= 0) {
                times.add(time);
                time = time.plus(processDuration);
            }
            time = slot.getTime().plus(slot.getDuration());
        }
        while (time.plus(processDuration).compareTo(this.shift.getTo()) <= 0) {
            times.add(time);
            time = time.plus(processDuration);
        }
        return times;
    }

    public String getProcessBackgroundColor(int statusId) {
        return this.backgroundColors.getOrDefault(String.valueOf(statusId), "");
    }
}

