/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.pln.blow.action;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.model.msg.Message;
import org.bgerp.plugin.pln.blow.dao.BoardDAO;
import org.bgerp.plugin.pln.blow.model.Board;
import org.bgerp.plugin.pln.blow.model.BoardConfig;
import org.bgerp.plugin.pln.blow.model.BoardsConfig;
import ru.bgcrm.dao.message.MessageDAO;
import ru.bgcrm.dao.process.ProcessLinkDAO;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.model.Pair;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/user/plugin/blow/board")
public class BoardAction
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/user/plugin/blow/board";

    public ActionForward board(DynActionForm form, ConnectionSet conSet) throws Exception {
        BoardsConfig boardsConf = this.setup.getConfig(BoardsConfig.class);
        form.setResponseData("boards", boardsConf.getBoards(form.getUser()));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/blow/board/board.jsp");
    }

    public ActionForward show(DynActionForm form, Connection con) throws Exception {
        BoardConfig boardConf = this.setup.getConfig(BoardsConfig.class).getBoard(form.getId());
        if (boardConf != null) {
            List<Pair<Process, Map<String, Object>>> processes = new BoardDAO(con, form).getProcessList(boardConf);
            Set<Integer> processIds = processes.stream().map(Pair::getFirst).map(p -> p.getId()).collect(Collectors.toSet());
            Collection<CommonObjectLink> links = new ProcessLinkDAO(con, form).getLinksOver(processIds);
            Board board = new Board(boardConf, processes, links);
            form.setResponseData("board", board);
            form.setResponseData("processIds", processIds);
            this.updatePersonalization(form, con, map -> map.put("blowBoardLastSelected", String.valueOf(form.getId())));
        }
        return this.html(con, form, "/WEB-INF/jspf/user/plugin/blow/board/show.jsp");
    }

    public ActionForward move(DynActionForm form, Connection con) throws Exception {
        int processId = form.getParamInt("processId");
        int parentProcessId = form.getParamInt("parentProcessId");
        int fromParentProcessId = form.getParamInt("fromParentProcessId");
        ProcessLinkDAO linkDao = new ProcessLinkDAO(con, form);
        if (fromParentProcessId > 0) {
            linkDao.deleteLink(new CommonObjectLink(fromParentProcessId, "processMade", processId, ""));
        }
        if (parentProcessId > 0) {
            linkDao.addLink(new CommonObjectLink(parentProcessId, "processMade", processId, ""));
            if (linkDao.checkCycles(parentProcessId)) {
                throw new BGMessageException(this.l.l("\u0426\u0438\u043a\u043b\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u044c", new Object[0]), new Object[0]);
            }
        }
        return this.json(con, form);
    }

    public ActionForward search(DynActionForm form, ConnectionSet conSet) throws Exception {
        MessageDAO dao = new MessageDAO(conSet.getSlaveConnection(), form);
        String filter = form.getParam("filter");
        LinkedHashMap<Integer, SearchItem> result = new LinkedHashMap<Integer, SearchItem>();
        for (Message m : dao.getProcessMessageList(form.getParamValues("processId"), filter)) {
            int processId = m.getProcessId();
            result.computeIfAbsent(processId, key -> new SearchItem(processId, m.getProcess().getDescription())).addHit(m, filter);
        }
        form.setResponseData("list", result.values().stream().sorted((i1, i2) -> i2.getHits().size() - i1.getHits().size()).collect(Collectors.toList()));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/blow/board/search.jsp");
    }

    public static class SearchItem {
        private final int processId;
        private final String processDescription;
        private final List<String> hits = new ArrayList<String>();

        private SearchItem(int processId, String processDescription) {
            this.processId = processId;
            this.processDescription = processDescription;
        }

        private void addHit(Message message, String filter) {
            this.hits.add(message.getText());
        }

        public int getProcessId() {
            return this.processId;
        }

        public String getProcessDescription() {
            return this.processDescription;
        }

        public List<String> getHits() {
            return this.hits;
        }
    }
}

