/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.msg.email.config;

import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.cache.ParameterCache;
import org.bgerp.model.param.Parameter;
import org.bgerp.util.Log;

public class ProcessNotificationConfig
extends Config {
    private static final Log log = Log.getLog();
    private final int userEmailParamId;

    protected ProcessNotificationConfig(ConfigMap config) throws Config.InitStopException {
        super(null);
        config = config.sub("email:");
        this.userEmailParamId = this.loadEmailParamId(config);
        this.initWhen(this.userEmailParamId > 0);
    }

    private int loadEmailParamId(ConfigMap config) {
        Parameter param;
        int result = config.getInt("change.notification.user.email.param", -1);
        if (result == 0 && (param = (Parameter)ParameterCache.getObjectTypeParameterList("user").stream().filter(p -> "email".equals(p.getType())).findFirst().orElse(null)) != null) {
            result = param.getId();
        }
        log.debug("User 'email' parameter: {}", this.userEmailParamId);
        return result;
    }

    public int userEmailParamId() {
        return this.userEmailParamId;
    }
}

