/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.clb.team.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ru.bgcrm.model.Pair;

public class PartyBalance {
    private final Map<Key, BigDecimal> matrix;

    public PartyBalance(List<Pair<Integer, BigDecimal>> paymentAmounts) {
        int cnt = paymentAmounts.size();
        if (cnt == 0) {
            this.matrix = Collections.emptyMap();
            return;
        }
        this.matrix = new HashMap<Key, BigDecimal>(cnt * cnt);
        List amounts = paymentAmounts.stream().map(Pair::getSecond).collect(Collectors.toList());
        BigDecimal sum = amounts.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal avg = sum.divide(new BigDecimal(cnt), RoundingMode.HALF_UP);
        List<BigDecimal> deltas = amounts.stream().map(amount -> avg.subtract((BigDecimal)amount)).collect(Collectors.toList());
        for (int i1 = 0; i1 < cnt - 1; ++i1) {
            for (int i2 = i1 + 1; i2 < cnt; ++i2) {
                int id1 = paymentAmounts.get(i1).getFirst();
                BigDecimal delta1 = (BigDecimal)deltas.get(i1);
                int id2 = paymentAmounts.get(i2).getFirst();
                BigDecimal delta2 = (BigDecimal)deltas.get(i2);
                if (delta1.compareTo(BigDecimal.ZERO) == 0 || delta2.compareTo(BigDecimal.ZERO) == 0 || delta1.multiply(delta2).compareTo(BigDecimal.ZERO) > 0 || this.transition(deltas, i1, id1, delta1, i2, id2, delta2)) continue;
                this.transition(deltas, i2, id2, delta2, i1, id1, delta1);
            }
        }
    }

    public BigDecimal get(int fromId, int toId) {
        return this.matrix.get(new Key(fromId, toId));
    }

    private boolean transition(List<BigDecimal> deltas, int indexFrom, int idFrom, BigDecimal deltaFrom, int indexTo, int idTo, BigDecimal deltaTo) {
        if (deltaFrom.compareTo(BigDecimal.ZERO) < 0) {
            return false;
        }
        BigDecimal amount = deltaFrom.abs().min(deltaTo.abs());
        deltas.set(indexFrom, deltaFrom.subtract(amount));
        deltas.set(indexTo, deltaTo.add(amount));
        this.matrix.put(new Key(idFrom, idTo), amount);
        return true;
    }

    private static class Key {
        private final int fromId;
        private final int toId;

        Key(int fromId, int toId) {
            this.fromId = fromId;
            this.toId = toId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.fromId;
            result = 31 * result + this.toId;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.fromId != other.fromId) {
                return false;
            }
            return this.toId == other.toId;
        }
    }
}

