/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.bil.subscription.dao;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.plugin.bil.subscription.Config;
import org.bgerp.plugin.bil.subscription.model.Subscription;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.util.Utils;

public class SubscriptionDAO
extends CommonDAO {
    public SubscriptionDAO(Connection con) {
        super(con);
    }

    public BigDecimal getCost(Subscription subscription, int limitId, Collection<Integer> productProcessIds) throws SQLException {
        BigDecimal result = BigDecimal.ZERO;
        String query = "SELECT SUM(count) FROM  param_listcount  WHERE param_id=? AND value=? AND id IN (" + Utils.toString(productProcessIds, "-1", ",") + ")";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, subscription.getParamLimitPriceId());
            ps.setInt(2, limitId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = result.add(Utils.maskNullDecimal(rs.getBigDecimal(1)));
            }
        }
        return result;
    }

    public BigDecimal getCost(Config config, Subscription subscription, int subscriptionProcessId) throws SQLException, BGMessageException {
        BigDecimal service;
        BigDecimal discount;
        ParamValueDAO paramValueDAO = new ParamValueDAO(this.con);
        Integer limitId = Utils.getFirst(paramValueDAO.getParamList(subscriptionProcessId, config.getParamLimitId()));
        if (limitId == null) {
            throw new BGException("Undefined limit value", new Object[0]);
        }
        BigDecimal result = BigDecimal.ZERO;
        PreparedQuery pq = new PreparedQuery(this.con, "SELECT SUM(param_price.count) FROM  param_listcount AS param_price");
        this.addProductsJoin(pq, config, "param_price", subscriptionProcessId);
        pq.addQuery(" WHERE param_price.param_id=? AND param_price.value=?");
        pq.addInt(subscription.getParamLimitPriceId());
        pq.addInt(limitId);
        try (ResultSet rs = pq.executeQuery();){
            if (rs.next()) {
                result = result.add(Utils.maskNullDecimal(rs.getBigDecimal(1)));
            }
        }
        if (config.getParamDiscountId() > 0 && (discount = paramValueDAO.getParamMoney(subscriptionProcessId, config.getParamDiscountId())) != null) {
            if (discount.compareTo(result) > 0) {
                throw new BGMessageException("Discount can't be more than product's cost: {}", discount.toPlainString());
            }
            result = result.subtract(discount);
        }
        if (config.getParamServiceCostId() > 0 && (service = paramValueDAO.getParamMoney(subscriptionProcessId, config.getParamServiceCostId())) != null) {
            result = result.add(service);
        }
        return result;
    }

    public List<String> getProducts(Config config, int subscriptionProcessId) throws SQLException {
        ArrayList<String> result = new ArrayList<String>(50);
        String query = "SELECT param_product.value FROM  param_text AS param_product INNER JOIN  process_link AS pl ON param_product.id=pl.process_id AND pl.object_id=? AND pl.object_type=? WHERE param_product.param_id=? ORDER BY value";
        try (PreparedQuery pq = new PreparedQuery(this.con, query);){
            pq.addInt(subscriptionProcessId);
            pq.addString("processDepend");
            pq.addInt(config.getParamProductId());
            ResultSet rs = pq.executeQuery();
            while (rs.next()) {
                result.add(rs.getString(1));
            }
        }
        return result;
    }

    private void addProductsJoin(PreparedQuery pq, Config config, String table, int subscriptionProcessId) throws SQLException {
        pq.addQuery(" INNER JOIN  process_link AS pl ON " + table + ".id=pl.process_id AND pl.object_id=? AND pl.object_type=? INNER JOIN  param_text AS param_product_id ON pl.process_id=param_product_id.id AND param_product_id.param_id=?");
        pq.addInt(subscriptionProcessId);
        pq.addString("processDepend");
        pq.addInt(config.getParamProductId());
    }
}

