/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.bil.invoice.event.listener;

import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.l10n.Localizer;
import org.bgerp.app.servlet.util.ServletResponseInterceptor;
import org.bgerp.event.ProcessFileGetEvent;
import org.bgerp.event.ProcessFilesEvent;
import org.bgerp.model.Pageable;
import org.bgerp.model.base.IdStringTitle;
import org.bgerp.plugin.bil.invoice.Plugin;
import org.bgerp.plugin.bil.invoice.action.InvoiceAction;
import org.bgerp.plugin.bil.invoice.dao.InvoiceSearchDAO;
import org.bgerp.plugin.bil.invoice.model.Invoice;
import org.bgerp.plugin.bil.invoice.model.InvoiceType;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;

public class FilesListener {
    private static final String PREFIX = "invoice:";

    public FilesListener() {
        EventProcessor.subscribe((e, conSet) -> {
            Pageable<Invoice> result = new Pageable<Invoice>();
            new InvoiceSearchDAO(conSet.getSlaveConnection()).withProcessId(e.getProcessId()).withPaid(false).orderDefault().search(result);
            Localizer l = Plugin.INSTANCE.getLocalizer();
            for (Invoice invoice : result.getList()) {
                e.addAnnouncedFile(new IdStringTitle(PREFIX + invoice.getId(), l.l("\u0421\u0447\u0451\u0442", new Object[0]) + " " + invoice.getNumber()));
            }
        }, ProcessFilesEvent.class);
        EventProcessor.subscribe((e, conSet) -> {
            if (!e.getFileId().startsWith(PREFIX)) {
                return;
            }
            int id = Utils.parseInt(e.getFileId().substring(PREFIX.length()));
            DynActionForm form = e.getForm();
            InvoiceType type = InvoiceAction.doc(conSet, form, id);
            Invoice invoice = (Invoice)form.getResponse().getData().get("invoice");
            byte[] data = ServletResponseInterceptor.jsp(form, type.getJsp(), 50000);
            e.setFile(invoice.getNumber() + ".html", data);
        }, ProcessFileGetEvent.class);
    }
}

