/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.model.param;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.commons.io.IOUtils;
import org.bgerp.dao.FileDataDAO;
import org.bgerp.model.file.FileData;
import org.bgerp.model.param.Parameter;
import ru.bgcrm.model.param.ParameterAddressValue;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public class ParameterValue {
    private final Parameter parameter;
    private Object value;
    private String valueTitle;

    public ParameterValue(Parameter parameter) {
        this.parameter = parameter;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getValueTitle() {
        String result = this.valueTitle;
        if (result == null && this.value != null) {
            String type = this.parameter.getType();
            if ("address".equals(type)) {
                StringBuilder address = new StringBuilder();
                for (ParameterAddressValue item : ((Map)this.value).values()) {
                    Utils.addSeparated(address, "; ", item.getValue());
                }
                result = address.toString();
            } else if ("date".equals(type)) {
                result = TimeUtils.format((Date)this.value, "ymd");
            } else if ("datetime".equals(type)) {
                result = TimeUtils.format((Date)this.value, "ymdhms");
            } else if ("email".equals(type)) {
                result = Parameter.Type.emailToString(((SortedMap)this.value).values());
            } else if ("list".equals(type)) {
                result = Parameter.Type.listToString(this.parameter.getId(), (Map)this.value);
            } else if ("listcount".equals(type)) {
                result = Parameter.Type.listCountToString(this.parameter.getId(), (Map)this.value);
            } else if ("tree".equals(type)) {
                result = Parameter.Type.treeToString(this.parameter.getId(), (Set)this.value);
            } else if ("treecount".equals(type)) {
                result = Parameter.Type.treeCountToString(this.parameter.getId(), (Map)this.value);
            } else {
                int pos;
                result = String.valueOf(this.value);
                if ("text".equals(type) && "hideProtocol".equals(this.parameter.getShowAsLink()) && (pos = result.indexOf("//")) > 0) {
                    result = result.substring(pos + 2);
                }
            }
        }
        return result;
    }

    public String getBase64EncodedImgSrc() throws Exception {
        if (this.value == null) {
            return null;
        }
        if (!"file".equals(this.parameter.getType())) {
            throw new IllegalArgumentException("Attempt to get");
        }
        FileData fileData = (FileData)Utils.getFirst(((Map)this.value).values());
        if (fileData == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(100000).append("data:").append(URLConnection.guessContentTypeFromName(fileData.getTitle())).append(";base64, ");
        try (FileInputStream fis = new FileInputStream(new FileDataDAO(null).getFile(fileData));){
            byte[] data = IOUtils.toByteArray((InputStream)fis);
            result.append(Base64.getEncoder().encodeToString(data));
        }
        return result.toString();
    }
}

