/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.dao.param;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.bgerp.cache.ParameterCache;
import org.bgerp.model.Pageable;
import org.bgerp.model.param.Parameter;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.param.ParameterLogItem;
import ru.bgcrm.util.Utils;

public class ParamLogDAO
extends CommonDAO {
    public ParamLogDAO(Connection con) {
        super(con);
    }

    public void insertParamLog(int id, int paramId, int userId, String text) throws SQLException {
        String loggedText;
        String query = "SELECT text FROM  param_log  WHERE object_id=? AND param_id=? ORDER BY dt DESC LIMIT 1";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ps.setInt(2, paramId);
        ResultSet rs = ps.executeQuery();
        if (rs.next() && text.equals(loggedText = rs.getString("text"))) {
            ps.close();
            return;
        }
        ps.close();
        query = "INSERT INTO param_log (dt, object_id, user_id, param_id, text) VALUES (CURRENT_TIMESTAMP(4),?,?,?,?)";
        ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ps.setInt(2, userId);
        ps.setInt(3, paramId);
        ps.setString(4, text);
        ps.executeUpdate();
        ps.close();
    }

    public List<ParameterLogItem> getHistory(int id, List<Parameter> params, boolean offEncryption, Pageable<ParameterLogItem> result) throws SQLException {
        try (PreparedQuery pq = new PreparedQuery(this.con);){
            Page page = result.getPage();
            pq.addQuery("SELECT SQL_CALC_FOUND_ROWS  dt, object_id, user_id, param_id, text FROM  param_log ");
            pq.addQuery(" WHERE object_id= ? AND param_id IN ( " + Utils.getObjectIds(params) + " ) ");
            pq.addInt(id);
            pq.addQuery(" ORDER BY dt DESC ");
            pq.addQuery(page.getLimitSql());
            List<ParameterLogItem> list = result.getList();
            ResultSet rs = pq.executeQuery();
            while (rs.next()) {
                list.add(this.getFromRs(rs, offEncryption));
            }
            page.setRecordCount(pq.getPrepared());
            List<ParameterLogItem> list2 = list;
            return list2;
        }
    }

    public ParameterLogItem getLastParamChange(int objectId, int paramId) throws SQLException {
        ParameterLogItem result = null;
        String query = "SELECT * FROM  param_log WHERE object_id=? AND param_id=? ORDER BY dt DESC LIMIT 1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, objectId);
            ps.setInt(2, paramId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getLogItemFromRs(rs);
            }
            ps.close();
        }
        return result;
    }

    private ParameterLogItem getFromRs(ResultSet rs, boolean offEncryption) throws SQLException {
        int paramId = rs.getInt("param_id");
        Parameter param = ParameterCache.getParameter(paramId);
        String text = rs.getString("text");
        if ("encrypted".equals(param.getConfigMap().get("encrypt")) && !offEncryption) {
            text = "<ENCRYPTED>";
        }
        return new ParameterLogItem(rs.getTimestamp("dt"), rs.getInt("object_id"), rs.getInt("user_id"), paramId, text);
    }

    private ParameterLogItem getLogItemFromRs(ResultSet rs) throws SQLException {
        return this.getFromRs(rs, false);
    }
}

