/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.servlet.jsp;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.l10n.Localizer;
import org.bgerp.app.servlet.jsp.UtilFunction;
import org.bgerp.model.base.iface.Comment;
import org.bgerp.model.base.iface.Id;
import org.bgerp.model.base.iface.IdTitle;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public class UiFunction {
    public static final UiFunction INSTANCE = new UiFunction();

    public static final String selectSingleSourceJson(Collection<IdTitle<?>> list, Set<?> availableIdSet, List<?> availableIdList, Map<Integer, IdTitle<?>> map, boolean showId, boolean showComment) throws JsonProcessingException {
        List result = null;
        Function<IdTitle, Map> itemMap = item -> {
            Object title = item.getTitle();
            if (showId) {
                title = (String)title + " (" + String.valueOf(item.getId()) + ")";
            }
            if (showComment) {
                title = (String)title + " (" + UtilFunction.quotEscape(((Comment)((Object)item)).getComment()) + ")";
            }
            return Map.of("id", String.valueOf(item.getId()), "value", title);
        };
        Predicate<IdTitle> filterAvailableIdSet = item -> {
            if (CollectionUtils.isEmpty((Collection)availableIdSet)) {
                return true;
            }
            return availableIdSet.contains(item.getId());
        };
        result = CollectionUtils.isEmpty(availableIdList) ? list.stream().filter(filterAvailableIdSet).map(itemMap).collect(Collectors.toList()) : availableIdList.stream().map(id -> (IdTitle)map.get(id)).filter(item -> item != null).map(itemMap).collect(Collectors.toList());
        return BaseAction.MAPPER.writeValueAsString(result);
    }

    public static final String processCreatedAndClosed(Localizer l, Process process) {
        StringBuilder result = new StringBuilder(100).append(l.l("Created", new Object[0])).append(": ").append(TimeUtils.format(process.getCreateTime(), "ymdhms"));
        if (process.getCloseTime() != null) {
            result.append(" ").append(l.l("Closed", new Object[0])).append(": ").append(TimeUtils.format(process.getCloseTime(), "ymdhms"));
        }
        return result.toString();
    }

    public static final String idAndComment(Object object) {
        Id id;
        Comment comment;
        StringBuilder result = new StringBuilder(100);
        if (object instanceof Comment && Utils.notBlankString((comment = (Comment)object).getComment())) {
            result.append(Utils.escapeXml(comment.getComment()));
        }
        if (object instanceof Id) {
            id = (Id)object;
            if (!result.isEmpty()) {
                result.append(" ");
            }
        } else {
            throw new BGException("Class {} doesn't implement interface Id", object.getClass());
        }
        result.append("ID: ").append(id.getId());
        return result.toString();
    }
}

