/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.cfg;

import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.bgerp.app.cfg.Preferences;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.util.Log;
import org.bgerp.util.sql.pool.ConnectionPool;
import ru.bgcrm.dao.ConfigDAO;
import ru.bgcrm.event.SetupChangedEvent;
import ru.bgcrm.model.Config;
import ru.bgcrm.util.Utils;

public class Setup
extends Preferences {
    private static final Log log = Log.getLog();
    private static volatile Setup instance;
    private static volatile ConnectionPool connectionPoolInit;
    private String bundleName;
    private ConnectionPool connectionPool;

    public static String getBundleName() {
        return Utils.getSystemProperty("setup.data", "bgerp");
    }

    public static Setup getSetup() {
        return Setup.getSetup(true);
    }

    private static Setup getSetup(boolean initConfig) {
        if (instance == null) {
            instance = connectionPoolInit == null ? new Setup(initConfig) : new Setup(connectionPoolInit);
        }
        return instance;
    }

    @VisibleForTesting
    public static void resetSetup(ConnectionPool pool) {
        instance = null;
        connectionPoolInit = pool;
    }

    public Setup(boolean initConfigAndPool) {
        this.bundleName = Setup.getBundleName();
        this.loadBundle(this.bundleName, this.data, false);
        if (initConfigAndPool) {
            this.connectionPool = new ConnectionPool("bgerp", this);
            this.loadConfigMap(this.data);
            this.loadBundle(this.bundleName, this.data, false);
            this.setSystemProperties("format.ymd", "format.ymdh", "format.ymdhm", "format.ymdhms");
            EventProcessor.subscribe((e, conSet) -> this.reloadConfig(conSet.getConnection()), SetupChangedEvent.class);
        }
    }

    private Setup(ConnectionPool pool) {
        this.connectionPool = pool;
        this.loadConfigMap(this.data);
        EventProcessor.subscribe((e, conSet) -> this.reloadConfig(conSet.getConnection()), SetupChangedEvent.class);
    }

    private void setSystemProperties(String ... keys) {
        for (String key : keys) {
            String value = this.get(key);
            if (Utils.isBlankString(value)) continue;
            System.setProperty("bgerp." + key, value);
        }
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public Connection getDBConnectionFromPool() {
        return this.connectionPool.getDBConnectionFromPool();
    }

    public Connection getDBSlaveConnectionFromPool() {
        return this.connectionPool.getDBSlaveConnectionFromPool();
    }

    private void reloadConfig(Connection con) {
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            this.loadConfigMap(data, con);
            if (Utils.notBlankString(this.bundleName)) {
                this.loadBundle(this.bundleName, data, false);
            }
            for (Map.Entry me : data.entrySet()) {
                this.data.put((String)me.getKey(), (String)me.getValue());
            }
            ((ConcurrentHashMap.CollectionView)((Object)this.data.keySet())).retainAll(data.keySet());
            this.clearConfigs();
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    private void loadConfigMap(Map<String, String> data) {
        try (Connection con = this.getDBConnectionFromPool();){
            this.loadConfigMap(data, con);
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    private void loadConfigMap(Map<String, String> data, Connection con) throws Exception {
        ConfigDAO configDAO = new ConfigDAO(con);
        Config config = configDAO.getActiveGlobalConfig();
        if (config == null) {
            log.error("Active config not found!", new Object[0]);
            return;
        }
        Map<Integer, String> includes = configDAO.getIncludes(config.getId());
        this.oldIncludes(con, includes, config);
        data.putAll(new Preferences(config.getData(), includes.values(), false));
    }

    private void oldIncludes(Connection con, Map<Integer, String> includes, Config config) throws SQLException {
        ConfigDAO configDAO = new ConfigDAO(con);
        for (Map.Entry<String, String> me : new Preferences(config.getData()).sub("include.").entrySet()) {
            int includedId = Utils.parseInt(me.getKey());
            log.warn("Used old-style included config {} in config {}", includedId, config.getId());
            if (includes.containsKey(includedId)) continue;
            Config included = configDAO.getGlobalConfig(includedId);
            if (included == null) {
                log.warn("Not found included config {} in config {}", includedId, config.getId());
                continue;
            }
            included.setParentId(config.getId());
            configDAO.updateGlobalConfig(included);
            con.commit();
            includes.put(included.getId(), included.getData());
        }
    }

    @Deprecated
    public DataSource getDataSource() {
        return this.connectionPool.getDataSource();
    }

    @Deprecated
    public DataSource getSlaveDataSource() {
        return this.connectionPool.getSlaveDataSource();
    }
}

