/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.domain.chart;

import ar.com.fdvs.dj.domain.DJBaseElement;
import ar.com.fdvs.dj.domain.DJHyperLink;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.chart.DJChartOptions;
import ar.com.fdvs.dj.domain.chart.dataset.AbstractDataset;
import ar.com.fdvs.dj.domain.chart.dataset.CategoryDataset;
import ar.com.fdvs.dj.domain.chart.dataset.PieDataset;
import ar.com.fdvs.dj.domain.chart.dataset.TimeSeriesDataset;
import ar.com.fdvs.dj.domain.chart.dataset.XYDataset;
import ar.com.fdvs.dj.domain.chart.plot.AbstractPlot;
import ar.com.fdvs.dj.domain.chart.plot.AreaPlot;
import ar.com.fdvs.dj.domain.chart.plot.Bar3DPlot;
import ar.com.fdvs.dj.domain.chart.plot.BarPlot;
import ar.com.fdvs.dj.domain.chart.plot.LinePlot;
import ar.com.fdvs.dj.domain.chart.plot.Pie3DPlot;
import ar.com.fdvs.dj.domain.chart.plot.PiePlot;
import ar.com.fdvs.dj.domain.chart.plot.ScatterPlot;
import ar.com.fdvs.dj.domain.chart.plot.TimeSeriesPlot;
import java.util.Map;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignChartDataset;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;

public class DJChart
extends DJBaseElement {
    private static final long serialVersionUID = 10000L;
    public static final byte CALCULATION_COUNT = CalculationEnum.COUNT.getValue();
    public static final byte CALCULATION_SUM = CalculationEnum.SUM.getValue();
    public static final byte AREA_CHART = 1;
    public static final byte STACKEDAREA_CHART = 20;
    public static final byte BAR_CHART = 3;
    public static final byte BAR3D_CHART = 2;
    public static final byte STACKEDBAR_CHART = 12;
    public static final byte STACKEDBAR3D_CHART = 11;
    public static final byte LINE_CHART = 7;
    public static final byte PIE_CHART = 9;
    public static final byte PIE3D_CHART = 8;
    public static final byte TIMESERIES_CHART = 16;
    public static final byte XYAREA_CHART = 13;
    public static final byte XYBAR_CHART = 14;
    public static final byte XYLINE_CHART = 15;
    public static final byte SCATTER_CHART = 10;
    private byte chartType;
    private AbstractDataset dataset;
    private AbstractPlot plot;
    private byte operation = CalculationEnum.SUM.getValue();
    private DJChartOptions chartOptions = new DJChartOptions();
    private DJHyperLink link;

    public DJChart(byte chartType) {
        this.setChartType(chartType);
    }

    private void setChartType(byte chartType) {
        this.chartType = chartType;
        switch (chartType) {
            case 1: 
            case 20: {
                this.dataset = new CategoryDataset();
                this.plot = new AreaPlot();
                break;
            }
            case 3: 
            case 12: {
                this.dataset = new CategoryDataset();
                this.plot = new BarPlot();
                break;
            }
            case 2: 
            case 11: {
                this.dataset = new CategoryDataset();
                this.plot = new Bar3DPlot();
                break;
            }
            case 7: {
                this.dataset = new CategoryDataset();
                this.plot = new LinePlot();
                break;
            }
            case 9: {
                this.dataset = new PieDataset();
                this.plot = new PiePlot();
                break;
            }
            case 8: {
                this.dataset = new PieDataset();
                this.plot = new Pie3DPlot();
                break;
            }
            case 16: {
                this.dataset = new TimeSeriesDataset();
                this.plot = new TimeSeriesPlot();
                break;
            }
            case 13: {
                this.dataset = new XYDataset();
                this.plot = new AreaPlot();
                break;
            }
            case 14: {
                this.dataset = new XYDataset();
                this.plot = new BarPlot();
                break;
            }
            case 15: {
                this.dataset = new XYDataset();
                this.plot = new LinePlot();
                break;
            }
            case 10: {
                this.dataset = new XYDataset();
                this.plot = new ScatterPlot();
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type not supported.");
            }
        }
    }

    public void setOperation(byte operation) {
        this.operation = operation;
    }

    public byte getOperation() {
        return this.operation;
    }

    public void setOptions(DJChartOptions chartOptions) {
        this.chartOptions = chartOptions;
    }

    public DJChartOptions getOptions() {
        return this.chartOptions;
    }

    public AbstractDataset getDataset() {
        return this.dataset;
    }

    public AbstractPlot getPlot() {
        return this.plot;
    }

    public DJHyperLink getLink() {
        return this.link;
    }

    public void setLink(DJHyperLink link) {
        this.link = link;
    }

    public JRDesignChart transform(DynamicJasperDesign design, String name, JRDesignGroup group, JRDesignGroup parentGroup, Map vars, int width) {
        JRDesignChart chart = new JRDesignChart((JRDefaultStyleProvider)design, this.chartType);
        JRDesignChartDataset chartDataset = this.dataset.transform(design, name, group, parentGroup, vars);
        chart.setDataset((JRChartDataset)chartDataset);
        this.plot.transform(design, chart.getPlot(), name);
        this.getOptions().transform(design, name, chart, width);
        if (group.equals(parentGroup)) {
            chart.setEvaluationTime(EvaluationTimeEnum.REPORT);
        } else {
            chart.setEvaluationTime(EvaluationTimeEnum.GROUP);
            chart.setEvaluationGroup((JRGroup)parentGroup);
        }
        return chart;
    }
}

