/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.JsonExporter;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleHtmlExporterConfiguration;
import net.sf.jasperreports.export.SimpleHtmlExporterOutput;
import net.sf.jasperreports.export.SimpleHtmlReportConfiguration;
import net.sf.jasperreports.export.SimpleJsonExporterOutput;
import net.sf.jasperreports.web.WebReportContext;
import net.sf.jasperreports.web.servlets.AbstractServlet;
import net.sf.jasperreports.web.servlets.JasperPrintAccessor;
import net.sf.jasperreports.web.servlets.ReportExecutionStatus;
import net.sf.jasperreports.web.servlets.ReportPageStatus;
import net.sf.jasperreports.web.util.JacksonUtil;
import net.sf.jasperreports.web.util.ReportExecutionHyperlinkProducerFactory;
import net.sf.jasperreports.web.util.VelocityUtil;
import net.sf.jasperreports.web.util.WebHtmlResourceHandler;
import net.sf.jasperreports.web.util.WebUtil;

public class ReportOutputServlet
extends AbstractServlet {
    private static final long serialVersionUID = 10200L;
    private static final String TEMPLATE_HEADER = "net/sf/jasperreports/web/servlets/resources/templates/HeaderTemplate.vm";
    private static final String TEMPLATE_BETWEEN_PAGES = "net/sf/jasperreports/web/servlets/resources/templates/BetweenPagesTemplate.vm";
    private static final String TEMPLATE_FOOTER = "net/sf/jasperreports/web/servlets/resources/templates/FooterTemplate.vm";
    private static final String TEMPLATE_HEADER_NOPAGES = "net/sf/jasperreports/web/servlets/resources/templates/HeaderTemplateNoPages.vm";
    private static final String TEMPLATE_FOOTER_NOPAGES = "net/sf/jasperreports/web/servlets/resources/templates/FooterTemplateNoPages.vm";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.setNoExpire(response);
        String contextId = request.getParameter("jr_ctxid");
        if (contextId != null && request.getHeader("accept").indexOf("text/html") >= 0) {
            WebReportContext webReportContext = WebReportContext.getInstance(request, false);
            if (webReportContext == null) {
                response.setContentType("application/json; charset=UTF-8");
                response.setStatus(404);
                response.getWriter().println("{\"msg\": \"Resource with id '" + contextId + "' not found!\"}");
                return;
            }
            response.setContentType("text/html; charset=UTF-8");
            PrintWriter out = response.getWriter();
            try {
                this.render(request, response, webReportContext, out);
                return;
            }
            catch (JRException e) {
                response.setContentType("application/json; charset=UTF-8");
                response.setStatus(404);
                response.getWriter().println("{\"msg\": \"JasperReports encountered an error!\"}");
                return;
            }
            catch (Exception e) {
                response.setContentType("application/json; charset=UTF-8");
                response.setStatus(404);
                out.println("{\"msg\": \"JasperReports encountered an error on report rendering!\"");
                String message = e.getMessage();
                if (message == null && e.getCause() != null) {
                    message = e.getCause().getMessage();
                }
                if (message == null) {
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    message = sw.toString();
                }
                if (message != null) {
                    out.println(", \"devmsg\": \"" + JRStringUtil.escapeJavaStringLiteral(message) + "\"");
                }
                out.println("}");
                return;
            }
        }
        response.setContentType("application/json; charset=UTF-8");
        response.setStatus(400);
        response.getWriter().println("{\"msg\": \"Wrong parameters!\"}");
    }

    public void render(HttpServletRequest request, HttpServletResponse response, WebReportContext webReportContext, PrintWriter writer) throws JRException {
        ReportPageStatus pageStatus;
        JasperPrintAccessor jasperPrintAccessor = (JasperPrintAccessor)webReportContext.getParameterValue("net.sf.jasperreports.web.jasper_print.accessor");
        ReportExecutionStatus reportStatus = jasperPrintAccessor.getReportStatus();
        if (reportStatus.getStatus() == ReportExecutionStatus.Status.ERROR) {
            throw new JRRuntimeException("web.servlets.report.generation.error", null, reportStatus.getError());
        }
        boolean hasPages = jasperPrintAccessor.pageStatus(0, null).pageExists();
        HtmlExporter exporter = new HtmlExporter(this.getJasperReportsContext());
        SimpleHtmlExporterConfiguration exporterConfig = new SimpleHtmlExporterConfiguration();
        SimpleHtmlReportConfiguration reportConfig = new SimpleHtmlReportConfiguration();
        if (hasPages) {
            String pageTimestamp;
            Long timestamp;
            String reportPage = request.getParameter("jr_page");
            int pageIdx = reportPage == null ? 0 : Integer.parseInt(reportPage);
            pageStatus = jasperPrintAccessor.pageStatus(pageIdx, timestamp = (pageTimestamp = request.getParameter("jr_page_timestamp")) == null ? null : Long.valueOf(pageTimestamp));
            if (!pageStatus.pageExists()) {
                throw new JRRuntimeException("web.servlets.page.not.found", new Object[]{pageIdx});
            }
            reportConfig.setPageIndex(pageIdx);
        } else {
            pageStatus = ReportPageStatus.PAGE_FINAL;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        WebUtil webUtil = WebUtil.getInstance(this.getJasperReportsContext());
        boolean isComponentMetadataEmbedded = webUtil.isComponentMetadataEmbedded();
        result.put("reportStatus", reportStatus.getStatus().toString().toLowerCase());
        result.put("totalPages", reportStatus.getTotalPageCount());
        result.put("partialPageCount", reportStatus.getCurrentPageCount());
        result.put("pageFinal", pageStatus.isPageFinal());
        result.put("isComponentMetadataEmbedded", isComponentMetadataEmbedded);
        if (!pageStatus.isPageFinal()) {
            result.put("pageTimestamp", String.valueOf(pageStatus.getTimestamp()));
        }
        response.setHeader("jasperreports-report-status", JacksonUtil.getInstance(this.getJasperReportsContext()).getJsonString(result));
        exporter.setReportContext(webReportContext);
        exporter.setExporterInput(new SimpleExporterInput(jasperPrintAccessor.getJasperPrint()));
        SimpleHtmlExporterOutput htmlOutput = new SimpleHtmlExporterOutput(writer);
        String applicationDomain = (String)webReportContext.getParameterValue("jr_app_domain");
        if (applicationDomain == null) {
            applicationDomain = request.getContextPath();
        }
        String resourcesPath = applicationDomain + webUtil.getResourcesPath() + "?" + "jr_ctxid" + "=" + webReportContext.getId();
        htmlOutput.setImageHandler(new WebHtmlResourceHandler(resourcesPath + "&image={0}"));
        htmlOutput.setResourceHandler(new WebHtmlResourceHandler(resourcesPath + "/{0}"));
        exporter.setExporterOutput(htmlOutput);
        exporterConfig.setHtmlHeader(this.getHeader(request, webReportContext, hasPages, pageStatus));
        exporterConfig.setBetweenPagesHtml(this.getBetweenPages(request, webReportContext));
        exporterConfig.setHtmlFooter(this.getFooter(request, webReportContext, hasPages, pageStatus, isComponentMetadataEmbedded));
        reportConfig.setHyperlinkProducerFactory(ReportExecutionHyperlinkProducerFactory.getInstance(this.getJasperReportsContext(), request));
        exporter.setConfiguration(exporterConfig);
        exporter.setConfiguration(reportConfig);
        exporter.exportReport();
        if (isComponentMetadataEmbedded) {
            JsonExporter jsonExporter = new JsonExporter(this.getJasperReportsContext());
            StringWriter sw = new StringWriter();
            jsonExporter.setReportContext(webReportContext);
            jsonExporter.setExporterInput(new SimpleExporterInput(jasperPrintAccessor.getJasperPrint()));
            SimpleJsonExporterOutput jsonOutput = new SimpleJsonExporterOutput(sw);
            jsonOutput.setFontHandler(new WebHtmlResourceHandler(resourcesPath + "&font={0}"));
            jsonExporter.setExporterOutput(jsonOutput);
            jsonExporter.exportReport();
            String serializedJson = sw.getBuffer().toString();
            writer.write("<span id=\"reportComponents\" style=\"display:none\">" + serializedJson.replaceAll("\\s", "") + "</span></div>");
        }
    }

    protected String getHeader(HttpServletRequest request, WebReportContext webReportContext, boolean hasPages, ReportPageStatus pageStatus) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        if (hasPages) {
            return VelocityUtil.processTemplate(TEMPLATE_HEADER, contextMap);
        }
        return VelocityUtil.processTemplate(TEMPLATE_HEADER_NOPAGES, contextMap);
    }

    protected String getBetweenPages(HttpServletRequest request, WebReportContext webReportContext) {
        return VelocityUtil.processTemplate(TEMPLATE_BETWEEN_PAGES, new HashMap<String, Object>());
    }

    protected String getFooter(HttpServletRequest request, WebReportContext webReportContext, boolean hasPages, ReportPageStatus pageStatus, boolean isComponentMetadataEmbedded) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        contextMap.put("isComponentMetadataEmbedded", isComponentMetadataEmbedded);
        if (hasPages) {
            return VelocityUtil.processTemplate(TEMPLATE_FOOTER, contextMap);
        }
        return VelocityUtil.processTemplate(TEMPLATE_FOOTER_NOPAGES, contextMap);
    }
}

