/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent.InputMessageContent;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class InputVenueMessageContent
implements InputMessageContent {
    private static final String LATITUDE_FIELD = "latitude";
    private static final String LONGITUDE_FIELD = "longitude";
    private static final String TITLE_FIELD = "title";
    private static final String ADDRESS_FIELD = "address";
    private static final String FOURSQUAREID_FIELD = "foursquare_id";
    private static final String FOURSQUARETYPE_FIELD = "foursquare_type";
    private static final String GOOGLEPLACEID_FIELD = "google_place_id";
    private static final String GOOGLEPLACETYPE_FIELD = "google_place_type";
    @JsonProperty(value="latitude")
    @NonNull
    private Float latitude;
    @JsonProperty(value="longitude")
    @NonNull
    private Float longitude;
    @JsonProperty(value="title")
    @NonNull
    private String title;
    @JsonProperty(value="address")
    @NonNull
    private String address;
    @JsonProperty(value="foursquare_id")
    private String foursquareId;
    @JsonProperty(value="foursquare_type")
    private String foursquareType;
    @JsonProperty(value="google_place_id")
    private String googlePlaceId;
    @JsonProperty(value="google_place_type")
    private String googlePlaceType;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.latitude == null) {
            throw new TelegramApiValidationException("Latitude parameter can't be empty", this);
        }
        if (this.longitude == null) {
            throw new TelegramApiValidationException("Longitude parameter can't be empty", this);
        }
        if (this.title == null || this.title.isEmpty()) {
            throw new TelegramApiValidationException("Title parameter can't be empty", this);
        }
        if (this.address == null || this.address.isEmpty()) {
            throw new TelegramApiValidationException("Address parameter can't be empty", this);
        }
    }

    public static InputVenueMessageContentBuilder builder() {
        return new InputVenueMessageContentBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputVenueMessageContent)) {
            return false;
        }
        InputVenueMessageContent other = (InputVenueMessageContent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$latitude = this.getLatitude();
        Float other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
            return false;
        }
        Float this$longitude = this.getLongitude();
        Float other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$foursquareId = this.getFoursquareId();
        String other$foursquareId = other.getFoursquareId();
        if (this$foursquareId == null ? other$foursquareId != null : !this$foursquareId.equals(other$foursquareId)) {
            return false;
        }
        String this$foursquareType = this.getFoursquareType();
        String other$foursquareType = other.getFoursquareType();
        if (this$foursquareType == null ? other$foursquareType != null : !this$foursquareType.equals(other$foursquareType)) {
            return false;
        }
        String this$googlePlaceId = this.getGooglePlaceId();
        String other$googlePlaceId = other.getGooglePlaceId();
        if (this$googlePlaceId == null ? other$googlePlaceId != null : !this$googlePlaceId.equals(other$googlePlaceId)) {
            return false;
        }
        String this$googlePlaceType = this.getGooglePlaceType();
        String other$googlePlaceType = other.getGooglePlaceType();
        return !(this$googlePlaceType == null ? other$googlePlaceType != null : !this$googlePlaceType.equals(other$googlePlaceType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InputVenueMessageContent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
        Float $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $foursquareId = this.getFoursquareId();
        result = result * 59 + ($foursquareId == null ? 43 : $foursquareId.hashCode());
        String $foursquareType = this.getFoursquareType();
        result = result * 59 + ($foursquareType == null ? 43 : $foursquareType.hashCode());
        String $googlePlaceId = this.getGooglePlaceId();
        result = result * 59 + ($googlePlaceId == null ? 43 : $googlePlaceId.hashCode());
        String $googlePlaceType = this.getGooglePlaceType();
        result = result * 59 + ($googlePlaceType == null ? 43 : $googlePlaceType.hashCode());
        return result;
    }

    @NonNull
    public Float getLatitude() {
        return this.latitude;
    }

    @NonNull
    public Float getLongitude() {
        return this.longitude;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    @NonNull
    public String getAddress() {
        return this.address;
    }

    public String getFoursquareId() {
        return this.foursquareId;
    }

    public String getFoursquareType() {
        return this.foursquareType;
    }

    public String getGooglePlaceId() {
        return this.googlePlaceId;
    }

    public String getGooglePlaceType() {
        return this.googlePlaceType;
    }

    @JsonProperty(value="latitude")
    public void setLatitude(@NonNull Float latitude) {
        if (latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        this.latitude = latitude;
    }

    @JsonProperty(value="longitude")
    public void setLongitude(@NonNull Float longitude) {
        if (longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        this.longitude = longitude;
    }

    @JsonProperty(value="title")
    public void setTitle(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.title = title;
    }

    @JsonProperty(value="address")
    public void setAddress(@NonNull String address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.address = address;
    }

    @JsonProperty(value="foursquare_id")
    public void setFoursquareId(String foursquareId) {
        this.foursquareId = foursquareId;
    }

    @JsonProperty(value="foursquare_type")
    public void setFoursquareType(String foursquareType) {
        this.foursquareType = foursquareType;
    }

    @JsonProperty(value="google_place_id")
    public void setGooglePlaceId(String googlePlaceId) {
        this.googlePlaceId = googlePlaceId;
    }

    @JsonProperty(value="google_place_type")
    public void setGooglePlaceType(String googlePlaceType) {
        this.googlePlaceType = googlePlaceType;
    }

    public String toString() {
        return "InputVenueMessageContent(latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", title=" + this.getTitle() + ", address=" + this.getAddress() + ", foursquareId=" + this.getFoursquareId() + ", foursquareType=" + this.getFoursquareType() + ", googlePlaceId=" + this.getGooglePlaceId() + ", googlePlaceType=" + this.getGooglePlaceType() + ")";
    }

    public InputVenueMessageContent(@NonNull Float latitude, @NonNull Float longitude, @NonNull String title, @NonNull String address) {
        if (latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        if (longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.latitude = latitude;
        this.longitude = longitude;
        this.title = title;
        this.address = address;
    }

    public InputVenueMessageContent() {
    }

    public InputVenueMessageContent(@NonNull Float latitude, @NonNull Float longitude, @NonNull String title, @NonNull String address, String foursquareId, String foursquareType, String googlePlaceId, String googlePlaceType) {
        if (latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        if (longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.latitude = latitude;
        this.longitude = longitude;
        this.title = title;
        this.address = address;
        this.foursquareId = foursquareId;
        this.foursquareType = foursquareType;
        this.googlePlaceId = googlePlaceId;
        this.googlePlaceType = googlePlaceType;
    }

    public static class InputVenueMessageContentBuilder {
        private Float latitude;
        private Float longitude;
        private String title;
        private String address;
        private String foursquareId;
        private String foursquareType;
        private String googlePlaceId;
        private String googlePlaceType;

        InputVenueMessageContentBuilder() {
        }

        @JsonProperty(value="latitude")
        public InputVenueMessageContentBuilder latitude(@NonNull Float latitude) {
            if (latitude == null) {
                throw new NullPointerException("latitude is marked non-null but is null");
            }
            this.latitude = latitude;
            return this;
        }

        @JsonProperty(value="longitude")
        public InputVenueMessageContentBuilder longitude(@NonNull Float longitude) {
            if (longitude == null) {
                throw new NullPointerException("longitude is marked non-null but is null");
            }
            this.longitude = longitude;
            return this;
        }

        @JsonProperty(value="title")
        public InputVenueMessageContentBuilder title(@NonNull String title) {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            this.title = title;
            return this;
        }

        @JsonProperty(value="address")
        public InputVenueMessageContentBuilder address(@NonNull String address) {
            if (address == null) {
                throw new NullPointerException("address is marked non-null but is null");
            }
            this.address = address;
            return this;
        }

        @JsonProperty(value="foursquare_id")
        public InputVenueMessageContentBuilder foursquareId(String foursquareId) {
            this.foursquareId = foursquareId;
            return this;
        }

        @JsonProperty(value="foursquare_type")
        public InputVenueMessageContentBuilder foursquareType(String foursquareType) {
            this.foursquareType = foursquareType;
            return this;
        }

        @JsonProperty(value="google_place_id")
        public InputVenueMessageContentBuilder googlePlaceId(String googlePlaceId) {
            this.googlePlaceId = googlePlaceId;
            return this;
        }

        @JsonProperty(value="google_place_type")
        public InputVenueMessageContentBuilder googlePlaceType(String googlePlaceType) {
            this.googlePlaceType = googlePlaceType;
            return this;
        }

        public InputVenueMessageContent build() {
            return new InputVenueMessageContent(this.latitude, this.longitude, this.title, this.address, this.foursquareId, this.foursquareType, this.googlePlaceId, this.googlePlaceType);
        }

        public String toString() {
            return "InputVenueMessageContent.InputVenueMessageContentBuilder(latitude=" + this.latitude + ", longitude=" + this.longitude + ", title=" + this.title + ", address=" + this.address + ", foursquareId=" + this.foursquareId + ", foursquareType=" + this.foursquareType + ", googlePlaceId=" + this.googlePlaceId + ", googlePlaceType=" + this.googlePlaceType + ")";
        }
    }
}

