/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.struts.action;

import java.sql.Connection;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.ProcessLinkProcessAction;
import org.bgerp.app.cfg.SimpleConfigMap;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.cache.ProcessQueueCache;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.dao.process.Order;
import org.bgerp.dao.process.ProcessLinkSearchDAO;
import org.bgerp.dao.process.ProcessQueueDAO;
import org.bgerp.model.Pageable;
import org.bgerp.model.process.ProcessCreateType;
import org.bgerp.model.process.queue.filter.FilterLinkObject;
import org.bgerp.model.process.queue.filter.FilterList;
import org.bgerp.model.process.queue.filter.FilterOpenClose;
import org.bgerp.model.process.queue.filter.FilterProcessType;
import org.bgerp.util.Log;
import org.bgerp.util.sql.LikePattern;
import ru.bgcrm.dao.process.ProcessLinkDAO;
import ru.bgcrm.event.client.ProcessOpenEvent;
import ru.bgcrm.event.link.LinkAddedEvent;
import ru.bgcrm.event.link.LinkAddingEvent;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.model.Pair;
import ru.bgcrm.model.customer.config.ProcessLinkModesConfig;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.process.queue.Queue;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.action.ProcessAction;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;
import ru.bgcrm.util.sql.SingleConnectionSet;

@ActionServlet.Action(path="/user/process/link")
public class ProcessLinkAction
extends ProcessAction {
    private static final Log log = Log.getLog();
    private static final String PATH_JSP = "/WEB-INF/jspf/user/process/process/link";

    public ActionForward linkedProcessList(DynActionForm form, ConnectionSet conSet) throws Exception {
        this.restoreRequestParams(conSet.getConnection(), form, true, true, "open");
        String objectType = form.getParam("objectType");
        int id = form.getId();
        Boolean open = form.getParamBoolean("open", null);
        Set<Integer> typeIds = form.getParamValues("typeId");
        Queue queue = ProcessQueueCache.getQueue(this.setup.getInt(objectType + ".processes.queue"));
        if (queue != null) {
            queue = queue.clone();
            FilterList filters = queue.getFilterList();
            filters.add(new FilterLinkObject(0, SimpleConfigMap.of(new Object[]{"values", String.valueOf(id)}), objectType, "id"));
            if (open != null) {
                filters.add(new FilterOpenClose(0, SimpleConfigMap.of(new Object[]{"values", open != false ? "open" : "close"})));
            }
            if (!typeIds.isEmpty()) {
                filters.add(new FilterProcessType(0, SimpleConfigMap.of(new Object[]{"onEmptyValues", Utils.toString(typeIds)})));
            }
            Pageable<Object[]> searchResult = new Pageable<Object[]>(form);
            new ProcessQueueDAO(conSet.getConnection(), form).searchProcess(searchResult, null, queue, form);
            List<Object[]> list = searchResult.getList();
            HttpServletRequest request = form.getHttpRequest();
            request.setAttribute("columnList", queue.getMediaColumnList("html"));
            queue.replaceRowsForMedia(form, "html", list);
            request.setAttribute("queue", (Object)queue);
        } else {
            form.setRequestAttribute("customerLinkRoleConfig", this.setup.getConfig(ProcessLinkModesConfig.class));
            ((ProcessLinkSearchDAO)new ProcessLinkSearchDAO(conSet.getConnection(), form).withLinkObjectTypeLike(LikePattern.START.get(objectType)).withLinkObjectId(id).withType((Set)typeIds)).withOpen(open).order(Order.CREATE_DT_DESC).searchWithLinkObjectTypes(new Pageable<Pair<Process, String>>(form));
            Pageable<Process> processes = new Pageable().withoutPagination();
            new ProcessLinkSearchDAO(conSet.getSlaveConnection(), form).withLinkObjectTypeLike(LikePattern.START.get(objectType)).withLinkObjectId(id).search(processes);
            form.setResponseData("types", this.processTypes(processes.getList()));
        }
        form.setRequestAttribute("typeTreeRoot", ProcessCreateType.treeRoot(form, objectType, null));
        return this.html(conSet, form, "/WEB-INF/jspf/user/process/process/link/linked_process_list.jsp");
    }

    public ActionForward linkedProcessCreate(DynActionForm form, Connection con) throws Exception {
        String objectType = form.getParam("objectType");
        int id = form.getId();
        String objectTitle = form.getParam("objectTitle");
        int typeId = form.getParamInt("typeId");
        Process process = ProcessAction.processCreateAndGet(form, con);
        CommonObjectLink link = new CommonObjectLink("process", process.getId(), objectType, id, objectTitle);
        EventProcessor.processEvent(new LinkAddingEvent(form, link), new SingleConnectionSet(con));
        new ProcessLinkDAO(con).addLink(link);
        EventProcessor.processEvent(new LinkAddedEvent(form, link), new SingleConnectionSet(con));
        ProcessCreateType type = ProcessLinkAction.processCreateTypes(form, objectType, null).stream().filter(t -> (Integer)t.getId() == typeId).findAny().orElseThrow();
        new ParamValueDAO(con).copyParams(id, (int)process.getId(), type.getCopyParams());
        if (type.openCreated() || type.getType().getProperties().getWizard() != null && type.getType().getProperties().getWizard().getCreateStepList().size() > 0) {
            form.getResponse().addEvent(new ProcessOpenEvent(process.getId()));
        }
        return this.json(con, form);
    }

    @Deprecated
    public static Process linkProcessCreate(Connection con, DynActionForm form, Process linkedProcess, int typeId, String objectType, int createTypeId, String description, int groupId) throws Exception {
        log.warnd("linkProcessCreate", "ProcessLinkProcessAction.linkProcessCreate");
        return ProcessLinkProcessAction.linkProcessCreate(con, form, linkedProcess, typeId, objectType, createTypeId, description, groupId);
    }
}

