/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.document.model;

import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.servlet.jsp.GetJsp;
import org.bgerp.model.base.IdTitle;
import org.bgerp.util.Log;
import ru.bgcrm.util.Utils;

public class Pattern
extends IdTitle
implements GetJsp {
    private static final Log log = Log.getLog();
    public static final int TYPE_PDF_FORM = 1;
    public static final int TYPE_DOCX_FORM = 2;
    public static final int TYPE_ODT_FORM = 3;
    public static final int TYPE_XSLT_HTML = 4;
    @Deprecated
    public static final int TYPE_XSLT_PDF = 5;
    public static final int TYPE_XSLX = 6;
    public static final int TYPE_JSP_HTML = 7;
    private final ConfigMap params;
    private final String file;
    private String documentTitle;
    private final String script;
    private final String scope;
    private final String scopeType;
    private final int type;
    private final boolean resultSave;
    private final boolean resultStream;
    private java.util.regex.Pattern titlePattern;
    private final String xslt;
    private final String jsp;
    @Deprecated
    private ConfigMap positionMap;

    public Pattern(int id, ConfigMap params) {
        super(id, params.get("title"));
        this.params = params;
        this.script = params.get("script");
        this.scope = params.get("scope");
        this.scopeType = params.get("scopeType");
        this.file = params.get("file");
        this.documentTitle = params.get("documentTitle");
        this.xslt = params.get("xslt");
        this.jsp = params.get("jsp");
        String type = params.get("type");
        if (id <= 0 || Utils.isBlankString(this.scope) || Utils.isBlankString(this.script) || Utils.isBlankString(type)) {
            throw new BGException("Error pattern load: " + id, new Object[0]);
        }
        String titlePattern = params.get("titleRegexp");
        if (Utils.notBlankString(titlePattern)) {
            try {
                this.titlePattern = java.util.regex.Pattern.compile(titlePattern);
            }
            catch (Exception e) {
                throw new BGException("Error on regexp parse: " + titlePattern, new Object[0]);
            }
        }
        Set<String> resultSet = Utils.toSet(params.get("result", "save"));
        this.resultSave = resultSet.contains("save");
        this.resultStream = resultSet.contains("stream");
        if ("pdfForm".equals(type)) {
            this.type = 1;
        } else if ("docxForm".equals(type)) {
            this.type = 2;
        } else if ("odtForm".equals(type)) {
            this.type = 3;
        } else if ("xsltHtml".equals(type)) {
            this.type = 4;
        } else if ("xsltPdf".equals(type)) {
            this.type = 5;
        } else if ("xlsxForm".equals(type)) {
            this.type = 6;
        } else if ("jspHtml".equals(type)) {
            this.type = 7;
        } else {
            throw new BGException("Unsupported document pattern type: " + type + "; pattern: " + id, new Object[0]);
        }
        this.positionMap = params.sub("position.");
        if (log.isDebugEnabled()) {
            log.debug("Pattern loaded: " + ToStringBuilder.reflectionToString((Object)this), new Object[0]);
        }
    }

    public ConfigMap getParams() {
        return this.params;
    }

    public String getScript() {
        return this.script;
    }

    public String getScope() {
        return this.scope;
    }

    public int getType() {
        return this.type;
    }

    public String getFile() {
        return this.file;
    }

    public void setDocumentTitle(String documentTitle) {
        this.documentTitle = documentTitle;
    }

    public String getDocumentTitle() {
        return this.documentTitle;
    }

    public String getXslt() {
        return this.xslt;
    }

    @Override
    public String getJsp() {
        return this.jsp;
    }

    public boolean isResultSave() {
        return this.resultSave;
    }

    public boolean isResultStream() {
        return this.resultStream;
    }

    @Deprecated
    public String getPositionMacros(String positionName) {
        return this.positionMap.get(positionName);
    }

    public boolean checkTitle(String objectTitle) {
        if (objectTitle != null && this.titlePattern != null) {
            return this.titlePattern.matcher(objectTitle).matches();
        }
        return true;
    }

    public boolean checkType(String objectType) {
        if (objectType != null && this.scopeType != null) {
            return this.scopeType.equals(objectType);
        }
        return true;
    }
}

