/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.proto.struts.action;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.struts.action.ActionForward;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.exception.BGIllegalArgumentException;
import org.bgerp.app.exception.BGMessageException;
import ru.bgcrm.plugin.bgbilling.DBInfo;
import ru.bgcrm.plugin.bgbilling.DBInfoManager;
import ru.bgcrm.plugin.bgbilling.proto.dao.BalanceDAO;
import ru.bgcrm.plugin.bgbilling.proto.dao.CashCheckDAO;
import ru.bgcrm.plugin.bgbilling.proto.dao.ContractDAO;
import ru.bgcrm.plugin.bgbilling.proto.dao.DirectoryDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.balance.ContractAccount;
import ru.bgcrm.plugin.bgbilling.proto.model.balance.ContractBalanceDetail;
import ru.bgcrm.plugin.bgbilling.proto.model.balance.ContractBalanceGeneral;
import ru.bgcrm.plugin.bgbilling.proto.model.balance.ContractCharge;
import ru.bgcrm.plugin.bgbilling.proto.model.balance.ContractPayment;
import ru.bgcrm.plugin.bgbilling.struts.action.BaseAction;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/user/plugin/bgbilling/proto/balance")
public class ContractBalanceAction
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/user/plugin/bgbilling/contract/balance";

    public ActionForward balanceEditor(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        String item = form.getParam("item");
        DirectoryDAO directoryDAO = new DirectoryDAO(form.getUser(), billingId);
        BalanceDAO balanceDAO = new BalanceDAO(form.getUser(), billingId);
        if ("contractCharge".equals(item)) {
            Set<Integer> allowedTypeIds = this.getTypePermission(form, billingId, "chargeTypeIds");
            form.setResponseData("itemTypes", directoryDAO.getContractChargeTypes(allowedTypeIds));
            if (form.getId() > 0) {
                form.setResponseData("balanceItem", balanceDAO.getContractCharge(form.getId()));
            }
        } else if ("contractPayment".equals(item)) {
            DBInfo dbInfo = DBInfoManager.getDbInfo(billingId);
            if (dbInfo.getPluginSet().contains("ru.bitel.bgbilling.plugins.cashcheck")) {
                form.setResponseData("currentPrinter", new CashCheckDAO(form.getUser(), billingId).getCurrentPrinter());
            }
            Set<Integer> allowedTypeIds = this.getTypePermission(form, billingId, "paymentTypeIds");
            form.setResponseData("itemTypes", directoryDAO.getContractPaymentTypes(allowedTypeIds));
            if (form.getId() > 0) {
                form.setResponseData("balanceItem", balanceDAO.getContractPayment(form.getId()));
            }
        }
        form.setResponseData("date", new SimpleDateFormat("dd.MM.yyyy").format(Calendar.getInstance().getTime()));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/balance/balance_editor.jsp");
    }

    private Set<Integer> getTypePermission(DynActionForm form, String billingId, String key) {
        String paymentTypeConfig;
        HashSet<Integer> allowedTypeIds = new HashSet<Integer>();
        ConfigMap permission = form.getPermission();
        if (permission != null && Utils.notBlankString(paymentTypeConfig = permission.get(key))) {
            for (String str : paymentTypeConfig.split(";")) {
                if (!str.startsWith(billingId)) continue;
                allowedTypeIds.addAll(Utils.toIntegerSet(str.split(":")[1]));
            }
        }
        return allowedTypeIds;
    }

    public ActionForward balance(DynActionForm form, ConnectionSet conSet) throws BGMessageException {
        String billingId = form.getParam("billingId");
        int contractId = form.getParamInt("contractId");
        Date[] period = this.getPeriod(form);
        BalanceDAO balanceDAO = new BalanceDAO(form.getUser(), billingId);
        ArrayList<ContractBalanceGeneral> balanceList = new ArrayList<ContractBalanceGeneral>();
        form.setResponseData("list", balanceList);
        form.setResponseData("summs", balanceDAO.getContractBalanceList(contractId, period[0], period[1], balanceList));
        form.setResponseData("contractInfo", new ContractDAO(form.getUser(), billingId).getContractInfo(contractId));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/balance/balance_list.jsp");
    }

    public ActionForward balanceDetail(DynActionForm form, ConnectionSet conSet) throws BGMessageException {
        String billingId = form.getParam("billingId");
        int contractId = form.getParamInt("contractId");
        BalanceDAO balanceDAO = new BalanceDAO(form.getUser(), billingId);
        ArrayList<ContractBalanceDetail> balanceList = new ArrayList<ContractBalanceDetail>();
        form.setResponseData("list", balanceList);
        Date[] period = this.getPeriod(form);
        form.setResponseData("summa", balanceDAO.getContractBalanceDetailList(contractId, period[0], period[1], balanceList));
        form.setResponseData("contractInfo", new ContractDAO(form.getUser(), billingId).getContractInfo(contractId));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/balance/detail_balance_list.jsp");
    }

    public ActionForward paymentList(DynActionForm form, ConnectionSet conSet) throws BGMessageException {
        String billingId = form.getParam("billingId");
        int contractId = form.getParamInt("contractId");
        BalanceDAO balanceDAO = new BalanceDAO(form.getUser(), billingId);
        ArrayList<ContractPayment> paymentList = new ArrayList<ContractPayment>();
        form.setResponseData("list", paymentList);
        ArrayList<ContractPayment> subPaymentList = new ArrayList<ContractPayment>();
        form.setResponseData("subList", subPaymentList);
        Date[] period = this.getPeriod(form);
        form.setResponseData("summa", balanceDAO.getContractPaymentList(contractId, period[0], period[1], paymentList, subPaymentList));
        form.setResponseData("contractInfo", new ContractDAO(form.getUser(), billingId).getContractInfo(contractId));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/balance/payment_list.jsp");
    }

    public ActionForward chargeList(DynActionForm form, ConnectionSet conSet) throws BGMessageException {
        String billingId = form.getParam("billingId");
        int contractId = form.getParamInt("contractId");
        BalanceDAO balanceDAO = new BalanceDAO(form.getUser(), billingId);
        ArrayList<ContractCharge> chargeList = new ArrayList<ContractCharge>();
        form.setResponseData("list", chargeList);
        ArrayList<ContractCharge> subChargeList = new ArrayList<ContractCharge>();
        form.setResponseData("subList", subChargeList);
        Date[] period = this.getPeriod(form);
        form.setResponseData("summa", balanceDAO.getContractChargeList(contractId, period[0], period[1], chargeList, subChargeList));
        form.setResponseData("contractInfo", new ContractDAO(form.getUser(), billingId).getContractInfo(contractId));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/balance/charge_list.jsp");
    }

    public ActionForward accountList(DynActionForm form, ConnectionSet conSet) throws BGMessageException {
        String billingId = form.getParam("billingId");
        int contractId = form.getParamInt("contractId");
        BalanceDAO balanceDAO = new BalanceDAO(form.getUser(), billingId);
        Date[] period = this.getPeriod(form);
        ArrayList<ContractAccount> chargeList = new ArrayList<ContractAccount>();
        form.setResponseData("list", chargeList);
        ArrayList<ContractAccount> subChargeList = new ArrayList<ContractAccount>();
        form.setResponseData("subList", subChargeList);
        form.setResponseData("summa", balanceDAO.getContractAccountList(contractId, period[0], period[1], chargeList, subChargeList));
        form.setResponseData("contractInfo", new ContractDAO(form.getUser(), billingId).getContractInfo(contractId));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/balance/account_list.jsp");
    }

    private Date[] getPeriod(DynActionForm form) throws BGIllegalArgumentException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(5, 1);
        Date dateFrom = TimeUtils.parse(form.getParam("dateFrom", ""), "dd.MM.yyyy", calendar.getTime());
        calendar.set(5, calendar.getActualMaximum(5));
        Date dateTo = TimeUtils.parse(form.getParam("dateTo", ""), "dd.MM.yyyy", calendar.getTime());
        form.setParam("dateFrom", TimeUtils.format(dateFrom, "dd.MM.yyyy"));
        form.setParam("dateTo", TimeUtils.format(dateTo, "dd.MM.yyyy"));
        return new Date[]{dateFrom, dateTo};
    }

    public ActionForward updateBalance(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        int contractId = form.getParamInt("contractId");
        String item = form.getParam("item");
        Date date = TimeUtils.parse(form.getParam("date", ""), "dd.MM.yyyy");
        int id = form.getParamInt("id", 0);
        int typeId = form.getParamInt("typeId");
        BigDecimal summa = Utils.parseBigDecimal(form.getParam("summa", "").replace(',', '.'));
        String comment = form.getParam("comment");
        BalanceDAO balanceDAO = new BalanceDAO(form.getUser(), billingId);
        if ("contractPayment".equals(item)) {
            id = balanceDAO.updateContractPayment(id, contractId, summa, date, typeId, comment);
        } else if ("contractCharge".equals(item)) {
            id = balanceDAO.updateContractCharge(id, contractId, summa, date, typeId, comment);
        }
        form.setResponseData("id", id);
        return this.json(conSet, form);
    }

    public ActionForward deletePayment(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer paymentId = form.getParamInt("paymentId");
        Integer contractId = form.getParamInt("contractId");
        BalanceDAO balanceDAO = new BalanceDAO(form.getUser(), billingId);
        balanceDAO.deleteContractPayment(paymentId, contractId);
        return this.json(conSet, form);
    }

    public ActionForward deleteCharge(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer chargeId = form.getParamInt("chargeId");
        Integer contractId = form.getParamInt("contractId");
        BalanceDAO balanceDAO = new BalanceDAO(form.getUser(), billingId);
        balanceDAO.deleteContractCharge(chargeId, contractId);
        return this.json(conSet, form);
    }
}

