/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.proto.dao;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.app.exception.BGMessageExceptionWithoutL10n;
import org.bgerp.cache.ParameterCache;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.model.base.IdTitle;
import org.bgerp.model.base.tree.IdStringTitleTreeItem;
import org.bgerp.model.param.Parameter;
import org.bgerp.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bgcrm.model.Pair;
import ru.bgcrm.model.ParamList;
import ru.bgcrm.model.param.ParameterAddressValue;
import ru.bgcrm.model.param.ParameterEmailValue;
import ru.bgcrm.model.param.ParameterPhoneValue;
import ru.bgcrm.model.param.ParameterPhoneValueItem;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.DBInfo;
import ru.bgcrm.plugin.bgbilling.Request;
import ru.bgcrm.plugin.bgbilling.RequestJsonRpc;
import ru.bgcrm.plugin.bgbilling.dao.BillingDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.ContractParameter;
import ru.bgcrm.plugin.bgbilling.proto.model.ParamAddressValue;
import ru.bgcrm.plugin.bgbilling.proto.model.ParamEmailValue;
import ru.bgcrm.plugin.bgbilling.proto.model.entity.EntityAttrAddress;
import ru.bgcrm.plugin.bgbilling.proto.model.entity.EntityAttrDate;
import ru.bgcrm.plugin.bgbilling.proto.model.entity.EntityAttrEmail;
import ru.bgcrm.plugin.bgbilling.proto.model.entity.EntityAttrList;
import ru.bgcrm.plugin.bgbilling.proto.model.entity.EntityAttrPhone;
import ru.bgcrm.plugin.bgbilling.proto.model.entity.EntityAttrText;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public class ContractParamDAO
extends BillingDAO {
    private static final String KERNEL_CONTRACT_API = "ru.bitel.bgbilling.kernel.contract.api";
    private static final String CONTRACT_MODULE_ID = "contract";

    public ContractParamDAO(User user, String billingId) {
        super(user, billingId);
    }

    public ContractParamDAO(User user, DBInfo dbInfo) {
        super(user, dbInfo);
    }

    public static ParameterAddressValue toCrmObject(ParamAddressValue item, Connection con) throws SQLException {
        ParameterAddressValue crmItem = new ParameterAddressValue();
        if (item != null) {
            crmItem.setComment(item.getComment());
            crmItem.setFlat(item.getFlat());
            crmItem.setFloor(Utils.parseInt(item.getFloor()));
            crmItem.setHouseId(item.getHouseId());
            crmItem.setPod(Utils.parseInt(item.getPod()));
            crmItem.setRoom(item.getRoom());
            crmItem.setValue(crmItem.formatValue(con));
        }
        return crmItem;
    }

    public List<ContractParameter> getParameterList(int contractId) {
        return this.getParameterListWithDir(contractId, false, false).getSecond();
    }

    public Pair<ParamList, List<ContractParameter>> getParameterListWithDir(int contractId, boolean loadGroups, boolean onlyGroup) {
        Pair<ParamList, List<ContractParameter>> result = new Pair<ParamList, List<ContractParameter>>();
        ParamList groupDir = new ParamList();
        ArrayList<ContractParameter> valueList = new ArrayList<ContractParameter>();
        result.setFirst(groupDir);
        result.setSecond(valueList);
        Request req = new Request();
        req.setModule(CONTRACT_MODULE_ID);
        req.setAction("ContractParameters");
        req.setContractId(contractId);
        if (!onlyGroup) {
            req.setAttribute("all", 1);
        }
        if (loadGroups) {
            req.setAttribute("list", 1);
        }
        Document doc = this.transferData.postData(req, this.user);
        for (Element e : XMLUtils.selectElements(doc, "/data/parameters/parameter")) {
            valueList.add(new ContractParameter(Utils.parseInt(e.getAttribute("pid")), Utils.parseInt(e.getAttribute("pt")), e.getAttribute("title"), e.getAttribute("value")));
        }
        groupDir.setId(Utils.parseInt(XMLUtils.selectText(doc, "/data/condel/@pgid")));
        for (Element e : XMLUtils.selectElements(doc, "/data/groups/item")) {
            groupDir.addValue(new IdTitle(Utils.parseInt(e.getAttribute("id")), e.getAttribute("title")));
        }
        return result;
    }

    public Document getContractParams(int contractId) {
        Request request = new Request();
        request.setModule(CONTRACT_MODULE_ID);
        request.setAction("ContractParameters");
        request.setContractId(contractId);
        return this.transferData.postData(request, this.user);
    }

    public String getTextParam(int contractId, int paramId) {
        ContractParameter contractParam = this.getParameter(contractId, paramId);
        return contractParam != null ? contractParam.getValue() : "";
    }

    public Date getDateParam(int contractId, int paramId) {
        ContractParameter contractParam = this.getParameter(contractId, paramId);
        return contractParam != null ? TimeUtils.parse(contractParam.getValue(), "dd.MM.yyyy") : null;
    }

    private ContractParameter getParameter(int contractId, int paramId) {
        for (ContractParameter param : this.getParameterListWithDir(contractId, false, false).getSecond()) {
            if (param.getParamId() != paramId) continue;
            return param;
        }
        return null;
    }

    public List<IdTitle> getParamListValues(int paramId) {
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(KERNEL_CONTRACT_API, "ContractParameterService", "contractParameterListItemList");
            req.setParam("parameterTypeId", paramId);
            JsonNode ret = this.transferData.postDataReturn(req, this.user);
            return (List)this.readJsonValue(ret.traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, IdTitle.class));
        }
        ArrayList<IdTitle> valueList = new ArrayList<IdTitle>();
        Request req = new Request();
        req.setModule("admin");
        req.setAction("ListValues");
        req.setAttribute("pid", paramId);
        Document doc = this.transferData.postData(req, this.user);
        for (Element e : XMLUtils.selectElements(doc, "/data/values/item")) {
            valueList.add(new IdTitle(Utils.parseInt(e.getAttribute("id")), e.getAttribute("title")));
        }
        return valueList;
    }

    public ParameterPhoneValue getPhoneParam(int contractId, int paramId) {
        ParameterPhoneValue result = new ParameterPhoneValue();
        Request billingRequest = new Request();
        billingRequest.setModule(CONTRACT_MODULE_ID);
        billingRequest.setAction("PhoneInfo");
        if (this.dbInfo.versionCompare("5.2") >= 0) {
            billingRequest.setAction("GetPhoneInfo");
        }
        billingRequest.setContractId(contractId);
        billingRequest.setAttribute("pid", paramId);
        Document doc = this.transferData.postData(billingRequest, this.user);
        Element phone = XMLUtils.selectElement(doc, "/data/phone");
        if (phone != null) {
            int itemCount = Utils.parseInt(phone.getAttribute("count"));
            if (this.dbInfo.versionCompare("5.1") <= 0) {
                itemCount = 5;
            }
            for (int i = 1; i <= itemCount; ++i) {
                String number = phone.getAttribute("phone" + i);
                String comment = phone.getAttribute("comment" + i);
                if (Utils.isBlankString(number)) continue;
                if (this.dbInfo.versionCompare("9.2") >= 0) {
                    number = number.replaceAll("[^\\d.]", "");
                }
                ParameterPhoneValueItem item = new ParameterPhoneValueItem();
                item.setPhone(number);
                item.setComment(comment);
                result.addItem(item);
            }
        }
        return result;
    }

    private List<IdStringTitleTreeItem> getEmailSubscrTree(Element treeElm) {
        ArrayList<IdStringTitleTreeItem> treeValues = new ArrayList<IdStringTitleTreeItem>();
        for (Element e : XMLUtils.selectElements(treeElm, "item")) {
            IdStringTitleTreeItem cur = new IdStringTitleTreeItem();
            cur.setId(e.getAttribute("id"));
            cur.setTitle(e.getAttribute("title"));
            if (e.getAttribute("type").equals("1")) {
                cur.setChildren(this.getEmailSubscrTree(e));
            }
            treeValues.add(cur);
        }
        return treeValues;
    }

    public ParamEmailValue getEmailParam(int contractId, int paramId) {
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(KERNEL_CONTRACT_API, "ContractService", "contractParameterGet");
            req.setParam("contractId", contractId);
            req.setParam("parameterId", paramId);
            JsonNode ret = this.transferData.postDataReturn(req, this.user);
            EntityAttrEmail attrEmail = (EntityAttrEmail)this.jsonMapper.convertValue((Object)ret, EntityAttrEmail.class);
            ParamEmailValue result = new ParamEmailValue();
            List<String> emails = attrEmail.getContactList().stream().map(i -> i.getAddress()).collect(Collectors.toList());
            result.setEmails(emails);
            result.setEntityAttrEmail(attrEmail);
            return result;
        }
        ParamEmailValue result = new ParamEmailValue();
        Request billingRequest = new Request();
        billingRequest.setModule(CONTRACT_MODULE_ID);
        billingRequest.setAction("EmailInfo");
        billingRequest.setContractId(contractId);
        billingRequest.setAttribute("pid", paramId);
        Document doc = this.transferData.postData(billingRequest, this.user);
        ArrayList<String> emails = new ArrayList<String>();
        result.setEmails(emails);
        if (this.dbInfo.versionCompare("5.2") < 0) {
            Element data = XMLUtils.selectElement(doc, "/data");
            for (Element e : XMLUtils.selectElements(data, "email_list/row")) {
                emails.add(e.getAttribute("text"));
            }
            result.setSubscrs(Utils.toList(data.getAttribute("buf")));
            result.setEid(Utils.parseInt(data.getAttribute("id")));
            billingRequest = new Request();
            billingRequest.setModule(CONTRACT_MODULE_ID);
            billingRequest.setAction("GetEmailTree");
            doc = this.transferData.postData(billingRequest, this.user);
            Element treeElm = XMLUtils.selectElement(doc, "/data/tree");
            List<IdStringTitleTreeItem> treeValues = null;
            if (treeElm != null) {
                treeValues = this.getEmailSubscrTree(treeElm);
            }
            result.setSubscrsTree(treeValues);
        } else {
            for (Element e : XMLUtils.selectElements(doc, "/data/table/data/row")) {
                emails.add(e.getAttribute("name") + " <" + e.getAttribute("email") + ">");
            }
        }
        return result;
    }

    public ParamAddressValue getAddressParam(int contractId, int paramId) {
        ParamAddressValue result = null;
        Request req = new Request();
        req.setModule(CONTRACT_MODULE_ID);
        req.setAction("AddressInfo");
        req.setContractId(contractId);
        req.setAttribute("pid", paramId);
        Document doc = this.transferData.postData(req, this.user);
        Element address = XMLUtils.selectElement(doc, "/data/address");
        if (address != null && Utils.notBlankString(XMLUtils.selectText(address, "@hid"))) {
            result = new ParamAddressValue();
            result.setCityId(Utils.parseInt(address.getAttribute("cityid")));
            result.setCityTitle(address.getAttribute("city"));
            result.setAreaTitle(address.getAttribute("areaValue"));
            result.setQuarterTitle(address.getAttribute("quarterValue"));
            result.setStreetId(Utils.parseInt(address.getAttribute("streetid")));
            result.setStreetTitle(address.getAttribute("street"));
            result.setHouseId(Utils.parseInt(address.getAttribute("hid")));
            result.setHouse(address.getAttribute("house"));
            result.setFlat(address.getAttribute("flat"));
            result.setRoom(address.getAttribute("room"));
            result.setComment(address.getAttribute("comment"));
            result.setPod(address.getAttribute("pod"));
            String floor = address.getAttribute("floor");
            if (Utils.parseInt(floor) > 0) {
                result.setFloor(floor);
            }
        }
        return result;
    }

    public ParamList getListParamValue(int contractId, int paramId) {
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(KERNEL_CONTRACT_API, "ContractService", "contractParameterGet");
            req.setParam("contractId", contractId);
            req.setParam("parameterId", paramId);
            JsonNode ret = this.transferData.postDataReturn(req, this.user);
            EntityAttrList attrList = (EntityAttrList)this.jsonMapper.convertValue((Object)ret, EntityAttrList.class);
            ParamList result = new ParamList();
            result.setId(attrList.getValue());
            result.setTitle(attrList.getTitle());
            this.getParamListValues(paramId).forEach(result::addValue);
            return result;
        }
        ParamList paramList = new ParamList();
        Request req = new Request();
        req.setModule(CONTRACT_MODULE_ID);
        req.setAction("GetListParam");
        req.setContractId(contractId);
        req.setAttribute("pid", paramId);
        Document doc = this.transferData.postData(req, this.user);
        paramList.setId(Utils.parseInt(XMLUtils.selectText(doc, "/data/values/@value"), -1));
        Element dataElement = doc.getDocumentElement();
        NodeList nodeList = dataElement.getElementsByTagName("item");
        for (int index = 0; index < nodeList.getLength(); ++index) {
            IdTitle value = new IdTitle();
            Element element = (Element)nodeList.item(index);
            value.setId(Utils.parseInt(element.getAttribute("id")));
            value.setTitle(element.getAttribute("title"));
            paramList.addValue(value);
        }
        return paramList;
    }

    public void updateFlagParameter(int contractId, int paramId, boolean value) {
        Request req = new Request();
        req.setModule(CONTRACT_MODULE_ID);
        req.setAction("UpdateParameterType5");
        req.setContractId(contractId);
        req.setAttribute("pid", paramId);
        req.setAttribute("value", value);
        this.transferData.postData(req, this.user);
    }

    public void updateTextParameter(int contractId, int paramId, String value) {
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(KERNEL_CONTRACT_API, "ContractService", "contractParameterTextUpdate");
            req.setParam("contractId", contractId);
            req.setParam("parameter", new EntityAttrText(contractId, paramId, value));
            this.transferData.postData(req, this.user);
        } else {
            Request req = new Request();
            req.setModule(CONTRACT_MODULE_ID);
            req.setAction("UpdateParameterType1");
            req.setContractId(contractId);
            req.setAttribute("pid", paramId);
            req.setAttribute("value", value);
            this.transferData.postData(req, this.user);
        }
    }

    public void updateListParameter(int contractId, int paramId, int value) {
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            EntityAttrList attrEmail = new EntityAttrList(contractId, paramId, value, null);
            RequestJsonRpc req = new RequestJsonRpc(KERNEL_CONTRACT_API, "ContractService", "contractParameterListUpdate");
            req.setParam("contractId", contractId);
            req.setParam("parameter", attrEmail);
            this.transferData.postDataReturn(req, this.user);
        } else {
            Request req = new Request();
            req.setModule(CONTRACT_MODULE_ID);
            req.setAction("UpdateListParam");
            req.setContractId(contractId);
            req.setAttribute("pid", paramId);
            req.setAttribute("value", value);
            this.transferData.postData(req, this.user);
        }
    }

    public void updateListParameter(int contractId, int paramId, String value) {
        this.updateListParameter(contractId, paramId, Utils.parseInt(value));
    }

    public void updateAddressParameter(int contractId, int paramId, ParamAddressValue address) {
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            EntityAttrAddress attrAddress = new EntityAttrAddress(0, paramId);
            attrAddress.setHouseId(address.getHouseId());
            attrAddress.setPod(Utils.parseInt(address.getPod()));
            attrAddress.setFloor(Utils.parseInt(address.getFloor()));
            attrAddress.setFlat(Utils.maskNull(address.getFlat()));
            attrAddress.setRoom(Utils.maskNull(address.getRoom()));
            attrAddress.setComment(Utils.maskNull(address.getComment()));
            RequestJsonRpc req = new RequestJsonRpc(KERNEL_CONTRACT_API, "ContractService", "contractParameterAddressUpdate");
            req.setParam("contractId", contractId);
            req.setParam("parameter", attrAddress);
            this.transferData.postDataReturn(req, this.user);
        } else {
            Request req = new Request();
            req.setModule(CONTRACT_MODULE_ID);
            req.setAction("UpdateAddressInfo");
            req.setContractId(contractId);
            req.setAttribute("pid", paramId);
            req.setAttribute("index", address.getIndex());
            req.setAttribute("cityStr", address.getCityTitle());
            req.setAttribute("streetStr", address.getStreetTitle());
            req.setAttribute("houseAndFrac", address.getHouse());
            req.setAttribute("hid", address.getHouseId());
            req.setAttribute("pod", address.getPod());
            req.setAttribute("floor", address.getFloor());
            req.setAttribute("flat", address.getFlat());
            req.setAttribute("room", address.getRoom());
            req.setAttribute("comment", address.getComment());
            this.transferData.postData(req, this.user);
        }
    }

    public void updateDateParameter(int contractId, int paramId, Date value) {
        Request req = new Request();
        req.setModule(CONTRACT_MODULE_ID);
        req.setAction("UpdateParameterType" + String.valueOf(6));
        req.setContractId(contractId);
        req.setAttribute("pid", paramId);
        req.setAttribute("value", new SimpleDateFormat("dd.MM.yyyy").format(value));
        this.transferData.postData(req, this.user);
    }

    public void updateDateParameter(int contractId, int paramId, String value) {
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(KERNEL_CONTRACT_API, "ContractService", "contractParameterDateUpdate");
            req.setParam("contractId", contractId);
            req.setParam("parameter", new EntityAttrDate(contractId, paramId, TimeUtils.parse(value, "ymd")));
            this.transferData.postData(req, this.user);
        } else {
            Request req = new Request();
            req.setModule(CONTRACT_MODULE_ID);
            req.setAction("UpdateParameterType6");
            req.setContractId(contractId);
            req.setAttribute("pid", paramId);
            req.setAttribute("value", value);
            this.transferData.postData(req, this.user);
        }
    }

    public void updatePhoneParameter(int contractId, int paramId, ParameterPhoneValue phoneValue) {
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            EntityAttrPhone value = new EntityAttrPhone(contractId, paramId);
            for (ParameterPhoneValueItem item : phoneValue.getItemList()) {
                value.addContact(item.getPhone(), item.getComment());
            }
            RequestJsonRpc req = new RequestJsonRpc(KERNEL_CONTRACT_API, "ContractService", "contractParameterPhoneUpdate");
            req.setParam("contractId", contractId);
            req.setParam("parameter", value);
            this.transferData.postData(req, this.user);
        } else {
            Request req = new Request();
            req.setModule(CONTRACT_MODULE_ID);
            req.setAction("UpdatePhoneInfo");
            req.setContractId(contractId);
            req.setAttribute("pid", paramId);
            List<ParameterPhoneValueItem> phones = phoneValue.getItemList();
            int itemCount = phones.size();
            if (this.dbInfo.versionCompare("5.1") <= 0) {
                itemCount = 5;
            }
            for (int i = 0; i < itemCount; ++i) {
                req.setAttribute("phone" + (i + 1), i < phones.size() ? phones.get(i).getPhone() : "");
                req.setAttribute("comment" + (i + 1), i < phones.size() ? phones.get(i).getComment() : "");
            }
            req.setAttribute("count", itemCount);
            this.transferData.postData(req, this.user);
        }
    }

    public void updateEmailParameter(int contractId, int paramId, Collection<ParameterEmailValue> emailValues) {
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            EntityAttrEmail attrEmail = new EntityAttrEmail(contractId, paramId);
            emailValues.stream().forEach(p -> attrEmail.addContact(p.getComment(), p.getValue()));
            RequestJsonRpc req = new RequestJsonRpc(KERNEL_CONTRACT_API, "ContractService", "contractParameterEmailUpdate");
            req.setParam("contractId", contractId);
            req.setParam("parameter", attrEmail);
            this.transferData.postDataReturn(req, this.user);
        } else {
            Request req = new Request();
            req.setModule(CONTRACT_MODULE_ID);
            req.setAction("UpdateEmailInfo");
            req.setContractId(contractId);
            req.setAttribute("pid", paramId);
            StringBuilder emails = new StringBuilder();
            for (ParameterEmailValue email : emailValues) {
                if (!Utils.isValidEmail(email.getValue())) continue;
                Utils.addSeparated(emails, "\n", email.getComment() + " <" + email.getValue().toLowerCase() + ">");
            }
            req.setAttribute("e-mail", emails);
            req.setAttribute("eid", 0);
            req.setAttribute("buf", "");
            this.transferData.postData(req, this.user);
        }
    }

    public void updateParameterGroup(int contractId, int groupId) {
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(KERNEL_CONTRACT_API, "ContractService", "contractParameterGroupSet");
            req.setParam("contractId", contractId);
            req.setParam("paramGroupId", groupId);
            this.transferData.postDataReturn(req, this.user);
        } else {
            Request req = new Request();
            req.setModule(CONTRACT_MODULE_ID);
            req.setAction("SetGrContract");
            req.setContractId(contractId);
            req.setAttribute("pgid", groupId);
            this.transferData.postData(req, this.user);
        }
    }

    public void copyObjectParamsToContract(Connection con, int objectId, int contractId) throws SQLException, BGMessageException {
        String[] params;
        String copyParamsMapping = this.dbInfo.getSetup().get("copyParamMapping", "");
        if (Utils.isBlankString(copyParamsMapping)) {
            return;
        }
        for (String pair : params = copyParamsMapping.split(";")) {
            String[] keyValue = pair.split(":");
            int fromParamId = Utils.parseInt(keyValue[0].indexOf(91) == -1 ? keyValue[0] : keyValue[0].substring(0, keyValue[0].indexOf(91)));
            this.copyObjectParamToContract(objectId, contractId, fromParamId, con);
        }
    }

    public void copyObjectParamToContract(int objectId, int contractId, int fromParamId, Connection con) throws SQLException, BGMessageException {
        block23: {
            if (objectId == 0 || contractId == 0 || fromParamId == 0) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0445\u043e\u0434\u043d\u044b\u0445 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043f\u0440\u0438 \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0432 \u0431\u0438\u043b\u043b\u0438\u043d\u0433 " + this.dbInfo.getId() + "!", new Object[0]);
            }
            ParamValueDAO paramDAO = new ParamValueDAO(con);
            String copyParamsMapping = this.dbInfo.getSetup().get("copyParamMapping", "");
            if (Utils.isBlankString(copyParamsMapping)) {
                return;
            }
            int toParamId = 0;
            String[] params = copyParamsMapping.split(";");
            String[] keyValue = new String[]{};
            for (String pair : params) {
                keyValue = pair.split(":");
                if (fromParamId != Utils.parseInt(keyValue[0].indexOf(91) == -1 ? keyValue[0] : keyValue[0].substring(0, keyValue[0].indexOf(91)))) continue;
                toParamId = Utils.parseInt(keyValue[1].indexOf(91) == -1 ? keyValue[1] : keyValue[1].substring(0, keyValue[1].indexOf(91)));
                break;
            }
            if (toParamId == 0) {
                return;
            }
            try {
                Object value;
                Request request = new Request();
                request.setModule(CONTRACT_MODULE_ID);
                request.setAttribute("cid", contractId);
                request.setAttribute("pid", toParamId);
                Parameter param = ParameterCache.getParameter(fromParamId);
                if (param == null) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0441 ID=" + fromParamId + " \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!", new Object[0]);
                }
                String type = param.getType();
                if ("address".equals(type)) {
                    SortedMap<Integer, ParameterAddressValue> values = paramDAO.getParamAddress(objectId, fromParamId);
                    if (values.size() > 0) {
                        ParameterAddressValue value2 = (ParameterAddressValue)values.get(values.firstKey());
                        request.setAction("UpdateAddressInfo");
                        request.setAttribute("hid", value2.getHouseId());
                        request.setAttribute("flat", value2.getFlat());
                        request.setAttribute("floor", value2.getFloor() == null ? "" : value2.getFloor());
                        request.setAttribute("pod", value2.getPod());
                        request.setAttribute("room", value2.getRoom());
                        request.setAttribute("comment", value2.getComment());
                        this.transferData.postData(request, this.user);
                    }
                    break block23;
                }
                if ("text".equals(type)) {
                    value = paramDAO.getParamText(objectId, fromParamId);
                    if (Utils.notBlankString((String)value)) {
                        request.setAction("UpdateParameterType1");
                        request.setAttribute("value", value);
                        this.transferData.postData(request, this.user);
                    }
                    break block23;
                }
                if ("list".equals(type)) {
                    Set<Integer> listValue = paramDAO.getParamList(objectId, fromParamId);
                    if (listValue == null || listValue.size() <= 0) break block23;
                    String fromValue = listValue.iterator().next().toString();
                    String toValue = null;
                    if (keyValue[0].indexOf(91) > 0) {
                        String[] fromValues = keyValue[0].substring(keyValue[0].indexOf(91) + 1, keyValue[0].indexOf(93)).split(",");
                        String[] toValues = keyValue[1].substring(keyValue[1].indexOf(91) + 1, keyValue[1].indexOf(93)).split(",");
                        for (int i = 0; i < fromValues.length; ++i) {
                            if (!fromValues[i].equals(fromValue)) continue;
                            toValue = toValues[i];
                            break;
                        }
                    } else {
                        toValue = fromValue;
                    }
                    if (Utils.notBlankString(toValue)) {
                        new ContractParamDAO(this.user, this.dbInfo).updateListParameter(contractId, toParamId, toValue);
                    }
                    break block23;
                }
                if ("phone".equals(type)) {
                    value = paramDAO.getParamPhone(objectId, fromParamId);
                    if (value != null) {
                        new ContractParamDAO(this.user, this.dbInfo).updatePhoneParameter(contractId, toParamId, (ParameterPhoneValue)value);
                    }
                } else if ("date".equals(type)) {
                    value = paramDAO.getParamDate(objectId, fromParamId);
                    if (value != null) {
                        new ContractParamDAO(this.user, this.dbInfo).updateDateParameter(contractId, toParamId, (Date)value);
                    }
                } else if ("email".equals(type) && (value = paramDAO.getParamEmail(objectId, fromParamId)).size() > 0) {
                    new ContractParamDAO(this.user, this.dbInfo).updateEmailParameter(contractId, toParamId, value.values());
                }
            }
            catch (BGException exp) {
                throw new BGMessageExceptionWithoutL10n("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0432 \u0431\u0438\u043b\u043b\u0438\u043d\u0433! [" + fromParamId + " - " + toParamId + "] " + exp.getMessage(), new Object[0]);
            }
        }
    }
}

