/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.bgerp.app.exception.BGException;
import org.bgerp.util.Log;
import org.w3c.dom.Document;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.Request;
import ru.bgcrm.plugin.bgbilling.TransferData;

public class RequestToBilling
implements Runnable {
    private static final Log log = Log.getLog();
    private String key;
    private Request request;
    private User user;
    private Map<String, Document> resultDocs;
    private TransferData transferData;
    private AtomicInteger taskCount;

    public RequestToBilling(TransferData transferData, User user, Request req) {
        this.transferData = transferData;
        this.user = user;
        this.request = req;
    }

    public RequestToBilling(AtomicInteger taskCount, TransferData transferData, String dbKey, User user, Request req, Map<String, Document> resultDocs) {
        this(transferData, user, req);
        this.resultDocs = resultDocs;
        this.taskCount = taskCount;
        this.key = dbKey;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public void run() {
        Document document = null;
        try {
            document = this.transferData.postData(this.request, this.user);
        }
        catch (BGException exception) {
            log.error(exception);
        }
        this.resultDocs.put(this.key, document);
        if (this.taskCount != null) {
            this.taskCount.decrementAndGet();
        }
    }
}

