/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.model.process;

import org.bgerp.app.cfg.ConfigMap;
import ru.bgcrm.util.Utils;

public class TransactionProperties {
    public static final TransactionProperties ENABLED = new TransactionProperties(true);
    private boolean enable = true;
    private String reference = "";

    public TransactionProperties(boolean enabled) {
        this.enable = enabled;
    }

    public TransactionProperties(ConfigMap data, String prefix) {
        this.enable = data.getBoolean(prefix + "enable", true);
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public void serializeToData(StringBuilder data, String prefix) {
        Utils.addSetupPair(data, prefix, "enable", Utils.booleanToStringInt(this.enable));
        data.append("#\n");
    }

    public static class TransactionKey {
        public int fromStatus;
        public int toStatus;

        public TransactionKey(int fromStatus, int toStatus) {
            this.fromStatus = fromStatus;
            this.toStatus = toStatus;
        }

        public TransactionKey(String fromToStatus) {
            String[] from_to_status = fromToStatus.split("\\-");
            this.fromStatus = Utils.parseInt(from_to_status[0]);
            this.toStatus = Utils.parseInt(from_to_status[1]);
        }

        public boolean equals(Object obj) {
            TransactionKey key = (TransactionKey)obj;
            return key.fromStatus == this.fromStatus && key.toStatus == this.toStatus;
        }

        public int hashCode() {
            return this.fromStatus;
        }
    }
}

