/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.model.customer;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.bgerp.cache.CustomerGroupCache;
import org.bgerp.dao.param.ParamGroupDAO;
import org.bgerp.util.Log;
import ru.bgcrm.dao.PatternDAO;
import ru.bgcrm.model.SearchableIdTitle;
import ru.bgcrm.model.customer.CustomerGroup;
import ru.bgcrm.model.param.ParameterGroup;

public class Customer
extends SearchableIdTitle
implements Comparable<Customer> {
    private static final Log log = Log.getLog();
    public static final String OBJECT_TYPE = "customer";
    private String reference;
    private String password;
    private int titlePatternId = -1;
    private String titlePattern = "";
    private int paramGroupId = 0;
    private Date createTime;
    private int createUserId = -1;
    private Set<Integer> groupIds;

    public String getReference() {
        return this.reference;
    }

    public void setReference(String uniqueKeys) {
        this.reference = uniqueKeys;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getTitlePatternId() {
        return this.titlePatternId;
    }

    public void setTitlePatternId(int titlePatternId) {
        this.titlePatternId = titlePatternId;
    }

    public String getTitlePattern() {
        return this.titlePattern;
    }

    public void setTitlePattern(String titlePattern) {
        this.titlePattern = titlePattern;
    }

    public int getParamGroupId() {
        return this.paramGroupId;
    }

    public void setParamGroupId(int paramGroupId) {
        this.paramGroupId = paramGroupId;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date value) {
        this.createTime = value;
    }

    @Deprecated
    @JsonIgnore
    public Date getCreatedDate() {
        log.warndMethod("getCreatedDate", "getCreateDate");
        return this.getCreateTime();
    }

    @Deprecated
    public void setCreatedDate(Date value) {
        log.warndMethod("setCreatedDate", "setCreateDate");
        this.setCreateTime(value);
    }

    public int getCreateUserId() {
        return this.createUserId;
    }

    public void setCreateUserId(int value) {
        this.createUserId = value;
    }

    @Deprecated
    @JsonIgnore
    public int getCreatedUserId() {
        log.warndMethod("getCreatedUserId", "getCreateUserId");
        return this.getCreateUserId();
    }

    @Deprecated
    public void setCreatedUserId(int value) {
        log.warndMethod("setCreatedUserId", "setCreateUserId");
        this.setCreateUserId(value);
    }

    public Set<Integer> getGroupIds() {
        return this.groupIds;
    }

    public void setGroupIds(Set<Integer> groupIds) {
        this.groupIds = groupIds;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[ id=");
        str.append(this.getId());
        str.append(", title=");
        str.append(this.getTitle());
        str.append(", createDate=");
        str.append(this.getCreateTime());
        str.append(", createUserId=");
        str.append(this.getCreateUserId());
        str.append(" ]");
        return str.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return ((Customer)obj).getId() == this.id;
    }

    @Override
    public int compareTo(Customer o) {
        return o.getTitle().compareTo(this.title);
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    public String toLog(Connection con, Customer oldCustomer) throws SQLException {
        StringBuffer result = new StringBuffer();
        if (this.groupIds != null && oldCustomer.getGroupIds() != null && !CollectionUtils.isEqualCollection(this.groupIds, oldCustomer.getGroupIds())) {
            Object textGroups = "";
            Map<Integer, CustomerGroup> groups = CustomerGroupCache.getGroupMap();
            for (Integer item : this.groupIds) {
                textGroups = (String)textGroups + groups.get(item).getTitle() + ", ";
            }
            if (((String)textGroups).length() > 0) {
                textGroups = ((String)textGroups).substring(0, ((String)textGroups).length() - 2);
                result.append("\u0413\u0440\u0443\u043f\u043f\u044b: [" + (String)textGroups + "]; ");
            } else {
                result.append("\u0413\u0440\u0443\u043f\u043f\u044b: []; ");
            }
        }
        if (this.title != null && oldCustomer.getTitle() != null && !this.title.equals(oldCustomer.getTitle()) && this.title.length() > 0) {
            result.append("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: " + this.title + "; ");
        }
        if (this.paramGroupId != oldCustomer.getParamGroupId()) {
            ParamGroupDAO paramGroupDAO = new ParamGroupDAO(con);
            ParameterGroup paramGroup = paramGroupDAO.getParameterGroup(this.paramGroupId);
            if (paramGroup != null) {
                result.append("\u0413\u0440\u0443\u043f\u043f\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432: " + paramGroupDAO.getParameterGroup(this.paramGroupId).getTitle() + "; ");
            } else {
                result.append("\u0413\u0440\u0443\u043f\u043f\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432: \u0433\u0440\u0443\u043f\u043f\u0430 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430; ");
            }
        }
        if (this.titlePatternId != oldCustomer.getTitlePatternId()) {
            String patternTitle = "";
            PatternDAO patternDAO = new PatternDAO(con);
            switch (this.titlePatternId) {
                case -1: {
                    patternTitle = "\u0411\u0435\u0437 \u0448\u0430\u0431\u043b\u043e\u043d\u0430";
                    break;
                }
                case 0: {
                    patternTitle = "\u041f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0439 \u0448\u0430\u0431\u043b\u043e\u043d";
                    break;
                }
                default: {
                    patternTitle = patternDAO.getPattern(this.titlePatternId).getTitle();
                }
            }
            result.append("\u0428\u0430\u0431\u043b\u043e\u043d \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f: " + patternTitle + "; ");
        }
        if (this.titlePattern != null && oldCustomer.getTitlePattern() != null && this.titlePattern.length() > 0 && !this.titlePattern.equals(oldCustomer.getTitlePattern())) {
            result.append("\u041f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0439 \u0448\u0430\u0431\u043b\u043e\u043d \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f: " + this.titlePattern + "; ");
        }
        return result.toString();
    }
}

