/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.event.listener;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.util.Log;
import ru.bgcrm.event.GetPoolTasksEvent;
import ru.bgcrm.event.client.TemporaryObjectEvent;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

public class TemporaryObjectOpenListener
extends Thread {
    private static final Log log = Log.getLog();
    private static final long SLEEP_TIME = 10000L;
    private Set<Integer> tasksForUserLoad = Collections.newSetFromMap(new ConcurrentHashMap());
    private static Map<Integer, Set<Integer>> userTempProcessMapIds = new ConcurrentHashMap<Integer, Set<Integer>>();

    public TemporaryObjectOpenListener() {
        EventProcessor.subscribe((e, conSet) -> this.processListener(e.getForm(), conSet), GetPoolTasksEvent.class);
        this.start();
    }

    private void processListener(DynActionForm form, ConnectionSet conSet) {
        int userId = form.getUserId();
        Set<Integer> processIds = userTempProcessMapIds.get(userId);
        if (processIds == null) {
            this.tasksForUserLoad.add(userId);
        } else {
            form.getResponse().addEvent(new TemporaryObjectEvent(processIds));
        }
    }

    public static void flushUserData(int userId) {
        userTempProcessMapIds.remove(userId);
    }

    @Override
    public void run() {
        try {
            while (true) {
                if (this.tasksForUserLoad.size() > 0) {
                    HashSet<Integer> userIds = new HashSet<Integer>(this.tasksForUserLoad);
                    this.tasksForUserLoad.clear();
                    try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
                        String query = "SELECT create_user_id, id FROM  process  AS process WHERE id<0 AND create_user_id IN (" + Utils.toString(userIds) + ")";
                        PreparedStatement ps = con.prepareStatement(query);
                        ResultSet rs = ps.executeQuery();
                        while (rs.next()) {
                            int userId = rs.getInt(1);
                            int processId = rs.getInt(2);
                            Set<Integer> existUserSet = userTempProcessMapIds.get(userId);
                            if (existUserSet == null) {
                                existUserSet = new HashSet<Integer>();
                                userTempProcessMapIds.put(userId, existUserSet);
                            }
                            existUserSet.add(processId);
                            log.debug("User: {}; found temp process: {}", userId, processId);
                            userIds.remove(userId);
                        }
                        ps.close();
                    }
                    catch (Exception e) {
                        log.error(e);
                    }
                    Set empty = Collections.emptySet();
                    for (Integer userId : userIds) {
                        userTempProcessMapIds.put(userId, empty);
                    }
                }
                TemporaryObjectOpenListener.sleep(10000L);
            }
        }
        catch (Exception e) {
            log.error(e);
            return;
        }
    }
}

