/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.util;

import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.util.Date;

public class TimeConvert {
    private static final LocalTime ZERO_TIME = LocalTime.of(0, 0);

    public static final YearMonth toYearMonth(Date value) {
        return value != null ? YearMonth.from(Instant.ofEpochMilli(value.getTime()).atZone(ZoneId.systemDefault()).toLocalDate()) : null;
    }

    public static final Date toDate(YearMonth value) {
        return value != null ? Date.from(value.atDay(1).atStartOfDay(ZoneId.systemDefault()).toInstant()) : null;
    }

    public static final Date toDate(LocalDate value) {
        return value != null ? Date.from(value.atStartOfDay(ZoneId.systemDefault()).toInstant()) : null;
    }

    public static final LocalDate toLocalDate(Date value) {
        if (value == null) {
            return null;
        }
        return Instant.ofEpochMilli(value.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static final Timestamp toTimestamp(Date value) {
        if (value == null) {
            return null;
        }
        return new Timestamp(value.getTime());
    }

    public static final Instant toInstant(LocalDateTime value) {
        return value == null ? null : value.atZone(ZoneId.systemDefault()).toInstant();
    }

    public static Duration toDuration(LocalTime value) {
        return Duration.between(ZERO_TIME, value);
    }

    public static LocalTime toLocalTime(Duration duration) {
        return ZERO_TIME.plus(duration);
    }
}

